<style>
    @import url('https://fonts.googleapis.com/css?family=Open+Sans');
@import url('https://fonts.googleapis.com/css?family=Montserrat');

body {
    font-family: 'Montserrat', sans-serif;

}

/* Category Ads */
.card.card-product-grid, .card.card-product-list {
  box-shadow: 0 1px 2px rgba(51,51,51,.07);
}
.card-product-grid {
  margin-bottom: 20px;
  box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
}
.card2 {
    position: relative;
display: -webkit-box;
display: -ms-flexbox;
display: flex;
-webkit-box-orient: vertical;
-webkit-box-direction: normal;
-ms-flex-direction: column;
flex-direction: column;
min-width: 0;
word-wrap: break-word;
background-color: #fff;
background-clip: border-box;
border: 1px solid rgba(0, 0, 0, 0.125);
border-radius: 0.25rem;
}
.card3 {
  margin-bottom: 0;
  padding: 0px 20px 0px;
}
[class*="dlist-"] {
  margin-bottom: 5px;
}
[class*="dlist-"] dd {
  margin-bottom: 0;
}
.dlist-align dd {
  margin-left: 120px;
  vertical-align: baseline;
}
.dlist-align dt {
  width: 126px;
  float: left;
  word-wrap: break-word;
}
.shipVal{
    width: 50px;
}
.discVal{
    width: 50px;
}
.img-wrap {
  position: relative;
  text-align: center;
  overflow: hidden;
  display: block;
}
[class*="card-product"] .img-wrap img {
  height: 120px;
  max-width: 250px;
  max-height: 250px;
  width: 120px;
}
.img-wrap img {
  -o-object-fit: cover;
  object-fit: contain;
}
.card-product-grid .info-wrap {

  overflow: hidden;
}
.btn-light {
  background-color: #fff;
  border-color: #dee2e6;
  color: #212529;
}
.btn-icon {
  width: 2.6rem;
  padding-left: 0px;
  padding-right: 0px;
}
[class*="card-product"] a.title {
  display: block;
  text-decoration: none;
}
.box {
  padding: 1rem 1.2rem;
  display: block;
  background: #fff;
  border-radius: 0.2rem;
  -webkit-box-shadow: 0 1px 3px rgba(51, 51, 51, 0.1);
  box-shadow: 0 1px 3px rgba(51, 51, 51, 0.1);
}
.card-product-grid .title {
  color: #51585e;
}
.text-truncate {
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}
.bg-success {
  background-color: #00a524 !important;
}
.badge {
  display: inline-block;
  padding: .32em .7em;
  font-size: 0.83em;
  font-weight: 400;
  line-height: .9;
  color: #fff;
  text-align: center;
  white-space: nowrap;
  vertical-align: baseline;
  border-radius: .25rem;
}
.title {
  font-weight: bold;
  font-size: 12px;
  line-height: 15px;
  white-space: normal;
}
[class*="card-product"] .price-old {
  color: #9da1a7;
  margin-left: 3px;
  font-size: 90%;
}
.card-product-grid .topbar {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  z-index: 10;
  text-align: left;
  padding: 10px 15px;
}
.card-product-grid .topbar2 {
  position: absolute;
  top: 0;
  right: 0;
  width: 100%;
  z-index: 10;
  text-align: right;
  padding: 10px 15px;
}

.card-product-grid .topbar4 {
  position: absolute;
  top: 0;
  right: 0;
  width: 100%;
  z-index: 10;
  text-align: center;
  padding: 10px 15px;
}
#ads {
    margin: 0px 0 30px 0;
   
}
footer {
    position: fixed;
    height: 100px;
    bottom: 0;
    width: 100%;
}
.table.table-padded {
  border-collapse: separate;
  border-spacing: 0 5px;
}
table {
  width: 100%;
}


thead {
  display: table; /* to take the same width as tr */
  width: calc(100% - 17px); /* - 17px because of the scrollbar width */
}

tbody {
  display: block; /* to enable vertical scrolling */
  max-height: 990px; /* e.g. */
  overflow-y: scroll; /* keeps the scrollbar even if it doesn't need it; display purpose */
}


td {
  text-align: center;
  border-bottom: none;
  border-left: none;
}
#ads .card-notify-badge {
        position: absolute;
        left: -10px;
        top: 0px;
        text-align: left;
        border-radius: 30px 30px 30px 30px; 
        color: #000;
        padding: 5px 10px;
        font-size: 14px;

    }

#ads .card-notify-year {
        position: absolute;
        right: -10px;
        top: -20px;
        background: #ff4444;
        border-radius: 50%;
        text-align: center;
        color: #fff;      
        font-size: 14px;      
        width: 50px;
        height: 50px;    
        padding: 15px 0 0 0;
}


#ads .card-detail-badge {      
        background: #f2d900;
        text-align: center;
        border-radius: 30px 30px 30px 30px;
        color: #000;
        padding: 5px 10px;
        font-size: 14px;        
    }

   

#ads .card:hover {
            background: #fff;
            box-shadow: 12px 15px 20px 0px rgba(46,61,73,0.15);
            border-radius: 4px;
            transition: all 0.3s ease;
        }

#ads .card-image-overlay {
        font-size: 20px;
        
    }


#ads .card-image-overlay span {
            display: inline-block;              
        }


#ads .ad-btn {
        text-transform: uppercase;
        width: 150px;
        height: 40px;
        border-radius: 80px;
        font-size: 16px;
        line-height: 35px;
        text-align: center;
        border: 3px solid #e6de08;
        display: block;
        text-decoration: none;
        margin: 20px auto 1px auto;
        color: #000;
        overflow: hidden;        
        position: relative;
        background-color: #e6de08;
    }

#ads .ad-btn:hover {
            background-color: #e6de08;
            color: #1e1717;
            border: 2px solid #e6de08;
            background: transparent;
            transition: all 0.3s ease;
            box-shadow: 12px 15px 20px 0px rgba(46,61,73,0.15);
        }

#ads .ad-title h5 {
        text-transform: uppercase;
        font-size: 18px;
    }
</style>
<section class="section-content padding-y-sm bg-default">
<form method="post" id="data_form">
    <div class="container-fluid">
        <div class="row">    
            
            <div class="col-md-6">
                <div class="card card3">
                    <div class="row">
                    <div class="col-sm-12">
                            <label for="pterms" class="caption">Cliente</label>
                            <div class="input-group">
                                <input type="text" class="form-control mousetrap" name="cst" id="pos-customer-box" onkeyup="handle(event)" placeholder="<?php echo $this->lang->line('Enter Customer Name'); ?> " autocomplete="off" />
                                <div class="input-group-prepend">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#Pos_addCustomer">
                                        <span class="input-group-text btn-primary btn-block" id="inputGroup-sizing-default">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                    </a>
                                </div>
                            </div>
                            <div class="row ml-3">
                            <div id="customer-box-result" class="col-md-12"></div>
                            <div id="customer" class="col-md-12 ml-3">
                                <div class="clientinfo">
                                    <input type="hidden" name="customer_id" id="customer_id" value="<?= $invoice['id'] ?>">
                                    <input type="hidden" name="idtipodoc" id="idtipodoc" value="<?= $invoice['iddoc'] ?>">
                                    <!--<div id="customer_name"><?= $invoice['name'] ?> </strong></div>-->
                                </div>
                            </div>
                        </div>
                                    <hr>
                        </div>
                        <div class="col-sm-3">
                            <label for="invocieserie" class="caption">Tipo Comprobante</label>
                            <select name="tipocomp" id="tipocomp" class="selectpicker form-control" onchange="cargarserie()">
                                <?php
                                foreach ($tpcomp as $row) {
                                echo '<option value="' . $row['idtipocomprobante'] . '">' . $row['nombre_docu'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-sm-3">
                            <label for="invocieserie" class="caption">Serie</label>
                            <select name="serie" id="serie" class="selectpicker form-control" onchange="cargarcorrelativo()"></select>
                        </div>
                        <div class="col-sm-3">
                            <label for="invocieno" class="caption">Correlativo</label>
                            <input type="text" class="form-control" placeholder="Correlativo" name="invocieno" id="invocieno">
                        </div>
                        <div class="col-sm-3">
                            <label for="tipop" class="caption">Tipo de Operación</label>
                            <select name="tipop" class="selectpicker form-control">
                                <?php
                                foreach ($tipop as $row) {
                                echo '<option value="' . $row['id'] . '">' . $row['descripcion'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-sm-3">
                                <label for="invociedate" class="caption">Fecha de Emision</label>
                                <input type="text" class="form-control required" placeholder="Fecha de facturación" name="invoicedate" data-toggle="datepicker" autocomplete="false">
                                
                        </div>
                            <div class="col-sm-3">
                                <label for="invocieduedate" class="caption">Fecha Venc.</label>
                                <input type="text" class="form-control required" id="tsn_due" name="invocieduedate" placeholder="Due Date" data-toggle="datepicker" autocomplete="false">
                                
                            </div>
                            <div class="col-sm-3">
                                <label for="invocieno" class="caption">Referencia</label>
                                <input type="text" class="form-control" placeholder="# de Referencia" name="refer">
                                
                            </div>
                            <div class="col-sm-3">
                                <label for="pterms" class="caption">Condición de Pago</label>

                                <select name="pterms" class="selectpicker form-control">
                                    <?php
                                    foreach ($terms as $row) {
                                        echo '<option value="' . $row['id'] . '">' . $row['title'] . '</option>';
                                    }
                                    ?>
                                </select>
                                <?php
                                if ($exchange['active'] == 1) {
                                    echo $this->lang->line('Payment Currency client')
                                ?>
                                <?php } ?>
                                <?php if ($exchange['active'] == 1) {
                                ?>
                                    <select name="mcurrency" class="selectpicker form-control">
                                        <option value="0">Predeterminado</option>
                                        <?php
                                        foreach ($currency as $row) {
                                            echo '<option value="' . $row['id'] . '">' . $row['symbol'] . ' (' . $row['code'] . ')</option>';
                                        }
                                        ?>

                                    </select><?php } ?>
                                    <br>
                            </div>
                        
                        <?php if ($emp['key1']) { ?>
                    <div class="col-sm-12">
                        <div class="form-group form-group-sm">
                            <label for="employee"><?php echo $this->lang->line('Employee') ?></label>
                            <select id="employee" name="employee" class="form-control form-control-sm">
                                <?php
                                foreach ($employee as $row) {
                                    $cid = $row['id'];
                                    $title = $row['name'];
                                    echo "<option value='$cid'>$title</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <?php } ?>
                
                            
                            <div class="col-sm-4">
                            
                                <div class="form-check form-switch">
                                    <input class="form-check-input" name="guiaCheck" type="checkbox" role="switch" id="guia">
                                    <label class="form-check-label" for="guia">Guía de Remisión</label>
                                </div>
                            </div>
                            <div id="gserie" class="col-sm-4">
                               
                                <select name="serieg" id="serieg" class="selectpicker form-control" onchange="cargarcorrelativog()">
                                </select>
                                <input type="hidden" id="idsguia" name="idsguia" value="">
                            </div>

                            <div id="gcorrelativo" class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Correlativo" name="correlativog" id="correlativog">
                            </div>
                        
                            
                    </div>
                    <span id="">
                        <div id="saman-row-pos" class="table-responsive">
                            <table id="pos_list" class="table mt-2 table-fixed">
                                <thead class="text-muted">
                                    <tr>
                                        <th>CANT.</th>
                                        <th>PRECIO</th>
                                        <th style="visibility:collapse; display:none;">T. Precio</th>
                                        <th style="visibility:collapse; display:none;">T. Afect.</th>
                                        <th>% IGV</th>
                                        <th>DESC.</th>
                                        <th>ICBPER</th>
                                        <th>IMP.</th>
                                        <th>ELIMINAR</th>
                                    </tr>
                                </thead>
                                <tbody id="pos_items">

                                </tbody>
                            </table>
                        </div>
                    </span>
                </div> <!-- card.// -->
                <div class="box">
                    <dl class="dlist-align">
                        <dt>Sub Total: </dt>
                        <dd class="text-right" id="subttlform2"><?php echo $this->config->item('currency'); ?> 0</dd>
                        <input class="form-control" type="hidden" value="0" id="subttlform" name="subtotal">
                        <input type="hidden" value="0" id="custom_discount">
                    </dl>
                    <dl class="dlist-align">
                        <dt>Descuento:</dt>
                        <span class="currenty">
                                <?php
                                
                                if (isset($_GET['project'])) {
                                    echo '<input type="hidden" value="' . intval($_GET['project']) . '" name="prjid">';
                                }
                                ?>
                            </span>
                        <dd class="text-right" id="discs"><?php echo $this->config->item('currency'); ?> 0</dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>Valor Venta:</dt>
                        <dd class="text-right"><?php echo $this->config->item('currency'); ?> 0</dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>ISC: </dt>
                        <dd class="text-right"><?php echo $this->config->item('currency'); ?> 0 </dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>IGV: </dt>
                        <dd class="text-right" id="taxr"><?php echo $this->config->item('currency'); ?> 0 </dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>ICBPER: </dt>
                        <dd class="text-right" id="icbpertotal2"><?php echo $this->config->item('currency'); ?> 0 </dd>
                        <input type="hidden" class="form-control" name="icbpertotal" id="icbpertotal" value="0" class="lightMode" readonly="">
                        <input type="hidden" value="0" id="custom_icbper">
                    </dl>
                    <dl class="dlist-align">
                        <dt>Otros Cargos: </dt>
                        
                        <dd class="text-right"><?php echo $this->config->item('currency'); ?> <input type="text" class="shipVal" onkeypress="return isNumber(event)" placeholder="Valor" name="shipping" autocomplete="off" onkeyup="billUpyog()"> 
                        </dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>Otros Tributos: </dt>
                        <dd class="text-right"><?php echo $this->config->item('currency'); ?> 0 </dd>
                    </dl>
                    <dl class="dlist-align">
                        <dt>Descuento Extra: </dt>
                        <dd class="text-right">
                        <?php echo $this->config->item('currency'); ?>
                        <input type="text" class="discVal" onkeypress="return isNumber(event)" placeholder="Valor" name="disc_val" autocomplete="off" value="0" onkeyup="billUpyog()">
                        <input type="hidden" value="0" name="after_disc" id="after_disc">
                        </dd>
                        
                    </dl>
                    <dl class="dlist-align">
                        <dt>Total: </dt>
                        <dd class="text-right h4 b" id="invoiceyoghtml2"><?php echo $this->config->item('currency'); ?> 0 </dd>
                        <input type="hidden" name="total" class="form-control" id="invoiceyoghtml" readonly="">
                    </dl>
                    <div class="row">
                    <div class="col-sm-12">
                            <label for="invocieserie" class="caption">Cupón</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="coupon" name="coupon">
                                <input type="hidden" name="coupon_amount" id="coupon_amount" value="0">
                                <button class="apply_coupon btn btn-small btn-primary sub-btn"><?php echo $this->lang->line('Apply') ?></button>
                            </div>
                            <input type="hidden" class="text-info" name="i_coupon" id="i_coupon" value="">
                            <span class="text-primary text-bold-600" id="r_coupon"></span>
                        </div>
                    <div class="col-sm-12">
                                <label for="toAddInfo" class="caption">Observaciones</label>
                                <textarea class="form-control" name="notes" rows="3"></textarea>
                                <hr>
                            </div>
                            
	                    <div class="col-md-4">
                            
                            <a href="#" class="possubmit btn btn-lg btn-cyan sub-btn btn-block" data-type="6"><i class="fa fa-save"></i> Borrador</a>
                        </div>
                        <div class="col-md-4">
                            <a href="#" class="possubmit3 btn btn-lg btn-success sub-btn btn-block" data-type="6" data-toggle="modal" data-target="#basicPay"><i class="fa fa-money"></i> Pagar</a>
                        </div>
                        <?php if ($enable_card['url']) { ?>
                        <div class="col-md-4">
                            <a href="#" class="possubmit2 btn btn-lg btn-blue-grey sub-btn btn-block" data-type="4" data-toggle="modal" data-target="#cardPay"><i class="fa fa-credit-card"></i> Tarjeta
                            </a>
                        </div>
                        <?php } ?>
                    </div>
                    
                    
                </div> <!-- box.// -->
            </div>
            <div class="col-md-6 card padding-y-sm card">
                <div class="row">
                <div class="col-sm-4 blue text-xs-center"><?php echo $this->lang->line('Warehouse') ?>
                                <select id="warehouses" name="almacenid" class="selectpicker form-control round teal">
                                    <?php
                                    echo $this->common->default_warehouse();
                                    echo '<option value="0">' . $this->lang->line('All')
                                    ?></option><?php
                                                foreach ($warehouse as $row) {
                                                    echo '<option value="' . $row['id'] . '">' . $row['title'] . '</option>';
                                                }
                                                ?>

                                </select>
                            </div>
                            <div class="col-sm-4 blue text-xs-center"><?php echo $this->lang->line('Tax') ?>
                                <select class="form-control round" onchange="changeTaxFormat(this.value)" id="taxformat">
                                    <?php echo $taxlist; ?>
                                </select>
                            </div>
                            <div class="col-sm-4 blue text-xs-center"> <?php echo $this->lang->line('Discount') ?>
                                <select class="form-control round teal" onchange="changeDiscountFormat(this.value)" id="discountFormat">
                                    <?php echo $this->common->disclist() ?>
                                </select>
                            </div>
                            
                </div>
                <div class="input-group mt-3">
                    <input type="text" class="form-control text-center" name="product_barcode" placeholder="Ingrese el nombre del producto o escanee el código de barras " id="search_bar" autocomplete="off" autofocus="autofocus">
                    <div class="input-group-prepend">
                        <a href="javascript:void(0)" data-toggle="modal" data-target="#Pos_addProduct">
                            <span class="input-group-text btn-primary btn-block" id="inputGroup-sizing-default">
                                <i class="fa fa-plus-circle"></i>
                            </span>
                        </a>
                    </div>
                </div>
                <ul class="nav bg radius nav-pills nav-fill mb-3 bg" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active show" data-toggle="pill" data-cat="0" href="#nav-tab-card">
                            <i class="fa fa-tags"></i> Todas</a></li>
                            <?php
                            foreach ($cat as $row) {
                                $cid = $row['id'];
                                $title = $row['title'];
                                echo "<li class='nav-item'><a class='nav-link' data-toggle='pill' data-cat=".$cid." href='#nav-tab-card'><i class='fa fa-tags'></i>".$title."</a></li>";
                            }
                            ?>
                </ul>
                <span id="items">
                    <div class="row" id="ads">
                        <div id="pos_item">
                            <!-- pos items -->
                        </div>
                    </div>
                </span>
            </div>
        </div>
    </div><!-- container //  -->
            

                <!--
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="btn btn-outline-danger  mr-1 mb-1" id="base-tab3" data-toggle="tab" aria-controls="tab3" href="#tab3" role="tab" aria-selected="false"><i class="fa fa-save"></i> <?php echo $this->lang->line('Draft') ?>(es)</a>
                    </li>
                </ul>
                <div class="tab-content px-1 pt-1">
                    <div class="tab-pane" id="tab3" role="tabpanel" aria-labelledby="base-tab3">
                        <?php
                        foreach ($draft_list as $rowd) {
                            echo '<li class="indigo p-1"><a href="' . base_url() . 'pos_invoices/draft?id=' . $rowd['id'] . '"> #' . $rowd['tid'] . ' (' . $rowd['invoicedate'] . ')</a></li>';
                        }
                        ?>
                    </div>
                    
                </div>
                    -->
    </div>
    <input type="hidden" value="pos_invoices/action?v2=true" id="action-url">
    <input type="hidden" value="search" id="billtype">
    <input type="hidden" value="0" name="counter" id="ganak">
    <input type="hidden" value="<?php echo $this->config->item('currency'); ?>" name="currency">
    <input type="hidden" value="<?= $taxdetails['handle']; ?>" name="taxformat" id="tax_format">
    <input type="hidden" value="<?= $taxdetails['format']; ?>" name="tax_handle" id="tax_status">
    <input type="hidden" value="yes" name="applyDiscount" id="discount_handle">
    <input type="hidden" value="<?= $this->common->disc_status()['disc_format']; ?>" name="discountFormat" id="discount_format">
    <input type="hidden" value="<?= amountFormat_general($this->common->disc_status()['ship_rate']); ?>" name="shipRate" id="ship_rate">
    <input type="hidden" value="<?= $this->common->disc_status()['ship_tax']; ?>" name="ship_taxtype" id="ship_taxtype">
    <input type="hidden" value="0" name="ship_tax" id="ship_tax">
</form>
</section>



<!--card-->

<script src="<?php echo assets_url('assets/myjs/jquery.ui.widget.js'); ?>"></script>
<script src="<?php echo assets_url('assets/myjs/jquery.fileupload.js') ?>"></script>
<script>
    /*jslint unparam: true */
    /*global window, $ */
    $(function() {
        'use strict';
        // Change this to the location of your server-side upload handler:
        var url = '<?php echo base_url() ?>products/file_handling';
        $('#fileupload').fileupload({
                url: url,
                dataType: 'json',
                formData: {
                    '<?= $this->security->get_csrf_token_name() ?>': crsf_hash
                },
                done: function(e, data) {
                    var img = 'default.png';
                    $.each(data.result.files, function(index, file) {
                        $('#files').html('<tr><td><a data-url="<?php echo base_url() ?>products/file_handling?op=delete&name=' + file.name + '" class="aj_delete"><i class="btn-danger btn-sm icon-trash-a"></i> ' + file.name + ' </a><img style="max-height:200px;" src="<?php echo base_url() ?>userfiles/product/' + file.name + '"></td></tr>');
                        img = file.name;
                    });

                    $('#image').val(img);
                },
                progressall: function(e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $('#progress .progress-bar').css(
                        'width',
                        progress + '%'
                    );
                }
            }).prop('disabled', !$.support.fileInput)
            .parent().addClass($.support.fileInput ? undefined : 'disabled');
    });

    $(document).on('click', ".aj_delete", function(e) {
        e.preventDefault();

        var aurl = $(this).attr('data-url');
        var obj = $(this);

        jQuery.ajax({

            url: aurl,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                obj.closest('tr').remove();
                obj.remove();
            }
        });

    });



    $("#unidad").val('NIU');

    $('#inlineRadio2').on('click', function() {

        $("#stockp").attr('disabled', 'disabled');
        $("#cantal").attr('disabled', 'disabled');
        $("#stockp").removeClass('required');
        $("#unidad").val('ZZ');
    });

    $('#inlineRadio1').on('click', function() {
        $("#stockp").removeAttr('disabled');
        $("#cantal").removeAttr('disabled');
        $("#stockp").addClass('required');
        $("#unidad").val('NIU');
    });

    $('#icbpersi').on('click', function() {

        $("#product_icbper").removeAttr('disabled');
        $("#product_icbper").addClass('required');

    });

    $('#icbperno').on('click', function() {
        $("#product_icbper").attr('disabled', 'disabled');
        $("#product_icbper").removeClass('required');
    });

    $(document).on('click', ".tr_clone_add", function(e) {
        e.preventDefault();
        var n_row = $('#v_var').find('tbody').find("tr:last").clone();

        $('#v_var').find('tbody').find("tr:last").after(n_row);

    });
    $(document).on('click', ".tr_clone_add_w", function(e) {
        e.preventDefault();
        var n_row = $('#w_var').find('tbody').find("tr:last").clone();

        $('#w_var').find('tbody').find("tr:last").after(n_row);

    });

    $(document).on('click', ".tr_delete", function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
    });


    //$("#sub_cat").select2();
    $("#product_cat").on('change', function() {
        $("#sub_cat").val('').trigger('change');
        var tips = $('#product_cat').val();
        $("#sub_cat").select2({

            ajax: {
                url: baseurl + 'products/sub_cat?id=' + tips,
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: function(product) {
                    return {
                        product: product,
                        '<?= $this->security->get_csrf_token_name() ?>': crsf_hash
                    };
                },
                processResults: function(data) {
                    return {
                        results: $.map(data, function(item) {
                            return {
                                text: item.title,
                                id: item.id
                            }
                        })
                    };
                },
            }
        });
    });
    $(document).on('click', ".v_delete_serial", function(e) {
        e.preventDefault();
        $(this).closest('div .serial').remove();
    });
    $(document).on('click', ".add_serial", function(e) {
        e.preventDefault();

        $('#added_product').append('<div class="form-group serial"><label for="field_s" class="col-lg-2 control-label"><?= $this->lang->line('serial') ?></label><div class="col-lg-10"><input class="form-control box-size" placeholder="<?= $this->lang->line('serial') ?>" name="product_serial[]" type="text"  value=""></div><button class="btn-sm btn-purple v_delete_serial m-1 align-content-end"><i class="fa fa-trash"></i> </button></div>');

    });
</script>


<script type="text/javascript">
    function handle(e) {
        
        var tpdoc = 0;
        var numdoc = $('#pos-customer-box');

        if (e.keyCode === 13) {
            e.preventDefault();

            console.log(numdoc.val().length);

            if (numdoc === "") {
                $.toast({
                    text: "Por favor digite un número de DNI o RUC válido", // Text that is to be shown in the toast
                    heading: 'Aviso', // Optional heading to be shown on the toast
                    icon: 'warning', // Type of toast icon
                    showHideTransition: 'fade', // fade, slide or plain
                    allowToastClose: true, // Boolean value true or false
                    hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                    stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                    position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                    textAlign: 'left', // Text alignment i.e. left, right or center
                    loader: true, // Whether to show loader or not. True by default
                    loaderBg: '#9EC600', // Background color of the toast loader
                    beforeShow: function() {}, // will be triggered before the toast is shown
                    afterShown: function() {}, // will be triggered after the toat has been shown
                    beforeHide: function() {}, // will be triggered before the toast gets hidden
                    afterHidden: function() {} // will be triggered after the toast has been hidden
                });
                return;
            } else if (numdoc.val().length < 8) {
                $.toast({
                    text: "Por favor digite un número de DNI o RUC válido.", // Text that is to be shown in the toast
                    heading: 'Aviso', // Optional heading to be shown on the toast
                    icon: 'warning', // Type of toast icon
                    showHideTransition: 'fade', // fade, slide or plain
                    allowToastClose: true, // Boolean value true or false
                    hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                    stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                    position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                    textAlign: 'left', // Text alignment i.e. left, right or center
                    loader: true, // Whether to show loader or not. True by default
                    loaderBg: '#9EC600', // Background color of the toast loader
                    beforeShow: function() {}, // will be triggered before the toast is shown
                    afterShown: function() {}, // will be triggered after the toat has been shown
                    beforeHide: function() {}, // will be triggered before the toast gets hidden
                    afterHidden: function() {} // will be triggered after the toast has been hidden
                });
                return;
            } else if (numdoc.val().length > 11) {
                $.toast({
                    text: "Por favor digite un número de DNI o RUC válido.", // Text that is to be shown in the toast
                    heading: 'Aviso', // Optional heading to be shown on the toast
                    icon: 'warning', // Type of toast icon
                    showHideTransition: 'fade', // fade, slide or plain
                    allowToastClose: true, // Boolean value true or false
                    hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                    stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                    position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                    textAlign: 'left', // Text alignment i.e. left, right or center
                    loader: true, // Whether to show loader or not. True by default
                    loaderBg: '#9EC600', // Background color of the toast loader
                    beforeShow: function() {}, // will be triggered before the toast is shown
                    afterShown: function() {}, // will be triggered after the toat has been shown
                    beforeHide: function() {}, // will be triggered before the toast gets hidden
                    afterHidden: function() {} // will be triggered after the toast has been hidden
                });
                return;
            } else if (numdoc.val().length > 8 && numdoc.val().length < 11) {
                $.toast({
                    text: "Por favor digite un número de DNI o RUC válido.", // Text that is to be shown in the toast
                    heading: 'Aviso', // Optional heading to be shown on the toast
                    icon: 'warning', // Type of toast icon
                    showHideTransition: 'fade', // fade, slide or plain
                    allowToastClose: true, // Boolean value true or false
                    hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                    stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                    position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                    textAlign: 'left', // Text alignment i.e. left, right or center
                    loader: true, // Whether to show loader or not. True by default
                    loaderBg: '#9EC600', // Background color of the toast loader
                    beforeShow: function() {}, // will be triggered before the toast is shown
                    afterShown: function() {}, // will be triggered after the toat has been shown
                    beforeHide: function() {}, // will be triggered before the toast gets hidden
                    afterHidden: function() {} // will be triggered after the toast has been hidden
                });
                return;
            } else if (numdoc.val().length == 11) {
                tpdoc = 6;
            } else if (numdoc.val().length == 8) {
                tpdoc = 1;
            }

            $.ajax({
                url: baseurl + 'customers/buscar_sunat',
                dataType: 'json',
                method: 'POST',
                data: 'numdoc=' + numdoc.val() + '&tpdoc=' + tpdoc + '&' + crsf_token + '=' + crsf_hash,
                beforeSend: function() {
                    Swal.fire({
                        title: 'Conectando, Por favor espere...!',
                        imageUrl: baseurl + "app-assets/images/sunat.png",
                        closeOnClickOutside: false,
                        closeOnEsc: false,
                        showConfirmButton: false
                    });
                },
                success: function(data) {
                    if (data.status == 'false') {

                        Swal.fire({
                            title: "Respuesta..!",
                            text: data.result,
                            type: 'warning',
                            showConfirmButton: true,
                            dangerMode: true
                        }).then((willDelete) => {
                            if (willDelete) {
                                $('#nombre').val('');
                                $('#nombre').val('');
                            }
                        });

                        $.toast({
                            text: data.result,
                            heading: 'Aviso', // Optional heading to be shown on the toast
                            icon: 'warning', // Type of toast icon
                            showHideTransition: 'fade', // fade, slide or plain
                            allowToastClose: true, // Boolean value true or false
                            hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                            stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                            position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                            textAlign: 'left', // Text alignment i.e. left, right or center
                            loader: true, // Whether to show loader or not. True by default
                            loaderBg: '#9EC600', // Background color of the toast loader
                            beforeShow: function() {}, // will be triggered before the toast is shown
                            afterShown: function() {}, // will be triggered after the toat has been shown
                            beforeHide: function() {}, // will be triggered before the toast gets hidden
                            afterHidden: function() {} // will be triggered after the toast has been hidden
                        });
                    } else {
                        Swal.fire({
                            title: "Respuesta..!",
                            text: 'Datos encontrados satisfactoriamente',
                            type: 'success',
                            showConfirmButton: true,
                            dangerMode: true
                        }).then((willDelete) => {
                            if (willDelete) {
                                $.each(data, function(i, obj) {

                                    if (tpdoc === 1) {
                                        console.log(data);
                                        $('#pos-customer-box').val(data.dni + ' - ' + data.nombres + ' ' + data.apellidoPaterno + ' ' + data.apellidoMaterno);
                                        $('#mcustomer_name').val(data.nombres + ' ' + data.apellidoPaterno + ' ' + data.apellidoMaterno);
                                        $('#mcustomer_doc').val(data.dni);
                                        $('#mcustomer_ncom').val('-');
                                        $('#mcustomer_address1').val('');
                                        $("#tipodoc option[value=" + tpdoc + "]").attr("selected", true);

                                        $('#Pos_addCustomer').modal('show');

                                    } else {
                                        $("#tipodoc option[value=" + tpdoc + "]").attr("selected", true);
                                        $('#pos-customer-box').val(data.ruc + ' - ' + data.razonSocial);
                                        $('#mcustomer_doc').val(data.ruc);
                                        $('#mcustomer_name').val(data.razonSocial);
                                        $('#mcustomer_ncom').val(data.nombreComercial);
                                        $('#mcustomer_address1').val(data.direccion);
                                        $('#mcustomer_depa').val(data.departamento);
                                        $('#mcustomer_prov').val(data.provincia);
                                        $('#mcustomer_ciu').val(data.distrito);
                                        $('#Pos_addCustomer').modal('show');
                                    }

                                })

                            } else {
                                Swal.fire("El proceso de envío fue cancelado..!!");
                            }
                        });

                    }
                }
            });
        }
    }
    $('#buscar').on('click', function() {
        var tpdoc = $('#tipodoc').val();
        if ($('#mcustomer_doc').val() === "") {
            $("#statusMsg").removeClass("alert-success").addClass("alert-warning").fadeIn();
            $("#statusMsg").html("<strong>Info</strong>: Ingrese el número de documento");
            $("#info").removeClass("alert-success").addClass("alert-warning").fadeIn();
            $("#info").html("<strong>Info</strong>: Ingrese el número de documento");
            $("html, body").animate({
                scrollTop: $('#statusMsg').offset().top
            }, 1000);
        }
        $.ajax({
            url: baseurl + 'customers/buscar_sunat',
            dataType: 'json',
            method: 'POST',
            data: 'numdoc=' + $('#mcustomer_doc').val() + '&tpdoc=' + tpdoc + '&' + crsf_token + '=' + crsf_hash,
            beforeSend: function() {
                Swal.fire({
                    title: 'Conectando con SUNAT, Por favor espere...!',
                    imageUrl: baseurl + "app-assets/images/sunat.png",
                    closeOnClickOutside: false,
                    closeOnEsc: false,
                    showConfirmButton: false
                });
            },
            success: function(data) {
                if (data.status == 'false') {

                    Swal.fire({
                        title: "Respuesta Sunat..!",
                        text: data.result,
                        type: 'warning',
                        showConfirmButton: true,
                        dangerMode: true
                    }).then((willDelete) => {
                        if (willDelete) {
                            $('#mcustomer_name').val('');
                            $('#mcustomer_ncom').val('');
                            $('#mcustomer_address1').val('');
                            $('#mcustomer_depa').val('');
                            $('#mcustomer_prov').val('');
                            $('#mcustomer_ciu').val('');
                        }
                    });

                    $("#statusMsg").removeClass("alert-success").addClass("alert-warning").fadeIn();
                    $("#statusMsg").html("<strong>Info</strong>: " + data.result);
                    $("#info").removeClass("alert-success").addClass("alert-warning").fadeIn();
                    $("#info").html("<strong>Info</strong>: " + data.result);
                    $("html, body").animate({
                        scrollTop: $('#statusMsg').offset().top
                    }, 1000);

                } else {
                    Swal.fire({
                        title: "Respuesta Sunat..!",
                        text: 'Datos encontrados satisfactoriamente',
                        type: 'success',
                        showConfirmButton: true,
                        dangerMode: true
                    }).then((willDelete) => {
                        if (willDelete) {
                            $.each(data, function(i, obj) {

                                if (tpdoc === "1") {
                                    console.log(data);
                                    $('#mcustomer_name').val(data.nombres + ' ' + data.apellidoPaterno + ' ' + data.apellidoMaterno);
                                    $('#mcustomer_ncom').val('-');
                                    $('#mcustomer_address1').val('');
                                } else {
                                    $('#mcustomer_name').val(data.razonSocial);
                                    $('#mcustomer_ncom').val(data.nombreComercial);
                                    $('#mcustomer_address1').val(data.direccion);
                                    $('#mcustomer_depa').val(data.departamento);
                                    $('#mcustomer_prov').val(data.provincia);
                                    $('#mcustomer_ciu').val(data.distrito);
                                }

                            })

                        } else {
                            Swal.fire("El proceso de envío fue cancelado..!!");
                        }
                    });

                }
            }
        });
    });

    function update_register() {
        $.ajax({
            url: baseurl + 'register/status',
            dataType: 'json',
            success: function(data) {
                $('#r_cash').val(data.cash);
                $('#r_card').val(data.card);
                $('#r_bank').val(data.bank);
                $('#r_change').val(data.change);
                $('#r_date').text(data.date);
            }
        });
    }




    update_register();
    $(".possubmit").on("click", function(e) {
        e.preventDefault();
        var o_data = $("#data_form").serialize() + '&type=' + $(this).attr('data-type');
        console.log(o_data);
        var action_url = $('#action-url').val();
        addObject(o_data, action_url);
    });
    $(".possubmit2").on("click", function(e) {
        e.preventDefault();
        $('#card_total').val(Number($('#invoiceyoghtml').val()));
    });
    $(".possubmit3").on("click", function(e) {
        e.preventDefault();
        var roundoff = accounting.unformat($('#invoiceyoghtml').val(), accounting.settings.number.decimal);
        <?php
        $round_off = $this->custom->api_config(4);
        if ($round_off['other'] == 'PHP_ROUND_HALF_UP') {
            echo ' roundoff=Math.ceil(roundoff);';
        } elseif ($round_off['other'] == 'PHP_ROUND_HALF_DOWN') {
            echo ' roundoff=Math.floor(roundoff);';
        }
        ?>
        $('#b_total').html(' <?= $this->config->item('currency'); ?> ' + accounting.formatNumber(roundoff));
        $('#p_amount').val(accounting.formatNumber(roundoff));
    });

    function update_pay_pos() {
        var am_pos = accounting.unformat($('#p_amount').val(), accounting.settings.number.decimal);
        var ttl_pos = accounting.unformat($('#invoiceyoghtml').val(), accounting.settings.number.decimal);
        <?php
        $round_off = $this->custom->api_config(4);
        if ($round_off['other'] == 'PHP_ROUND_HALF_UP') {
            echo ' ttl_pos=Math.ceil(ttl_pos);';
        } elseif ($round_off['other'] == 'PHP_ROUND_HALF_DOWN') {
            echo ' ttl_pos=Math.floor(ttl_pos);';
        }
        ?>
        var due = parseFloat(ttl_pos - am_pos).toFixed(2);
        if (due >= 0) {
            $('#balance1').val(accounting.formatNumber(due));
            $('#change_p').val(0);
        } else {
            due = due * (-1)
            $('#balance1').val(0);
            $('#change_p').val(accounting.formatNumber(due));
        }
    }

    $('#pos_card_pay').on("click", function(e) {
        e.preventDefault();
        $('#cardPay').modal('toggle');
        $("#notify .message").html("<strong>Procesando</strong>: .....");
        $("#notify").removeClass("alert-danger").addClass("alert-primary").fadeIn();
        $("html, body").animate({
            scrollTop: $('#notify').offset().top - 100
        }, 1000);
        var o_data = $("#data_form").serialize() + '&' + $("#card_data").serialize() + '&type=' + $(this).attr('data-type');
        var action_url = $('#action-url').val();
        addObject(o_data, action_url);
        update_register();
    });
    $('#pos_basic_pay').on("click", function(e) {
        e.preventDefault();

        var idtp = $("#tipocomp").val();
        var tpd = $("#idtipodoc").val();
        if (idtp == 'F') {
            if (tpd == 0) {
                Swal.fire({
                    title: "MENSAJE DEL SISTEMA..!",
                    text: 'Por favor seleccione un número de RUC o nombre de empresa',
                    type: 'danger',
                    showConfirmButton: true,
                    dangerMode: true
                })

                return;
            }
        }

        $('#basicPay').modal('toggle');

        $("#notify .message").html("<strong>Procesando</strong>: .....");
        $("#notify").removeClass("alert-danger").addClass("alert-primary").fadeIn();
        $("html, body").animate({
            scrollTop: $('#notify').offset().top - 100
        }, 1000);
        var o_data = $("#data_form").serialize() + '&p_amount=' + accounting.unformat($('#p_amount').val(), accounting.settings.number.decimal) + '&p_method=' + $("#p_method option:selected").val() + '&type=' + $(this).attr('data-type') + '&account=' + $("#p_account option:selected").val() + '&employee=' + $("#employee option:selected").val();
        var action_url = $('#action-url').val();
        addObject(o_data, action_url);
        setTimeout(
            function() {
                update_register();
            }, 3000);
    });
    var file_id;
    var $lo = $("#loader");
    $(document.body).on('click', '.print', function(e) {

        e.preventDefault();
        var $this = $('#print');
        var inv_id = $('.print').attr('data-idin');

        jQuery.ajax({
            url: '<?php echo base_url('pos_invoices/invoice_legacy') ?>',
            type: 'POST',
            data: 'inv=' + inv_id + '&d=1&' + crsf_token + '=' + crsf_hash,
            dataType: 'json',
            beforeSend: function() { // Before we send the request, remove the .hidden class from the spinner and default to inline-block.

                $lo.css("display", "inline");
                $this.button('loading');
            },
            success: function(data) {
                cadenab64 = data.base64;
                
                    printJS({
                        printable: cadenab64,
                        type: 'pdf',
                        base64: true,
                        onError: (err) => console.log(err),
                        fallbackPrintable: () => $lo.css("display", "none"),
                        onPrintDialogClose: () => $lo.css("display", "none")
                    });
                

            },
            complete: function() {

                $lo.css("display", "none");
                $this.button('reset');
            },

        });

    });

    function cargar_categoria(cat){
        $.ajax({
        url: baseurl + 'search_products/pos_search',
        dataType: 'html',
        method: 'POST',
        data: 'cid=' + cat + '&wid=' + $('#warehouses option:selected').val() + '&' + crsf_token + '=' + crsf_hash,
        success: function(data) {
            $('#pos_item').html(data);
        }
    });
    }
    //Creamos un listener para detectar el click
//Vamos a estar pendientes de .li-solo
let cat = 0;
$( document ).on( 'click', '.nav-item', function() {
  
  //Dentro de este selector existe la etiqueta <a> la buscamos
  let a_tag = $( this ).find('a');
  
  //Podemos usar igual las bondades de HTML5
  //Nota que agregué al código HTML un atributo data-name
  cat = a_tag.data('cat');
  cargar_categoria(cat);

});
cargar_categoria(0);

    $(document.body).on('click', '.print_image', function(e) {

        e.preventDefault();

        var inv_id = $(this).attr('data-inid');

        jQuery.ajax({
            url: '<?php echo base_url('pos_invoices/invoice_legacy') ?>',
            type: 'POST',
            data: 'inv=' + inv_id + '&d=1&' + crsf_token + '=' + crsf_hash,
            dataType: 'json',
            success: function(data) {
                file_id = data.base64;
                $("#loader_pdf").attr('src', 'data:application/pdf;base64,'+data.base64);
                $("#loader_file").val('data:application/pdf;base64,'+data.base64);
            },
        });

        $('#pos_print').modal('toggle');
    });
    $('#pos_basic_print').on("click", function(e) {
        e.preventDefault();
        $('#basicPay').modal('toggle');
        $("#notify .message").html("<strong>Procesando</strong>: .....");
        $("#notify").removeClass("alert-danger").addClass("alert-primary").fadeIn();
        $("html, body").animate({
            scrollTop: $('body').offset().top - 100
        }, 1000);
        var o_data = $("#data_form").serialize() + '&p_amount=' + accounting.unformat($('#p_amount').val(), accounting.settings.number.decimal) + '&p_method=' + $("#p_method option:selected").val() + '&type=' + $(this).attr('data-type') + '&printnow=1' + '&account=' + $("#p_account option:selected").val() + '&employee=' + $("#employee option:selected").val();
        var action_url = $('#action-url').val();
        addObject(o_data, action_url);

        setTimeout(
            function() {
                update_register();
            }, 3000);
    });

    function clean_data() {
        setTimeout(function() {
            var file_id = $("#loader_file").val();
            jQuery.ajax({
                url: '<?php echo base_url('pos_invoices/invoice_clean') ?>',
                type: 'POST',
                data: 'file_id=' + file_id + '&' + crsf_token + '=' + crsf_hash,
                dataType: 'json',
                success: function(data) {

                },
            });
        }, 2500);

    }
</script>
<!-- Vendor libraries -->
<script type="text/javascript">
    var $form = $('#payment-form');
    $form.on('submit', payWithCard);

    /* If you're using Stripe for payments */
    function payWithCard(e) {
        e.preventDefault();
        /* Visual feedback */
        $form.find('[type=submit]').html('Procesando <i class="fa fa-spinner fa-pulse"></i>')
            .prop('disabled', true);
        jQuery.ajax({
            url: '<?php echo base_url('billing/process_card') ?>',
            type: 'POST',
            data: $('#payment-form').serialize(),
            dataType: 'json',
            success: function(data) {
                $form.find('[type=submit]').html('Pago exitoso <i class="fa fa-check"></i>').prop('disabled', true);
                $("#notify .message").html("<strong>" + data.status + "</strong>: " + data.message);
                $("#notify").removeClass("alert-danger").addClass("alert-success").fadeIn();
                $("html, body").animate({
                    scrollTop: $('#notify').offset().top
                }, 1000);
            },
            error: function() {
                $form.find('[type=submit]').html('There was a problem').removeClass('success').addClass('error');
                /* Show Stripe errors on the form */
                $form.find('.payment-errors').text('Intente actualizar la página y vuelva a intentarlo.');
                $form.find('.payment-errors').closest('.row').show();
                $form.find('[type=submit]').html('Error! <i class="fa fa-exclamation-circle"></i>')
                    .prop('disabled', true);
                $("#notify .message").html("<strong>Error</strong>: ¡Inténtalo de nuevo!");
            }
        });
    }

    $(document).ready(function() {
        Mousetrap.bind('alt+x', function() {
            $('#search_bar').focus();
        });
        Mousetrap.bind('alt+c', function() {
            $('#pos-customer-box').focus();
        });
        Mousetrap.bind('alt+z', function() {
            $('.possubmit2').click();
        });
        Mousetrap.bind('alt+n', function() {
            var idtp = $("#tpcomp").val();
            window.location.href = baseurl + "pos_invoices/create/" + idtp + "/";
        });
        Mousetrap.bind('alt+q', function() {
            $('#posp0').click();
            $('#search_bar').val('');
        });
        Mousetrap.bind('alt+s', function() {
            if ($('#basicPay').hasClass('in')) {
                $('#pos_basic_print').click();
            } else {
                $('.possubmit3').click();
            }
        });
        $('#search_bar').keypress(function(event) {
            if (event.keyCode == 13) {
                setTimeout(
                    function() {
                        $('#posp0').click();
                        $('#search_bar').val('');
                    }, 700);

            }
        });
    });
</script>