<div class="content-body">
    <div class="card">
        <div class="card-header">
            <h5><?php echo $this->lang->line('Import Products') ?></h5>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                    <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                    <li><a data-action="close"><i class="ft-x"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content">
            <div id="notify" class="alert alert-success" style="display:none;">
                <a href="#" class="close" data-dismiss="alert">&times;</a>

                <div class="message"></div>
            </div>
            <div class="card-body">


                <?php echo form_open_multipart('import/products_upload'); ?><input type="hidden"
                                                                                   name="<?php echo $this->security->get_csrf_token_name(); ?>"
                                                                                   value="<?php echo $this->security->get_csrf_hash(); ?>">


                <hr>
                <p>El archivo de datos de sus productos debe seguir esta plantilla <a
                            href="<?php echo base_url()?>ejemplos/products_import.csv"><strong>Descargar
                            Plantilla</strong></a>. Descargue una copia de seguridad de la base de datos antes de importar los productos.
                </p>
                <p>El orden de las columnas en el archivo CSV debe ser así</p>
                <pre>
     1. (cadena)Product A, 2. (cadena)ProductCODE, 3. (número)Sales_Price, 4. (número)Factory_Price,

      5. (número)TAX_Rate, 6. (número)Discount_Rate, 7. (entero)Cantidad,

      8. (cadena)Product_Description, 9. (entero)Low_Stock_Alert_Quantity
</pre>

                <hr>
                <div class="form-group row">

                    <label class="col-sm-2 col-form-label" for="name">Archivo
                    </label>

                    <div class="col-sm-6">
                        <input type="file" name="userfile" size="15"/>(formato csv solamente)
                    </div>
                </div>
                <div class="form-group row">

                    <label class="col-sm-2 col-form-label"
                           for="product_cat"><?php echo $this->lang->line('Product Category') ?></label>

                    <div class="col-sm-6">
                        <select name="product_cat" class="form-control">
                            <?php
                            foreach ($cat as $row) {
                                $cid = $row['id'];
                                $title = $row['title'];
                                echo "<option value='$cid'>$title</option>";
                            }
                            ?>
                        </select>


                    </div>
                </div>

                <div class="form-group row">

                    <label class="col-sm-2 col-form-label"
                           for="product_cat"><?php echo $this->lang->line('Warehouse') ?></label>

                    <div class="col-sm-6">
                        <select name="product_warehouse" class="form-control">
                            <?php
                            foreach ($warehouse as $row) {
                                $cid = $row['id'];
                                $title = $row['title'];
                                echo "<option value='$cid'>$title</option>";
                            }
                            ?>
                        </select>


                    </div>
                </div>

                <div class="form-group row">

                    <label class="col-sm-2 col-form-label"></label>

                    <div class="col-sm-4">
                        <input type="submit" class="btn btn-success margin-bottom"
                               value="<?php echo $this->lang->line('Import Products') ?>" data-loading-text="Añadiendo...">

                    </div>
                </div>


                </form>
            </div>
        </div>

