<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Servicios_model extends CI_Model
{

    var $table = 'jsoft_products';
    var $column_order = array(null, 'jsoft_products.product_name', 'jsoft_products.qty', 'jsoft_products.product_code', 'jsoft_product_cat.title', 'jsoft_products.product_price', null); //set column field database for datatable orderable
    var $column_search = array('jsoft_products.pid', 'jsoft_products.product_name', 'jsoft_products.color', 'jsoft_products.qty', 'jsoft_products.product_code', 'jsoft_product_cat.title', 'jsoft_warehouse.title', 'jsoft_products.product_price'); //set column field database for datatable searchable
    var $column_order_sunat = array(null, 'segmento', 'familia', 'clase', null); //set column field database for datatable orderable
    var $column_search_sunat = array('segmento', 'familia', 'clase');
    var $order = array('jsoft_products.pid' => 'desc'); // default order
    var $order_sunat = array('idsegmento' => 'desc'); // default order

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    private function _get_datatables_query($id = '', $w = '', $sub = '')
    {
        $this->db->select('jsoft_products.*,jsoft_product_cat.title AS c_title,jsoft_warehouse.title');
        $this->db->from($this->table);
        $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = jsoft_products.warehouse');

        $this->db->where('jsoft_products.tipo', 'S');
        if ($sub) {
            $this->db->join('jsoft_product_cat', 'jsoft_product_cat.id = jsoft_products.sub_id');

            if ($this->input->post('group') != 'yes')
                $this->db->where('jsoft_products.merge', 0);
            if ($this->aauth->get_user()->loc) {
                $this->db->group_start();
                $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
                if (BDATA)
                    $this->db->or_where('jsoft_warehouse.loc', 0);
                $this->db->group_end();
            } elseif (!BDATA) {
                $this->db->where('jsoft_warehouse.loc', 0);
            }

            $this->db->where("jsoft_products.sub_id=$id");
        } else {
            $this->db->join('jsoft_product_cat', 'jsoft_product_cat.id = jsoft_products.pcat');

            if ($w) {

                if ($id > 0) {
                    $this->db->where("jsoft_warehouse.id = $id");
                    // $this->db->where('jsoft_products.sub_id', 0);
                }
                if ($this->aauth->get_user()->loc) {
                    $this->db->group_start();
                    $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);

                    if (BDATA)
                        $this->db->or_where('jsoft_warehouse.loc', 0);
                    $this->db->group_end();
                } elseif (!BDATA) {
                    $this->db->where('jsoft_warehouse.loc', 0);
                }
            } else {

                if ($this->input->post('group') != 'yes')
                    $this->db->where('jsoft_products.merge', 0);
                if ($this->aauth->get_user()->loc) {
                    $this->db->group_start();
                    $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
                    if (BDATA)
                        $this->db->or_where('jsoft_warehouse.loc', 0);
                    $this->db->group_end();
                } elseif (!BDATA) {
                    $this->db->where('jsoft_warehouse.loc', 0);
                }
                if ($id > 0) {
                    $this->db->where("jsoft_product_cat.id = $id");
                    $this->db->where('jsoft_products.sub_id', 0);
                }
            }
        }

        $i = 0;

        foreach ($this->column_search as $key => $item) { // bucle de columna
            $search = $this->input->post('search');
            $value = $search['value'];

            if ($value) { // si la tabla de datos envía POST para la búsqueda
                if ($i === 0) { // primer bucle
                    $this->db->group_start();
                    $this->db->like($item, $value);
                } else {
                    $this->db->or_like($item, $value);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
            switch ($key) {
                case 0:
                    if (!empty($this->input->post('columns')[0]['search']['value'])) {
                        $value = $this->input->post('columns')[0]['search']['value'];
                        $this->db->like($item, $value);
                        break;
                    }
                case 1:
                    if (!empty($this->input->post('columns')[1]['search']['value'])) {
                        $value = $this->input->post('columns')[1]['search']['value'];

                        $this->db->like('product_name', $value);

                        break;
                    }
                case 2:
                    if (!empty($this->input->post('columns')[2]['search']['value'])) {
                        $value = $this->input->post('columns')[2]['search']['value'];

                        $this->db->like('jsoft_product_cat.title', $value);

                        break;
                    }
                case 3:
                    if (!empty($this->input->post('columns')[3]['search']['value'])) {
                        $value = $this->input->post('columns')[3]['search']['value'];
                        $this->db->like('jsoft_products.product_price', $value);
                        break;
                    }
                default:
                    break;
            }
        }
        $search = $this->input->post('order');
        if ($search) { // here order processing
            $this->db->order_by($this->column_order[$search['0']['column']], $search['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($id = '', $w = '', $sub = '')
    {
        if ($id > 0) {
            $this->_get_datatables_query($id, $w, $sub);
        } else {
            $this->_get_datatables_query();
        }
        if ($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id, $w = '', $sub = '')
    {
        if ($id > 0) {
            $this->_get_datatables_query($id, $w, $sub);
        } else {
            $this->_get_datatables_query();
        }

        $query = $this->db->get();
        return $query->num_rows();
    }

    function count_filtered_sunat()
    {

        $this->_get_datatables_codsunat();


        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_sunat()
    {
        $this->db->from('v_codsunat');
        return $this->db->count_all_results();
    }

    private function _get_datatables_codsunat()
    {
        $this->db->select('*');
        $this->db->from('v_codsunat');

        $i = 0;

        foreach ($this->column_search_sunat as $item) // loop column 
        {
            $search = $this->input->post('search');
            $value = $search['value'];
            if ($value) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $value);
                } else {
                    $this->db->or_like($item, $value);
                }

                if (count($this->column_search_sunat) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
    }

    function get_codsunat()
    {

        $this->_get_datatables_codsunat();

        if ($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
        $query = $this->db->get();
        return $query->result();
    }

    public function listar_talla_medida()
    {
        $this->db->select('talla as id, talla');
        $this->db->distinct();
        $this->db->from('jsoft_products');
        $this->db->where('talla<>', NULL);
        return $this->db->get()->result_array();
    }

    public function listar_color()
    {
        $this->db->select('color as id, color');
        $this->db->distinct();
        $this->db->from('jsoft_products');
        $this->db->where('color<>', NULL);
        return $this->db->get()->result_array();
    }

    public function listar_marca()
    {
        $this->db->select('marca as id, marca');
        $this->db->distinct();
        $this->db->from('jsoft_products');
        $this->db->where('marca<>', NULL);
        return $this->db->get()->result_array();
    }

    public function lista_tipoexist()
    {
        $where = '';


        $query = $this->db->query("SELECT idtipoexistencia,tipoexistencia
FROM tipoexistencia $where

ORDER BY idtipoexistencia DESC");
        return $query->result_array();
    }

    public function cat_tipoex($id, $loc = 0)
    {
        $qj = '';
        if ($loc)
            $qj = "AND w.loc='$loc'";
        $query = $this->db->query("SELECT c.id AS cid, w.idtipoexistencia AS wid,c.title AS catt,w.tipoexistencia AS watt FROM jsoft_products AS p LEFT JOIN jsoft_product_cat AS c ON p.pcat=c.id LEFT JOIN tipoexistencia AS w ON p.idtipoexistencia=w.idtipoexistencia WHERE
p.pid='$id' $qj ");
        return $query->row_array();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = jsoft_products.warehouse');
        if ($this->aauth->get_user()->loc) {

            $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
            if (BDATA)
                $this->db->or_where('jsoft_warehouse.loc', 0);
        } elseif (!BDATA) {
            $this->db->where('jsoft_warehouse.loc', 0);
        }
        return $this->db->count_all_results();
    }

    public function addnew($catid, $warehouse, $product_name, $product_code, $product_price, $factoryprice, $taxrate, $disrate, $product_qty = '', $product_qty_alert, $product_desc, $image, $unit, $barcode, $v_type, $v_stock, $v_alert, $wdate, $code_type, $w_type = '', $w_stock = '', $w_alert = '', $sub_cat = '', $b_id = '', $serial = '', $icbper, $talla = '', $tipo = '', $codsunat, $tipoexist = '', $color = '', $marca = '')
    {
        $ware_valid = $this->valid_warehouse($warehouse);
        if (!$sub_cat)
            $sub_cat = 0;
        if (!$b_id)
            $b_id = 0;
        $datetime1 = new DateTime(date('Y-m-d'));

        $datetime2 = new DateTime($wdate);

        $difference = $datetime1->diff($datetime2);
        if (!$difference->d > 0) {
            $wdate = null;
        }

        if ($this->aauth->get_user()->loc) {
            if ($ware_valid['loc'] == $this->aauth->get_user()->loc or $ware_valid['loc'] == '0' or $warehouse == 0) {
                if (strlen($barcode) > 5 and is_numeric($barcode)) {
                    $data = array(
                        'pcat' => $catid,
                        'warehouse' => $warehouse,
                        'product_name' => $product_name,
                        'product_code' => $product_code,
                        'product_price' => $product_price,
                        'fproduct_price' => $factoryprice,
                        'taxrate' => $taxrate,
                        'disrate' => $disrate,
                        'qty' => $product_qty,
                        'product_des' => $product_desc,
                        'alert' => $product_qty_alert,
                        'unit' => $unit,
                        'image' => $image,
                        'barcode' => $barcode,
                        'expiry' => $wdate,
                        'code_type' => $code_type,
                        'sub_id' => $sub_cat,
                        'b_id' => $b_id,
                        'icbper' => $icbper,
                        'talla' => $talla,
                        'tipo' => $tipo,
                        'codigosunat' => $codsunat,
                        'idtipoexistencia' => $tipoexist,
                        'color' => $color,
                        'marca' => $marca
                    );
                } else {

                    $barcode = rand(100, 999) . rand(0, 9) . rand(1000000, 9999999) . rand(0, 9);

                    $data = array(
                        'pcat' => $catid,
                        'warehouse' => $warehouse,
                        'product_name' => $product_name,
                        'product_code' => $product_code,
                        'product_price' => $product_price,
                        'fproduct_price' => $factoryprice,
                        'taxrate' => $taxrate,
                        'disrate' => $disrate,
                        'qty' => $product_qty,
                        'product_des' => $product_desc,
                        'alert' => $product_qty_alert,
                        'unit' => $unit,
                        'image' => $image,
                        'barcode' => $barcode,
                        'expiry' => $wdate,
                        'code_type' => 'EAN13',
                        'sub_id' => $sub_cat,
                        'b_id' => $b_id,
                        'icbper' => $icbper,
                        'talla' => $talla,
                        'tipo' => $tipo,
                        'codigosunat' => $codsunat,
                        'idtipoexistencia' => $tipoexist,
                        'color' => $color,
                        'marca' => $marca
                    );
                }
                $this->db->trans_start();

                if ($this->db->insert('jsoft_products', $data)) {
                    $pid = $this->db->insert_id();
                    if ($tipo == 'P') {
                        $this->movers(1, $pid, $product_qty, 0, 'Stock Inicial');
                    }

                    $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                    echo json_encode(array('status' => 'Success', 'message' =>
                    $this->lang->line('ADDED') . "  <a href='add' class='btn btn-blue btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span>  </a> <a href='" . base_url('products') . "' class='btn btn-grey-blue btn-lg'><span class='fa fa-list-alt' aria-hidden='true'></span>  </a>"));
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    $this->lang->line('ERROR')));
                }
                if ($serial) {
                    $serial_group = array();
                    foreach ($serial as $key => $value) {
                        if ($value)
                            $serial_group[] = array('product_id' => $pid, 'serial' => $value);
                    }
                    $this->db->insert_batch('jsoft_product_serials', $serial_group);
                }
                if ($v_type) {
                    foreach ($v_type as $key => $value) {
                        if ($v_type[$key] && numberClean($v_stock[$key]) > 0.00) {
                            $this->db->select('u.id,u.name,u2.name AS variation');
                            $this->db->join('jsoft_units u2', 'u.rid = u2.id', 'left');
                            $this->db->where('u.id', $v_type[$key]);
                            $query = $this->db->get('jsoft_units u');
                            $r_n = $query->row_array();
                            $data['product_name'] = $product_name . '-' . $r_n['variation'] . '-' . $r_n['name'];
                            $data['qty'] = numberClean($v_stock[$key]);
                            $data['alert'] = numberClean($v_alert[$key]);
                            $data['merge'] = 1;
                            $data['sub'] = $pid;
                            $data['vb'] = $v_type[$key];
                            $this->db->insert('jsoft_products', $data);
                            $pidv = $this->db->insert_id();

                            if ($tipo == 'P') {
                                $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                            }
                            $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                        }
                    }
                }
                if ($w_type) {
                    foreach ($w_type as $key => $value) {
                        if ($w_type[$key] && numberClean($w_stock[$key]) > 0.00 && $w_type[$key] != $warehouse) {
                            $data['product_name'] = $product_name;
                            $data['warehouse'] = $w_type[$key];
                            $data['qty'] = numberClean($w_stock[$key]);
                            $data['alert'] = numberClean($w_alert[$key]);
                            $data['merge'] = 2;
                            $data['sub'] = $pid;
                            $data['vb'] = $w_type[$key];
                            $this->db->insert('jsoft_products', $data);
                            $pidv = $this->db->insert_id();
                            if ($tipo == 'P') {
                                $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                            }

                            $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                        }
                    }
                }
                $this->db->trans_complete();
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
            }
        } else {
            if (strlen($barcode) > 5 and is_numeric($barcode)) {
                $data = array(
                    'pcat' => $catid,
                    'warehouse' => $warehouse,
                    'product_name' => $product_name,
                    'product_code' => $product_code,
                    'product_price' => $product_price,
                    'fproduct_price' => $factoryprice,
                    'taxrate' => $taxrate,
                    'disrate' => $disrate,
                    'qty' => $product_qty,
                    'product_des' => $product_desc,
                    'alert' => $product_qty_alert,
                    'unit' => $unit,
                    'image' => $image,
                    'barcode' => $barcode,
                    'expiry' => $wdate,
                    'code_type' => $code_type,
                    'sub_id' => $sub_cat,
                    'b_id' => $b_id,
                    'icbper' => $icbper,
                    'talla' => $talla,
                    'tipo' => $tipo,
                    'codigosunat' => $codsunat,
                    'idtipoexistencia' => $tipoexist,
                    'color' => $color,
                    'marca' => $marca
                );
            } else {
                $barcode = rand(100, 999) . rand(0, 9) . rand(1000000, 9999999) . rand(0, 9);
                $data = array(
                    'pcat' => $catid,
                    'warehouse' => $warehouse,
                    'product_name' => $product_name,
                    'product_code' => $product_code,
                    'product_price' => $product_price,
                    'fproduct_price' => $factoryprice,
                    'taxrate' => $taxrate,
                    'disrate' => $disrate,
                    'qty' => $product_qty,
                    'product_des' => $product_desc,
                    'alert' => $product_qty_alert,
                    'unit' => $unit,
                    'image' => $image,
                    'barcode' => $barcode,
                    'expiry' => $wdate,
                    'code_type' => 'EAN13',
                    'sub_id' => $sub_cat,
                    'b_id' => $b_id,
                    'icbper' => $icbper,
                    'talla' => $talla,
                    'tipo' => $tipo,
                    'codigosunat' => $codsunat,
                    'idtipoexistencia' => $tipoexist,
                    'color' => $color,
                    'marca' => $marca
                );
            }
            $this->db->trans_start();
            if ($this->db->insert('jsoft_products', $data)) {
                $pid = $this->db->insert_id();
                if ($tipo == 'P') {
                    $this->movers(1, $pid, $product_qty, 0, 'Stock Inicial');
                }

                $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('ADDED') . "  <a href='add' class='btn btn-blue btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span>  </a> <a href='" . base_url('products') . "' class='btn btn-grey-blue btn-lg'><span class='fa fa-list-alt' aria-hidden='true'></span>  </a>"));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
            }
            if ($serial) {
                $serial_group = array();
                foreach ($serial as $key => $value) {
                    if ($value)
                        $serial_group[] = array('product_id' => $pid, 'serial' => $value);
                }
                $this->db->insert_batch('jsoft_product_serials', $serial_group);
            }
            if ($v_type) {
                foreach ($v_type as $key => $value) {
                    if ($v_type[$key] && numberClean($v_stock[$key]) > 0.00) {
                        $this->db->select('u.id,u.name,u2.name AS variation');
                        $this->db->join('jsoft_units u2', 'u.rid = u2.id', 'left');
                        $this->db->where('u.id', $v_type[$key]);

                        $query = $this->db->get('jsoft_units u');
                        $r_n = $query->row_array();
                        $data['product_name'] = $product_name . '-' . $r_n['variation'] . '-' . $r_n['name'];
                        $data['qty'] = numberClean($v_stock[$key]);
                        $data['alert'] = numberClean($v_alert[$key]);
                        $data['merge'] = 1;
                        $data['sub'] = $pid;
                        $data['vb'] = $v_type[$key];
                        $this->db->insert('jsoft_products', $data);
                        $pidv = $this->db->insert_id();
                        if ($tipo == 'P') {
                            $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                        }
                        $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                    }
                }
            }
            if ($w_type) {
                foreach ($w_type as $key => $value) {
                    if ($w_type[$key] && numberClean($w_stock[$key]) > 0.00 && $w_type[$key] != $warehouse) {

                        $data['product_name'] = $product_name;
                        $data['warehouse'] = $w_type[$key];
                        $data['qty'] = numberClean($w_stock[$key]);
                        $data['alert'] = numberClean($w_alert[$key]);
                        $data['merge'] = 2;
                        $data['sub'] = $pid;
                        $data['vb'] = $w_type[$key];
                        $this->db->insert('jsoft_products', $data);
                        $pidv = $this->db->insert_id();
                        if ($tipo == 'P') {
                            $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                        }

                        $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                    }
                }
            }
            $this->custom->save_fields_data($pid, 4);
            $this->db->trans_complete();
        }
    }

    public function edit($pid, $catid, $warehouse, $product_name, $product_code, $product_price, $factoryprice, $taxrate, $disrate, $product_qty, $product_qty_alert, $product_desc, $image, $unit, $barcode, $code_type, $sub_cat = '', $b_id = '', $vari = null, $serial = null, $talla = '', $tipo = '', $codsunat, $tipoexist, $color = '')
    {
        $this->db->select('qty');
        $this->db->from('jsoft_products');
        $this->db->where('pid', $pid);
        $query = $this->db->get();
        $r_n = $query->row_array();
        $ware_valid = $this->valid_warehouse($warehouse);
        $this->db->trans_start();
        if ($this->aauth->get_user()->loc) {
            if ($ware_valid['loc'] == $this->aauth->get_user()->loc or $ware_valid['loc'] == '0' or $warehouse == 0) {
                $data = array(
                    'pcat' => $catid,
                    'warehouse' => $warehouse,
                    'product_name' => $product_name,
                    'product_code' => $product_code,
                    'product_price' => $product_price,
                    'fproduct_price' => $factoryprice,
                    'taxrate' => $taxrate,
                    'disrate' => $disrate,
                    'qty' => $product_qty,
                    'product_des' => $product_desc,
                    'alert' => $product_qty_alert,
                    'unit' => $unit,
                    'image' => $image,
                    'barcode' => $barcode,
                    'code_type' => $code_type,
                    'sub_id' => $sub_cat,
                    'b_id' => $b_id,
                    'icbper' => 0,
                    'talla' => $talla,
                    'tipo' => $tipo,
                    'codigosunat' => $codsunat,
                    'idtipoexistencia' => $tipoexist,
                    'color' => $color
                );

                $this->db->set($data);
                $this->db->where('pid', $pid);

                if ($this->db->update('jsoft_products')) {
                    if ($r_n['qty'] != $product_qty) {
                        $m_product_qty = $product_qty - $r_n['qty'];
                        $this->movers(1, $pid, $m_product_qty, 0, 'Cambios de Stock');
                    }
                    $this->aauth->applog("[Producto Actualizado] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                    echo json_encode(array('status' => 'Success', 'message' =>
                    $this->lang->line('UPDATED') . " <a href='" . base_url('products/edit?id=' . $pid) . "' class='btn btn-blue btn-lg'><span class='fa fa-eye' aria-hidden='true'></span>  </a> <a href='" . base_url('products') . "' class='btn btn-grey-blue btn-lg'><span class='fa fa-list-alt' aria-hidden='true'></span>  </a>"));
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    $this->lang->line('ERROR')));
                }
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
            }
        } else {
            $data = array(
                'pcat' => $catid,
                'warehouse' => $warehouse,
                'product_name' => $product_name,
                'product_code' => $product_code,
                'product_price' => $product_price,
                'fproduct_price' => $factoryprice,
                'taxrate' => $taxrate,
                'disrate' => $disrate,
                'qty' => $product_qty,
                'product_des' => $product_desc,
                'alert' => $product_qty_alert,
                'unit' => $unit,
                'image' => $image,
                'barcode' => $barcode,
                'code_type' => $code_type,
                'sub_id' => $sub_cat,
                'b_id' => $b_id,
                'icbper' => 0,
                'talla' => $talla,
                'tipo' => $tipo,
                'codigosunat' => $codsunat,
                'idtipoexistencia' => $tipoexist,
                'color' => $color
            );
            $this->db->set($data);
            $this->db->where('pid', $pid);
            if ($this->db->update('jsoft_products')) {
                if ($r_n['qty'] != $product_qty) {
                    $m_product_qty = $product_qty - $r_n['qty'];
                    $this->movers(1, $pid, $m_product_qty, 0, 'Cambios de stock');
                }
                $this->aauth->applog("[Producto Actualizado] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('UPDATED') . " <a href='" . base_url('products/edit?id=' . $pid) . "' class='btn btn-blue btn-lg'><span class='fa fa-eye' aria-hidden='true'></span>  </a> <a href='" . base_url('products') . "' class='btn btn-grey-blue btn-lg'><span class='fa fa-list-alt' aria-hidden='true'></span>  </a>"));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
            }
        }

        if (isset($serial['old'])) {
            $this->db->delete('jsoft_product_serials', array('product_id' => $pid, 'status' => 0));
            $serial_group = array();
            foreach ($serial['old'] as $key => $value) {
                if ($value)
                    $serial_group[] = array('product_id' => $pid, 'serial' => $value);
            }
            $this->db->insert_batch('jsoft_product_serials', $serial_group);
        }
        if (isset($serial['new'])) {
            $serial_group = array();
            foreach ($serial['new'] as $key => $value) {
                if ($value)
                    $serial_group[] = array('product_id' => $pid, 'serial' => $value, 'status' => 0);
            }

            $this->db->insert_batch('jsoft_product_serials', $serial_group);
        }
        $this->custom->edit_save_fields_data($pid, 4);


        $v_type = @$vari['v_type'];
        $v_stock = @$vari['v_stock'];
        $v_alert = @$vari['v_alert'];
        $w_type = @$vari['w_type'];
        $w_stock = @$vari['w_stock'];
        $w_alert = @$vari['w_alert'];

        if (isset($v_type)) {
            foreach ($v_type as $key => $value) {
                if ($v_type[$key] && numberClean($v_stock[$key]) > 0.00) {
                    $this->db->select('u.id,u.name,u2.name AS variation');
                    $this->db->join('jsoft_units u2', 'u.rid = u2.id', 'left');
                    $this->db->where('u.id', $v_type[$key]);
                    $query = $this->db->get('jsoft_units u');
                    $r_n = $query->row_array();
                    $data['product_name'] = $product_name . '-' . $r_n['variation'] . '-' . $r_n['name'];
                    $data['qty'] = numberClean($v_stock[$key]);
                    $data['alert'] = numberClean($v_alert[$key]);
                    $data['merge'] = 1;
                    $data['sub'] = $pid;
                    $data['vb'] = $v_type[$key];
                    $this->db->insert('jsoft_products', $data);
                    $pidv = $this->db->insert_id();
                    $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                    $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                }
            }
        }
        if (isset($w_type)) {
            foreach ($w_type as $key => $value) {
                if ($w_type[$key] && numberClean($w_stock[$key]) > 0.00 && $w_type[$key] != $warehouse) {
                    $data['product_name'] = $product_name;
                    $data['warehouse'] = $w_type[$key];
                    $data['qty'] = numberClean($w_stock[$key]);
                    $data['alert'] = numberClean($w_alert[$key]);
                    $data['merge'] = 2;
                    $data['sub'] = $pid;
                    $data['vb'] = $w_type[$key];
                    $this->db->insert('jsoft_products', $data);
                    $pidv = $this->db->insert_id();
                    $this->movers(1, $pidv, $data['qty'], 0, 'Stock Inicial');
                    $this->aauth->applog("[Nuevo Producto] -$product_name  -Cant.-$product_qty ID " . $pid, $this->aauth->get_user()->username);
                }
            }
        }
        $this->db->trans_complete();
    }

    public function prd_stats()
    {

        $whr = '';
        if ($this->aauth->get_user()->loc) {
            $whr = ' LEFT JOIN  jsoft_warehouse on jsoft_warehouse.id = jsoft_products.warehouse WHERE tipo = "S" AND jsoft_warehouse.loc=' . $this->aauth->get_user()->loc;
            if (BDATA)
                $whr = ' LEFT JOIN  jsoft_warehouse on jsoft_warehouse.id = jsoft_products.warehouse WHERE tipo = "S" AND jsoft_warehouse.loc=0 OR jsoft_warehouse.loc=' . $this->aauth->get_user()->loc;
        } elseif (!BDATA) {
            $whr = ' LEFT JOIN  jsoft_warehouse on jsoft_warehouse.id = jsoft_products.warehouse WHERE tipo = "S" AND jsoft_warehouse.loc=0';
        }
        $query = $this->db->query("SELECT COUNT(IF( jsoft_products.qty > 0, jsoft_products.qty, NULL)) AS instock, COUNT(IF( jsoft_products.qty <= 0, jsoft_products.qty, NULL)) AS outofstock, COUNT(jsoft_products.qty) AS total FROM jsoft_products $whr");
        echo json_encode($query->result_array());
    }

    public function products_list($id, $term = '')
    {
        $this->db->select('*');
        $this->db->from('v_jsoft_productos');
        $this->db->where('v_jsoft_productos.warehouse', $id);
        if ($this->aauth->get_user()->loc) {
            $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = v_jsoft_productos.warehouse');
            $this->db->where('jsoft_warehouse.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->join('jsoft_warehouse', 'jsoft_warehouse.id = v_jsoft_productos.warehouse');
            $this->db->where('jsoft_warehouse.loc', 0);
        }
        if ($term) {
            $this->db->where("v_jsoft_productos.product_name LIKE '%$term%'");
            $this->db->or_where("v_jsoft_productos.product_code LIKE '$term%'");
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function units()
    {
        $this->db->select('*');
        $this->db->from('jsoft_units');
        $this->db->where('type', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function serials($pid)
    {
        $this->db->select('*');
        $this->db->from('jsoft_product_serials');
        $this->db->where('product_id', $pid);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function transfer($from_warehouse, $products_l, $to_warehouse, $qty)
    {
        $updateArray = array();
        $move = false;
        $qtyArray = explode(',', $qty);
        $this->db->select('title');
        $this->db->from('jsoft_warehouse');
        $this->db->where('id', $to_warehouse);
        $query = $this->db->get();
        $to_warehouse_name = $query->row_array()['title'];

        $i = 0;
        foreach ($products_l as $row) {
            $qty = 0;
            if (array_key_exists($i, $qtyArray))
                $qty = $qtyArray[$i];

            $this->db->select('*');
            $this->db->from('jsoft_products');
            $this->db->where('pid', $row);
            $query = $this->db->get();
            $pr = $query->row_array();
            $pr2 = $pr;
            $c_qty = $pr['qty'];
            if ($c_qty - $qty < 0) {
            } elseif ($c_qty - $qty == 0) {


                if ($pr['merge'] == 2) {

                    $this->db->select('pid,product_name,icbper,talla,tipo,codigosunat,idtipoexistencia,color');
                    $this->db->from('jsoft_products');
                    $this->db->where('pid', $pr['sub']);
                    $this->db->where('warehouse', $to_warehouse);
                    $query = $this->db->get();
                    $pr = $query->row_array();
                } else {
                    $this->db->select('pid,product_name,icbper,talla,tipo,codigosunat,idtipoexistencia,color');
                    $this->db->from('jsoft_products');
                    $this->db->where('merge', 2);
                    $this->db->where('sub', $row);
                    $this->db->where('warehouse', $to_warehouse);
                    $query = $this->db->get();
                    $pr = $query->row_array();
                }


                $c_pid = $pr['pid'];
                $product_name = $pr['product_name'];

                if ($c_pid) {

                    $this->db->set('qty', "qty+$qty", FALSE);
                    $this->db->where('pid', $c_pid);
                    $this->db->update('jsoft_products');
                    $this->aauth->applog("[Transferencia de Producto] -$product_name  -Cant.-$qty ID " . $c_pid, $this->aauth->get_user()->username);
                    $this->db->delete('jsoft_products', array('pid' => $row));
                    $this->db->delete('jsoft_movers', array('d_type' => 1, 'rid1' => $row));
                } else {
                    $updateArray[] = array(
                        'pid' => $row,
                        'warehouse' => $to_warehouse
                    );
                    $move = true;
                    $product_name = $pr2['product_name'];
                    $this->db->delete('jsoft_movers', array('d_type' => 1, 'rid1' => $row));

                    $this->movers(1, $row, $qty, 0, 'Stock Transferido e Inicializado W- ' . $to_warehouse_name);
                    $this->aauth->applog("[Transferencia de Producto] -$product_name  -Cant.-$qty W- $to_warehouse_name PID " . $pr2['pid'], $this->aauth->get_user()->username);
                }
            } else {
                $data['product_name'] = $pr['product_name'];
                $data['pcat'] = $pr['pcat'];
                $data['warehouse'] = $to_warehouse;
                $data['product_name'] = $pr['product_name'];
                $data['product_code'] = $pr['product_code'];
                $data['product_price'] = $pr['product_price'];
                $data['fproduct_price'] = $pr['fproduct_price'];
                $data['taxrate'] = $pr['taxrate'];
                $data['disrate'] = $pr['disrate'];
                $data['qty'] = $qty;
                $data['product_des'] = $pr['product_des'];
                $data['alert'] = $pr['alert'];
                $data['	unit'] = $pr['unit'];
                $data['image'] = $pr['image'];
                $data['barcode'] = $pr['barcode'];
                $data['merge'] = 2;
                $data['sub'] = $row;
                $data['vb'] = $to_warehouse;
                $data['icbper'] = $pr['icbper'];
                $data['talla'] = $pr['talla'];
                $data['tipo'] = $pr['tipo'];
                $data['codigosunat'] = $pr['codigosunat'];
                $data['idtipoexistencia'] = $pr['idtipoexistencia'];
                $data['color'] = $pr['color'];
                if ($pr['merge'] == 2) {
                    $this->db->select('pid,product_name');
                    $this->db->from('jsoft_products');
                    $this->db->where('pid', $pr['sub']);
                    $this->db->where('warehouse', $to_warehouse);
                    $query = $this->db->get();
                    $pr = $query->row_array();
                } else {
                    $this->db->select('pid,product_name');
                    $this->db->from('jsoft_products');
                    $this->db->where('merge', 2);
                    $this->db->where('sub', $row);
                    $this->db->where('warehouse', $to_warehouse);
                    $query = $this->db->get();
                    $pr = $query->row_array();
                }


                $c_pid = $pr['pid'];
                $product_name = $pr2['product_name'];

                if ($c_pid) {

                    $this->db->set('qty', "qty+$qty", FALSE);
                    $this->db->where('pid', $c_pid);
                    $this->db->update('jsoft_products');

                    $this->movers(1, $c_pid, $qty, 0, 'Stock transferido W ' . $to_warehouse_name);
                    $this->aauth->applog("[Product Transfer] -$product_name  -Cant.-$qty W $to_warehouse_name  ID " . $c_pid, $this->aauth->get_user()->username);
                } else {
                    $this->db->insert('jsoft_products', $data);
                    $pid = $this->db->insert_id();
                    $this->movers(1, $pid, $qty, 0, 'Stock Transferido e Inicializado W ' . $to_warehouse_name);
                    $this->aauth->applog("[Transferencia de Producto] -$product_name  -Cant.-$qty  W $to_warehouse_name ID " . $pr2['pid'], $this->aauth->get_user()->username);
                }

                $this->db->set('qty', "qty-$qty", FALSE);
                $this->db->where('pid', $row);
                $this->db->update('jsoft_products');
                $this->movers(1, $row, -$qty, 0, 'Stock transferido WID ' . $to_warehouse_name);
            }


            $i++;
        }

        if ($move) {
            $this->db->update_batch('jsoft_products', $updateArray, 'pid');
        }

        echo json_encode(array('status' => 'Success', 'message' =>
        $this->lang->line('UPDATED')));
    }

    public function meta_delete($name)
    {
        if (@unlink(FCPATH . 'userfiles/product/' . $name)) {
            return true;
        }
    }

    public function valid_warehouse($warehouse)
    {
        $this->db->select('id,loc');
        $this->db->from('jsoft_warehouse');
        $this->db->where('id', $warehouse);
        $query = $this->db->get();
        $row = $query->row_array();
        return $row;
    }

    public function movers($type = 0, $rid1 = 0, $rid2 = 0, $rid3 = 0, $note = '')
    {
        $data = array(
            'd_type' => $type,
            'rid1' => $rid1,
            'rid2' => $rid2,
            'rid3' => $rid3,
            'note' => $note
        );
        $this->db->insert('jsoft_movers', $data);
    }
}
