<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Restservice_model extends CI_Model
{

    public function customers($id = '')
    {

        $this->db->select('*');
        $this->db->from('jsoft_customers');
        if ($id != '') {

            $this->db->where('id', $id);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function delete_customer($id)
    {
        return $this->db->delete('jsoft_customers', array('id' => $id));
    }
    
    public function employee_details($id)
    {
         $this->db->select('jsoft_employees.*,jsoft_users.email,jsoft_users.loc,jsoft_users.roleid,js.id as eid, js.ruc, js.cname , js.ncomercial , js.address as eaddress, js.phone as ephone, js.email as eemail, js.logo');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $this->db->join('jsoft_system js','js.id = js.id');
        return $this->db->get();
    }

    public function products($id = '')
    {

        $this->db->select('*');
        $this->db->from('jsoft_products');
        if ($id != '') {

            $this->db->where('id', $id);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function invoice()
    {
        $this->db->select('jsoft_invoices.*, jsoft_invoices.id as fid, s.serie,jsoft_customers.*,jsoft_invoices.id AS iid,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
        $this->db->from('jsoft_invoices');
        $this->db->where('jsoft_invoices.loc', '0');
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_invoices.term', 'left');
         $this->db->join('serie s', 'jsoft_invoices.idserie = s.id');
        return $this->db->get();
    }
    
    public function invoice_detalles($id)
    {
        $this->db->select('jsoft_invoice_items.*');
        $this->db->from('jsoft_invoice_items');
        $this->db->where('jsoft_invoice_items.tid', $id);
        
        return $this->db->get();

    }
    
    public function ventasHoy($today)
    {

        $where = "DATE(invoicedate) ='$today'";
        $this->db->select_sum('total');
        $this->db->from('jsoft_invoices');
        $this->db->where($where);
        
            $this->db->where('loc', 0);
        
        $query = $this->db->get();
        return $query->row()->total;
    }
    
    public function ventasMes($month, $year)
    {
        $today = date('Y-m-d');
		$days=date("t", strtotime($today));
        $where = "DATE(invoicedate) BETWEEN '$year-$month-01' AND '$year-$month-$days'";
        $this->db->select_sum('total');
        $this->db->from('jsoft_invoices');
        $this->db->where($where);
              
        $this->db->where('loc', 0);
        
        
        $query = $this->db->get();
        return $query->row()->total;
    }
    
    public function ventasAnio($year)
    {
        
		$where = "YEAR(invoicedate) = '$year'";
        $this->db->select_sum('total');
        $this->db->from('jsoft_invoices');
        $this->db->where($where);
              
        $this->db->where('loc', 0);
        
        
        $query = $this->db->get();
        return $query->row()->total;
    }
    
    public function ganancias($year)
    {
        
		$where = "YEAR(invoicedate) = '$year'";
        $this->db->select_sum('total');
        $this->db->from('jsoft_invoices');
        $this->db->where($where);
              
        $this->db->where('loc', 0);
        $query = $this->db->get();
        
        $whr = ' AND (loc=0)';
        
        $query2 = $this->db->query("SELECT SUM(debit) AS total FROM jsoft_transactions WHERE ((YEAR(date) = '$year') AND type='Expense') $whr");
        
        
        $suma = $query->row()->total - $query2->row()->total;
        return $suma;
    }


}