<?php


defined('BASEPATH') OR exit('No direct script access allowed');
use Greenter\Model\Sale\Invoice;
use Greenter\Model\Sale\SaleDetail;
use Greenter\Model\Sale\Legend;
use Greenter\Ws\Services\SunatEndpoints;
use Greenter\Model\Client\Client;
use Greenter\Model\Company\Address;
use Greenter\Model\Company\Company;
use Greenter\Model\Sale\FormaPagos\FormaPagoContado;
require 'vendor/autoload.php';

class Quote_model extends CI_Model
{
    var $table = 'jsoft_quotes';
    var $column_order = array(null, 'jsoft_quotes.tid', 'jsoft_customers.name', 'jsoft_quotes.invoicedate', 'jsoft_quotes.total', 'jsoft_quotes.status', null);
    var $column_search = array('jsoft_quotes.tid', 'jsoft_customers.name', 'jsoft_quotes.invoicedate', 'jsoft_quotes.total','jsoft_quotes.status',);
    var $order = array('jsoft_quotes.tid' => 'desc');

    public function __construct()
    {
        parent::__construct();
        $this->load->model('pos_invoices_model', 'invocies');
    }

    public function lastquote()
    {
        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->order_by('tid', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->tid;
        } else {
            return 1000;
        }
    }

    public function warehouses()
    {
        $this->db->select('*');
        $this->db->from('jsoft_warehouse');
       if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
          if(BDATA)  $this->db->or_where('loc', 0);
        }  elseif(!BDATA) { $this->db->where('loc', 0); }


        $query = $this->db->get();
        return $query->result_array();

    }

    public function quote_details($id)
    {

        $this->db->select('jsoft_quotes.*,jsoft_quotes.id AS iid,SUM(jsoft_quotes.shipping + jsoft_quotes.ship_tax) AS shipping,jsoft_customers.*,jsoft_quotes.loc as loc,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms');
        $this->db->from($this->table);
        $this->db->where('jsoft_quotes.id', $id);
         if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_quotes.loc', $this->aauth->get_user()->loc);
        } elseif (!BDATA) {
            $this->db->where('jsoft_quotes.loc', 0);
        }
        $this->db->join('jsoft_customers', 'jsoft_quotes.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_quotes.term', 'left');
        $query = $this->db->get();
        return $query->row_array();

    }

    public function quote_products($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_quotes_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();

    }


    public function quote_delete($id)
    {
        $this->db->trans_start();
          if ($this->aauth->get_user()->loc) {
                $res = $this->db->delete('jsoft_quotes', array('id' => $id, 'loc' => $this->aauth->get_user()->loc));
        }
        else {
            if (BDATA) {
                    $res = $this->db->delete('jsoft_quotes', array('id' => $id));

            } else {
                    $res = $this->db->delete('jsoft_quotes', array('id' => $id,'loc' => 0));
            }
        }
        if ($this->db->affected_rows()) $this->db->delete('jsoft_quotes_items', array('tid' => $id));
        if ($this->db->trans_complete()) {
            return true;
        } else {
            return false;
        }
    }


    private function _get_datatables_query($eid)
    {

        $this->db->select('jsoft_quotes.id,jsoft_quotes.tid,jsoft_quotes.invoicedate,jsoft_quotes.invoiceduedate,jsoft_quotes.total,jsoft_quotes.status,jsoft_customers.name');
        $this->db->from($this->table);
        if ($eid) $this->db->where('jsoft_quotes.eid', $eid);
                if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_quotes.loc', $this->aauth->get_user()->loc);
        }
        elseif(!BDATA) { $this->db->where('jsoft_quotes.loc', 0); }
                        if ($this->input->post('start_date') && $this->input->post('end_date')) // if datatable send POST for search
        {
            $this->db->where('DATE(jsoft_quotes.invoiceduedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_quotes.invoiceduedate) <=', datefordatabase($this->input->post('end_date')));
        }

        $this->db->join('jsoft_customers', 'jsoft_quotes.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($eid)
    {
        $this->_get_datatables_query($eid);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_quotes.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_quotes.loc', 0); }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($eid)
    {
        $this->_get_datatables_query($eid);
    if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_quotes.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_quotes.loc', 0); }
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($eid)
    {
        $this->db->select('jsoft_quotes.id');
        $this->db->from($this->table);
         if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_quotes.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_quotes.loc', 0); }
        if ($eid) $this->db->where('jsoft_quotes.eid', $eid);
        return $this->db->count_all_results();
    }


    public function billingterms()
    {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $this->db->where('type', 2);
        $this->db->or_where('type', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function employee($id)
    {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function convert($id)
    {
        $this->load->helper('convertir');
        $idserie = $this->input->post('serie');
        $idtipocomprobante = $this->input->post('comprobante');
        $iddoc = $this->input->post('iddoc');
        $p_method = $this->input->post('p_method');
        $efectivo = $this->input->post('efectivo');
        $vuelto = $this->input->post('vuelto');
        $invoices = $this->quote_details($id);
        $products = $this->quote_products($id);
        $total_tax = 0;
        $icbper = 0;
        $this->db->trans_start();
        $invocieno = $this->invocies->lastinvoice($idtipocomprobante,$idserie);
        $loc = location($this->aauth->get_user()->loc);
        $cur = currency($this->aauth->get_user()->loc);

                if ($cur == 'S/') {
                    $mon = 'PEN';
                } else {
                    $mon = 'USD';
                }
        $productlist = array();
        $prodindex = 0;
        if($invoices['loc']==$this->aauth->get_user()->loc) {
            $data1 = array('idserie' => $idserie,'tid' => $invocieno, 'tipocomprobante' => $idtipocomprobante, 'iddoc' => $iddoc,  'invoicedate' => $invoices['invoicedate'], 'invoiceduedate' => $invoices['invoicedate'], 'subtotal' => $invoices['subtotal'], 'shipping' => $invoices['shipping'], 'discount' => $invoices['discount'], 'tax' => $invoices['tax'], 'total' => $invoices['total'], 'pmethod' => $p_method, 'notes' => $invoices['notes'], 'idtipooperacion' => '0101', 'csd' => $invoices['csd'], 'eid' => $invoices['eid'], 'pamnt' => $invoices['subtotal'], 'items' => $invoices['items'], 'taxstatus' => $invoices['taxstatus'], 'discstatus' => $invoices['discstatus'], 'format_discount' => $invoices['format_discount'], 'refer' => $invoices['refer'], 'term' => $invoices['term'],'multi' => $invoices['multi'], 'loc' => $invoices['loc'], 'i_class' => 1, 'icbper' => '0', 'efectivo' => $efectivo, 'vuelto' => $vuelto, 'moneda' => $mon);
            $this->db->insert('jsoft_invoices', $data1);
            $iid = $this->db->insert_id();
            $bill_date = datefordatabase($invoices['invoicedate']);
            foreach ($products as $row) {
                $amt = $row['qty'];
               
                $total_tax += numberClean($row['totaltax']);
                $data = array(
                    'idserie' => $idserie,
                    'tid' => $iid,
                    'tipocomprobante' => $idtipocomprobante,
                    'idtipoprecio' => '01',
                    'idtipoafectacion' => '20',
                    'pid' => $row['pid'],
                    'product' => $row['product'],
                    'code' => $row['code'],
                    'qty' => $amt,
                    'price' => $row['price'],
                    'tax' => $row['tax'],
                    'discount' => $row['discount'],
                    'subtotal' => $row['subtotal'],
                    'totaltax' => $row['totaltax'],
                    'totaldiscount' => $row['totaldiscount'],
                    'product_des' => $row['product_des'],
                    'unit' => $row['unit'],
                    'icbper' => 0,
                    'codsunat' => $loc['codigosunat'],
                );
                $productlist[$prodindex] = $data;
                $prodindex++;
                $this->db->set('qty', "qty-$amt", FALSE);
                $this->db->where('pid', $row['pid']);
                $this->db->update('jsoft_products');
            }


            $this->db->insert_batch('jsoft_invoice_items', $productlist);
            
            //Creacion de Xml para envío a SUNAT
            $totaletras = num_to_letras($invoices['total'], $mon);
            
            $this->db->select('*');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $invoices['csd']);
                $queryr = $this->db->get();
                $result_cus = $queryr->row_array();
                
                $this->db->select('*');
                $this->db->from('tipocomprobante');
                $this->db->where('idtipocomprobante', $idtipocomprobante);
                $queryt = $this->db->get();
                $result_comp = $queryt->row_array();

                $this->db->select('*');
                $this->db->from('serie');
                $this->db->where('id', $idserie);
                $queryserie = $this->db->get();
                $result_serie = $queryserie->row_array();

               
                $codley = '2001';
                $leyenda = 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';
                $rpta = "";
                $linkxml = "";
                $subtotal = $invoices['subtotal'];
                $total = $invoices['total'];
                
                $util = Util::getInstance();
                if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
                    
// Cliente
                    $client = new Client();
                    $client->setTipoDoc($iddoc)
                            ->setNumDoc($result_cus['numdoc'])
                            ->setRznSocial($result_cus['name'])
                            ->setAddress((new Address())
                                    ->setDireccion($result_cus['address']))
                            ->setEmail($result_cus['email'])
                            ->setTelephone($result_cus['phone']);
// Venta
                    $invoice = new Invoice();
                    $invoice
                            ->setUblVersion('2.1')
                            ->setTipoOperacion('0101')
                            ->setTipoDoc($result_comp['numtipo_comprobante'])
                            ->setSerie($result_serie['serie'])
                            ->setCorrelativo($invocieno)
                            ->setFechaEmision(new DateTime($bill_date))
                            ->setFormaPago(new FormaPagoContado())
                            ->setTipoMoneda($mon)
                            ->setCompany((new Company())
                                    ->setRuc($loc['ruc'])
                                    ->setNombreComercial($loc['ncomercial'])
                                    ->setRazonSocial($loc['cname'])
                                    ->setAddress((new Address())
                                            ->setUbigueo($loc['ubigeo'])
                                            ->setDistrito($loc['city'])
                                            ->setProvincia($loc['region'])
                                            ->setDepartamento($loc['country'])
                                            ->setUrbanizacion('NONE')
                                            ->setCodLocal($loc['codlocal'])
                                            ->setDireccion($loc['address']))
                                    ->setEmail($loc['email'])
                                    ->setTelephone($loc['phone']))
                            ->setClient($client)
                            ->setMtoOperGravadas(0)
                            ->setMtoOperExoneradas($subtotal)
                            ->setMtoIGV($total_tax)
                            ->setIcbper(0)
                            ->setTotalImpuestos($total_tax + 0)
                            ->setValorVenta($subtotal)
                            ->setSubTotal($subtotal)
                            ->setMtoImpVenta($total);

                    $detalles = [];
                    foreach ($productlist as $detail) {
                        $items = new SaleDetail();
                        $items->setCodProducto($detail['code'])
                                ->setUnidad($detail['unit'])
                                ->setCantidad($detail['qty'])
                                ->setDescripcion($detail['product'])
                                ->setMtoValorUnitario($detail['price'])
                                ->setMtoPrecioUnitario($detail['price'])
                                ->setCodProdSunat($loc['codigosunat'])
                                ->setMtoValorVenta($detail['subtotal'])
                                ->setTipAfeIgv($detail['idtipoafectacion'])
                                ->setMtoBaseIgv($detail['subtotal'])
                                ->setPorcentajeIgv($detail['tax'])
                                ->setIgv($detail['totaltax'])
                                ->setIcbper(($detail['qty']) * (0)) // (cantidad)*(factor ICBPER)
                                ->setFactorIcbper($loc['icbper'])
                                ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                        $detalles[] = $items;
                    }

                    $invoice->setDetails($detalles)
                            ->setLegends([
                                (new Legend())
                                ->setCode('1000')
                                ->setValue($totaletras),
                                (new Legend())
                                ->setCode($codley)
                                ->setValue($leyenda)
                                    //(new Legend())
                                    //->setCode('2004')
                                    //->setValue('Agencia de Viaje - Paquete turístico')
                    ]);

// Envio a SUNAT.
                    $rutacert = '/../resources/' . $loc['certificado'];
                    $ruc = $loc['ruc'];
                    $usuario = $loc['usuariosol'];
                    $sol = $loc['clavesol'];
                    if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                        $modo = SunatEndpoints::FE_PRODUCCION;
                    } else {
                        $modo = SunatEndpoints::FE_BETA;
                        $ruc = '10770468341';

                        $usuario = 'MODDATOS';
                        $sol = 'moddatos';
                    }

                   
                        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);                        
                        $xml = $see->getXmlSigned($invoice);
                        $util->writeXml($invoice, $xml);
                        $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                        $filename = $invoice->getName();
                        $this->db->set(array('sunat' => 'Guardado', 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $iid);
                        $this->db->update('jsoft_invoices');
                    
                }


            //profit calculation
            $t_profit = 0;
            $this->db->select('jsoft_invoice_items.pid, jsoft_invoice_items.price, jsoft_invoice_items.qty, jsoft_products.fproduct_price');
            $this->db->from('jsoft_invoice_items');
            $this->db->join('jsoft_products', 'jsoft_products.pid = jsoft_invoice_items.pid', 'left');
            $this->db->where('jsoft_invoice_items.tid', $iid);
            $query = $this->db->get();
            $pids = $query->result_array();
            foreach ($pids as $profit) {
                $t_cost = $profit['fproduct_price'] * $profit['qty'];
                $s_cost = $profit['price'] * $profit['qty'];
                $t_profit += $s_cost - $t_cost;
            }
            $data = array('type' => 9, 'rid' => $iid, 'col1' => rev_amountExchange_s($t_profit, $invoices['multi'], $this->aauth->get_user()->loc), 'd_date' => $bill_date);

            $this->db->insert('jsoft_metadata', $data);

            if ($this->db->trans_complete()) {
                $this->db->set('status', 'accepted');
                $this->db->where('id', $id);
                $this->db->update('jsoft_quotes');
                return true;
            } else {
                return false;
            }
        }else{

                return false;

        }

    }

     public function convert_po($id,$person)
    {

        $invoice = $this->quote_details($id);
        $products = $this->quote_products($id);
        $this->db->trans_start();
        $this->db->select('tid');
        $this->db->from('jsoft_purchase');
        $this->db->order_by('tid', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $iid = $query->row()->tid + 1;
        } else {
            $iid = 1000;
        }
        $productlist = array();
        $prodindex = 0;
        if($invoice['loc']==$this->aauth->get_user()->loc) {
            $data = array('tid' => $iid, 'invoicedate' => $invoice['invoicedate'], 'invoiceduedate' => $invoice['invoicedate'], 'subtotal' => $invoice['invoicedate'], 'shipping' => $invoice['shipping'], 'discount' => $invoice['discount'], 'tax' => $invoice['tax'], 'total' => $invoice['total'], 'notes' => $invoice['notes'], 'csd' => $person, 'eid' => $invoice['eid'], 'items' => $invoice['items'], 'taxstatus' => $invoice['taxstatus'], 'discstatus' => $invoice['discstatus'], 'format_discount' => $invoice['format_discount'], 'refer' => $invoice['refer'], 'term' => $invoice['term'],'multi' => $invoice['multi'], 'loc' => $invoice['loc']);
            $this->db->insert('jsoft_purchase', $data);
            $iid = $this->db->insert_id();
            foreach ($products as $row) {
                $amt = $row['qty'];
                $data = array(
                    'tid' => $iid,
                    'pid' => $row['pid'],
                    'product' => $row['product'],
                    'code' => $row['code'],
                    'qty' => $amt,
                    'price' => $row['price'],
                    'tax' => $row['tax'],
                    'discount' => $row['discount'],
                    'subtotal' => $row['subtotal'],
                    'totaltax' => $row['totaltax'],
                    'totaldiscount' => $row['totaldiscount'],
                    'product_des' => $row['product_des'],
                    'unit' => $row['unit']
                );
                $productlist[$prodindex] = $data;
                $prodindex++;
                $this->db->set('qty', "qty+$amt", FALSE);
                $this->db->where('pid', $row['pid']);
                $this->db->update('jsoft_products');
            }


            $this->db->insert_batch('jsoft_purchase_items', $productlist);




            if ($this->db->trans_complete()) {
                $this->db->set('status', 'accepted');
                $this->db->where('id', $id);
                $this->db->update('jsoft_quotes');
                return true;
            } else {
                return false;
            }
        }else{

                return false;

        }

    }

    public function currencies()
    {

        $this->db->select('*');
        $this->db->from('jsoft_currencies');

        $query = $this->db->get();
        return $query->result_array();

    }

    public function currency_d($id)
    {
        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function meta_insert($id, $type, $meta_data)
    {

        $data = array('type' => $type, 'rid' => $id, 'col1' => $meta_data);
        if ($id) {
            return $this->db->insert('jsoft_metadata', $data);
        } else {
            return 0;
        }
    }

    public function attach($id)
    {
        $this->db->select('jsoft_metadata.*');
        $this->db->from('jsoft_metadata');
        $this->db->where('jsoft_metadata.type', 2);
        $this->db->where('jsoft_metadata.rid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function meta_delete($id, $type, $name)
    {
        if (@unlink(FCPATH . 'userfiles/attach/' . $name)) {
            return $this->db->delete('jsoft_metadata', array('rid' => $id, 'type' => $type, 'col1' => $name));
        }
    }


}