<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoices_model extends CI_Model
{
    var $table = 'jsoft_invoices';
    var $tableb = 'jsoft_comunicacion_baja';
    var $column_order = array(null, 'jsoft_invoices.tid', 'jsoft_customers.name', 'jsoft_invoices.invoicedate', 'jsoft_invoices.total', 'jsoft_invoices.status', null);
    var $column_search = array('jsoft_invoices.tid', 'jsoft_customers.name', 'jsoft_invoices.invoicedate', 'jsoft_invoices.total','jsoft_invoices.status');
    var $order = array('jsoft_invoices.tid' => 'desc');

    public function __construct()
    {
        parent::__construct();
    }

    public function lastinvoice()
    {
        $this->db->select('tid');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $this->db->where('i_class', 0);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->tid;
        } else {
            return "00000001";
        }
    }

    public function lastcomunicacionbaja()
    {
        $this->db->select('id');
        $this->db->from($this->tableb);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->id;
        } else {
            return "1";
        }
    }

    public function invoice_details($id, $eid = '',$p=true)
    {
        $this->db->select('jsoft_invoices.*,s.serie,SUM(jsoft_invoices.shipping + jsoft_invoices.ship_tax) AS shipping,jsoft_customers.*,jsoft_invoices.loc as loc,jsoft_invoices.id AS iid,jsoft_customers.id AS cid,jsoft_terms.id AS termid,jsoft_terms.title AS termtit,jsoft_terms.terms AS terms, jsoft_customers.iddoc AS doccliente');
        $this->db->from($this->table);
        $this->db->join('serie s', 'jsoft_invoices.idserie = s.id');
        $this->db->where('jsoft_invoices.id', $id);
        if ($eid) {
            $this->db->where('jsoft_invoices.eid', $eid);
        }
        if($p) {


            if ($this->aauth->get_user()->loc) {
                $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
            } elseif (!BDATA) {
                $this->db->where('jsoft_invoices.loc', 0);
            }
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd = jsoft_customers.id', 'left');
        $this->db->join('jsoft_terms', 'jsoft_terms.id = jsoft_invoices.term', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function invoice_products($id)
    {

        $this->db->select('*');
        $this->db->from('jsoft_invoice_items');
        $this->db->where('tid', $id);
        $query = $this->db->get();
        return $query->result_array();

    }

    public function currencies()
    {

        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function currency_d($id, $loc = 0)
    {
        if ($loc) {
            $query = $this->db->query("SELECT cur FROM jsoft_locations WHERE id='$loc' LIMIT 1");
            $row = $query->row_array();
            $id = $row['cur'];
        }
        $this->db->select('*');
        $this->db->from('jsoft_currencies');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function warehouses()
    {
        $this->db->select('*');
        $this->db->from('jsoft_warehouse');
        if ($this->aauth->get_user()->loc) {
            $this->db->where('loc', $this->aauth->get_user()->loc);
          if(BDATA)  $this->db->or_where('loc', 0);
        }  elseif(!BDATA) { $this->db->where('loc', 0); }

        $query = $this->db->get();

        return $query->result_array();

    }

    public function invoice_transactions($id)
    {

         $this->db->select('*');
        $this->db->from('jsoft_transactions');
        $this->db->where('tid', $id);
        $this->db->where('ext', 0);
        $query = $this->db->get();
        return $query->result_array();

    }

    public function invoice_delete($id, $eid = '')
    {
        $this->db->trans_start();
        $this->db->select('tid,total,status');
        $this->db->from('jsoft_invoices');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->row_array();
        if ($this->aauth->get_user()->loc) {
            if ($eid) {

                $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid, 'loc' => $this->aauth->get_user()->loc));


            } else {
                $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'loc' => $this->aauth->get_user()->loc));
            }
        }

        else {
            if (BDATA) {
                if ($eid) {

                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid));


                } else {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id));
                }
            } else {


                if ($eid) {

                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'eid' => $eid, 'loc' => 0));


                } else {
                    $res = $this->db->delete('jsoft_invoices', array('id' => $id, 'loc' => 0));
                }
            }
        }

        $affect = $this->db->affected_rows();

        if ($res) {
            if ($result['status'] != 'canceled') {
                $this->db->select('pid,qty');
                $this->db->from('jsoft_invoice_items');
                $this->db->where('tid', $id);
                $query = $this->db->get();
                $prevresult = $query->result_array();

                foreach ($prevresult as $prd) {
                    $amt = $prd['qty'];
                    $this->db->set('qty', "qty+$amt", FALSE);
                    $this->db->where('pid', $prd['pid']);
                    $this->db->update('jsoft_products');
                }
            }


            if ($affect) $this->db->delete('jsoft_invoice_items', array('tid' => $id));

            $data = array('type' => 9, 'rid' => $id);
            $this->db->delete('jsoft_metadata', $data);

                        $alert= $this->custom->api_config(66);
            if ($alert['method'] == 1) {
                 $this->load->model('communication_model');
                 $subject= $result['tid'].' '. $this->lang->line('DELETED');
                 $body=$subject.'<br> '. $this->lang->line('Amount').' '. $result['total'].'<br> '. $this->lang->line('Employee').' '. $this->aauth->get_user()->username.'<br> ID# '. $result['tid'];
               $out= $this->communication_model->send_corn_email($alert['url'], $alert['url'], $subject, $body, false, '');
            }

            if ($this->db->trans_complete()) {
                return true;
            } else {
                return false;
            }
        }

    }


    private function _get_datatables_query($opt = '')
    {
        $this->db->select('jsoft_invoices.id, CONCAT(serie.serie, "-",jsoft_invoices.tid) AS serie,jsoft_invoices.invoicedate,jsoft_invoices.sunat,jsoft_invoices.respuesta,jsoft_invoices.invoiceduedate,jsoft_invoices.total,jsoft_invoices.status,jsoft_customers.name, jsoft_invoices.nomarchivo, jsoft_invoices.tipocomprobante');
        $this->db->from($this->table);
        $this->db->join('serie','jsoft_invoices.idserie = serie.id');
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        }
        elseif(!BDATA) { $this->db->where('jsoft_invoices.loc', 0); }
        if ($this->input->post('start_date') && $this->input->post('end_date')) // if datatable send POST for search
        {
            $this->db->where('DATE(jsoft_invoices.invoicedate) >=', datefordatabase($this->input->post('start_date')));
            $this->db->where('DATE(jsoft_invoices.invoicedate) <=', datefordatabase($this->input->post('end_date')));
        }
        $this->db->join('jsoft_customers', 'jsoft_invoices.csd=jsoft_customers.id', 'left');

        $i = 0;

        foreach ($this->column_search as $item) // loop column
        {
            if ($this->input->post('search')['value']) // if datatable send POST for search
            {

                if ($i === 0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables($opt = '')
    {
        $this->_get_datatables_query($opt);
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        $this->db->where('jsoft_invoices.i_class', 1);
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_invoices.loc', 1); }

        return $query->result();
    }

    function count_filtered($opt = '')
    {
        $this->_get_datatables_query($opt);
        if ($opt) {
            $this->db->where('eid', $opt);
        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_invoices.loc', 0); }
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($opt = '')
    {
        $this->db->select('jsoft_invoices.id');
        $this->db->from($this->table);
        $this->db->where('jsoft_invoices.i_class', 0);
        if ($opt) {
            $this->db->where('jsoft_invoices.eid', $opt);

        }
        if ($this->aauth->get_user()->loc) {
            $this->db->where('jsoft_invoices.loc', $this->aauth->get_user()->loc);
        }  elseif(!BDATA) { $this->db->where('jsoft_invoices.loc', 0); }
        return $this->db->count_all_results();
    }


    public function billingterms()
    {
        $this->db->select('id,title');
        $this->db->from('jsoft_terms');
        $this->db->where('type', 1);
        $this->db->or_where('type', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function employee($id)
    {
        $this->db->select('jsoft_employees.name,jsoft_employees.sign,jsoft_users.roleid');
        $this->db->from('jsoft_employees');
        $this->db->where('jsoft_employees.id', $id);
        $this->db->join('jsoft_users', 'jsoft_employees.id = jsoft_users.id', 'left');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function meta_insert($id, $type, $meta_data)
    {
        $data = array('type' => $type, 'rid' => $id, 'col1' => $meta_data);
        if ($id) {
            return $this->db->insert('jsoft_metadata', $data);
        } else {
            return 0;
        }
    }

    public function attach($id)
    {
        $this->db->select('jsoft_metadata.*');
        $this->db->from('jsoft_metadata');
        $this->db->where('jsoft_metadata.type', 1);
        $this->db->where('jsoft_metadata.rid', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function meta_delete($id, $type, $name)
    {
        if (@unlink(FCPATH . 'userfiles/attach/' . $name)) {
            return $this->db->delete('jsoft_metadata', array('rid' => $id, 'type' => $type, 'col1' => $name));
        }
    }

    public function gateway_list($enable = '')
    {
        $this->db->from('jsoft_gateways');
        if ($enable == 'Yes') {
            $this->db->where('enable', 'Yes');
        }
        $query = $this->db->get();
        return $query->result_array();
    }
}