<?php


defined('BASEPATH') OR exit('No direct script access allowed');

class Consulta_model extends CI_Model
{
    

    public function __construct()
    {
        parent::__construct();
    }



    public function moneda()
    {
        $this->db->select('code,symbol');
        $this->db->from('jsoft_currencies');        
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function tipocomprobante()
    {
        $this->db->select('idtipocomprobante,nombre_docu');
        $this->db->from('tipocomprobante');
        $this->db->order_by('numtipo_comprobante', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function buscar_cpe($tipocomp, $serie, $correlativo, $moneda, $fecha, $total)
    {
        $this->db->select('*, ji.id as uid');
        $this->db->from('jsoft_invoices ji');
        $this->db->join('serie s', 'ji.idserie = s.id');
        $this->db->where('tipocomprobante', $tipocomp);
        $this->db->where('serie', $serie);
        $this->db->where('tid', $correlativo);
        $this->db->or_where('CAST(tid AS UNSIGNED) =', intval($correlativo));
        $this->db->where('moneda', $moneda);
        $this->db->where('Date_format(invoicedate,"%d-%m-%Y")', $fecha);
        $this->db->where('total', $total);

        $query = $this->db->get();
        return $query->result_array();
       
        
    }



}
