<?php

defined('BASEPATH') or exit('No direct script access allowed');

//error_reporting(E_ALL);
//ini_set('display_errors', '1');
use Greenter\Model\Sale\Invoice;
use Greenter\Model\Sale\SaleDetail;
use Greenter\Model\Sale\Legend;
use Greenter\Ws\Services\SunatEndpoints;
use Greenter\Model\Client\Client;
use Greenter\Model\Company\Address;
use Greenter\Model\Company\Company;
use Greenter\Model\Sale\Charge;
use Greenter\Model\Sale\FormaPagos\FormaPagoContado;
use Greenter\Model\Voided\VoidedDetail;
use Greenter\Model\Voided\Voided;
use Greenter\Model\Response\SummaryResult;
use Greenter\Model\Sale\Document;
use Greenter\Model\Summary\Summary;
use Greenter\Model\Summary\SummaryDetail;
use Greenter\Model\Summary\SummaryPerception;
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
use Mike42\Escpos\PrintConnectors\DummyPrintConnector;
use Mike42\Escpos\EscposImage;
use Omnipay\Omnipay;
use Endroid\QrCode\QrCode;

require_once APPPATH . 'third_party/vendor/autoload.php';
require_once APPPATH . 'third_party/qrcode/vendor/autoload.php';
require 'vendor/autoload.php';

class Pos_invoices extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('pos_invoices_model', 'invocies');
        $this->load->model('products_model', 'products');
        $this->load->model('customers_model', 'clientes');
        $this->load->model('extended_invoices_model', 'extended_invoice');
        $this->load->library("Aauth");
        $this->load->library("Registerlog");
        $this->load->library("Common");

        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(1)) {
            exit('<h3>¡Lo sentimos! No tiene permisos suficientes para acceder a esta sección.</h3>');
        }
        if ($this->aauth->get_user()->roleid == 2) {
            $this->limited = $this->aauth->get_user()->id;
        } else {
            $this->limited = '';
        }
        $this->load->library("Custom");
        $this->li_a = 'sales';
    }

    //create invoice
    public function create()
    {

        if (!$this->registerlog->check($this->aauth->get_user()->id)) {
            redirect('register/create');
        }
        $this->load->model('customers_model', 'customers');
        $this->load->model('categories_model');
        $this->load->model('plugins_model', 'plugins');
        $this->load->library("Common");
        $data['custom_fields_c'] = $this->custom->add_fields(1);

        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $data['gateway'] = $this->invocies->gateway_list('Yes');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['enable_card'] = $this->plugins->universal_api(54);
        $data['customergrouplist'] = $this->customers->group_list();
        $data['tipodoc'] = $this->invocies->listartipodoc();
        $data['tipop'] = $this->invocies->listartipooperacion();

        $data['invoice'] = $this->invocies->cliente_det();
        $data['draft_list'] = $this->invocies->drafts();
        $data['units'] = $this->products->units();
        $data['tallamedida'] = $this->products->listar_talla_medida();
        $data['custom_fields'] = $this->custom->add_fields(4);
        $data['warehouse'] = $this->invocies->warehouses();
        $data['terms'] = $this->invocies->billingterms();

        $data['tpcomp'] = $this->invocies->tipocomprobante();
        $data['currency'] = $this->invocies->currencies();

        $loc = location($this->aauth->get_user()->loc);

        $head['title'] = strtoupper($loc['ncomercial']) . " | NUEVO COMPROBANTE";

        $head['usernm'] = $this->aauth->get_user()->username;
        $data['cat'] = $this->categories_model->category_list();
        $data['taxdetails'] = $this->common->taxdetail();
        $data['acc_list'] = $this->invocies->accountslist();

        $data['emp'] = $this->plugins->universal_api(69);
        if ($data['emp']['key1']) {
            $this->load->model('employee_model', 'employee');
            $data['employee'] = $this->employee->list_employee();
        }

        if ($this->input->get('v2') or POSV == 2) {
            $head['s_mode'] = false;
            $this->load->view('fixed/header-pos', $head);
            $this->load->view('pos/newinvoice_v2', $data);
        } else {
            $head['s_mode'] = true;
            $this->load->view('fixed/header-pos', $head);
            $this->load->view('pos/newinvoice', $data);
        }
        $this->load->view('fixed/footer-pos');
    }

    public function serie($param)
    {


        echo json_encode($this->invocies->cargarserie($param));
    }

    public function convert()
    {
        $tid = $this->input->post('tid');


        if ($this->invocies->convert($tid)) {

            echo json_encode(array('status' => 'Success', 'message' => 'Se realizó la transacción con éxito'));
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
            $this->lang->line('ERROR')));
        }
    }

    public function correlativo($param = "", $param2 = "")
    {

        if (!$this->registerlog->check($this->aauth->get_user()->id)) {
            redirect('register/create');
        }
        $this->load->model('customers_model', 'customers');
        $this->load->model('categories_model');
        $this->load->model('plugins_model', 'plugins');
        $this->load->library("Common");
        $loc = location($this->aauth->get_user()->loc);

        if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
            if ($param == 'T') {
                $correlativo = $this->invocies->correlativoguia($param, $param2);
            } else {
                $correlativo = $this->invocies->lastinvoice($param, $param2);
            }
        } else {
            $correlativo = $this->invocies->idnoE();
        }

        echo json_encode($correlativo);
    }

    public function tipoprecio()
    {

        $this->load->model('customers_model', 'customers');
        $this->load->model('categories_model');
        $this->load->model('plugins_model', 'plugins');
        $this->load->library("Common");
        $tipoprecio = $this->invocies->tipoprecio();

        echo json_encode($tipoprecio);
    }

    public function tipoafectacion()
    {

        $this->load->model('customers_model', 'customers');
        $this->load->model('categories_model');
        $this->load->model('plugins_model', 'plugins');
        $this->load->library("Common");
        $tipoafctacion = $this->invocies->tipoafectacion();
        echo json_encode($tipoafctacion);
    }

    public function draft()
    {
        $this->load->model('categories_model');
        $data['gateway'] = $this->invocies->gateway_list('Yes');
        $idserie = $this->input->post('serie');
        $idtipocomprobante = $this->input->post('tipocomp');
        $tid = $this->input->get('id');
        $data['id'] = $tid;
        $data['title'] = "Nuevo Comprobante";
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->invocies->billingterms();
        $data['currency'] = $this->invocies->currencies();
        $data['invoice'] = $this->invocies->draft_details($tid, $this->limited);
        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->draft_products($tid);
        $head['title'] = "Editar Comprobante #$tid";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->invocies->warehouses();
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['cat'] = $this->categories_model->category_list();
        $data['lastinvoice'] = $this->invocies->lastinvoice($idtipocomprobante, $idserie);
        $data['taxdetails'] = $this->common->taxdetail();
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));

        if ($this->input->get('v2') or POSV == 2) {
            $head['s_mode'] = false;
            $this->load->view('fixed/header-pos', $head);
            if ($data['invoice']['id'])
                $this->load->view('pos/draft', $data);
        } else {
            $head['s_mode'] = false;
            $this->load->view('fixed/header-pos', $head);
            if ($data['invoice']['id'])
                $this->load->view('pos/draft', $data);
        }
        $this->load->view('fixed/footer-pos');
    }

    //edit invoice
    public function edit()
    {
        if (!$this->registerlog->check($this->aauth->get_user()->id)) {
            redirect('register/create');
        }
        $head['s_mode'] = false;
        $this->load->model('categories_model');
        $data['gateway'] = $this->invocies->gateway_list('Yes');
        $tid = $this->input->get('id');
        $data['id'] = $tid;

        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->invocies->billingterms();
        $data['currency'] = $this->invocies->currencies();
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->invoice_products($tid);
        $head['title'] = "Editar Comprobante #$tid";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->invocies->warehouses();
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['cat'] = $this->categories_model->category_list();
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist_edit($data['invoice']['taxstatus']);
        $this->load->view('fixed/header-pos', $head);
        if ($data['invoice']['id'])
            $this->load->view('pos/edit', $data);
        $this->load->view('fixed/footer-pos');
    }

    // Lista de Comprobantes
    public function index()
    {
        $head['title'] = "Gestionar Comprobantes";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('pos/invoices');
        $this->load->view('fixed/footer');
    }

    // Lista de Notas de Venta
    public function notas()
    {
        $head['title'] = "Gestionar Notas de Venta";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('pos/notas-ventas');
        $this->load->view('fixed/footer');
    }

    // Lista de Notas de Venta
    public function resumen()
    {
        $head['title'] = "Gestionar Resumen";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('pos/resumen');
        $this->load->view('fixed/footer');
    }

    //Lista de Contingencias
    public function listar_contingencias()
    {
        $head['title'] = "Gestionar Contingencias";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('pos/listcontingencia');
        $this->load->view('fixed/footer');
    }

    public function extended()
    {
        $head['title'] = "Gestionar Comprobantes";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('pos/extended');
        $this->load->view('fixed/footer');
    }

    //action
    public function action()
    {
        $this->load->helper('convertir');

        $ptype = $this->input->post('type');
        $coupon = $this->input->post('coupon');
        $notes = $this->input->post('notes', true);
        $coupon_amount = 0;
        $coupon_n = '';
        $customer_id = $this->input->post('customer_id');
        $iddoc = $this->input->post('idtipodoc');
        $idserie = $this->input->post('serie');
        $idtipocomprobante = $this->input->post('tipocomp');
        $idtipop = $this->input->post('tipop');
        $serieg = $this->input->post('serieg');
        $idsguia = $this->input->post('idsguia');
        $correlativog = $this->input->post('correlativog');
        $guia = null;
        $guiacheck = $this->input->post('guiaCheck');
        $almacenid = $this->input->post('almacenid');

        if ($guiacheck == 'on') {
            $guia == $serieg . '-' . $correlativog;
        }

        $serie = '';
        $adjunto = '';
        $nombre_pdf = '';

        $invocieno = $this->invocies->lastinvoice($idtipocomprobante, $idserie);
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $tax = $this->input->post('tax_handle');
        $icbper = $this->input->post('icbpertotal');

        $total_tax = 0;

        $discountFormat = $this->input->post('discountFormat');
        $pterms = $this->input->post('pterms');
        $currency = $this->input->post('mcurrency');
        $total_discount = rev_amountExchange_s($this->input->post('after_disc'), $currency, $this->aauth->get_user()->loc);
        $disc_val = numberClean($this->input->post('disc_val'));
        $ship_taxtype = $this->input->post('ship_taxtype');
        $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
        $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
        $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
        if ($ship_taxtype == 'incl')
            @$shipping = $shipping - $shipping_tax;
        $refer = $this->input->post('refer', true);
        $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
        $st_c = 0;
        $print_now = $this->input->post('printnow');
        $account = $this->input->post('account');
        $this->load->model('plugins_model', 'plugins');
        $empl_e = $this->plugins->universal_api(69);
        if ($empl_e['key1']) {
            $emp = $this->input->post('employee');
        } else {
            $emp = $this->aauth->get_user()->id;
        }
        if ($ptype == 4) {
            $p_amount = rev_amountExchange_s($this->input->post('p_amount'), $currency, $this->aauth->get_user()->loc);
            $pmethod = $this->input->post('p_method');

            $c_amt = $p_amount - $total;
            if ($c_amt == 0.00) {
                $status = 'Paid';
                $pamnt = $total;
            } elseif ($c_amt < 0.00) {
                $status = 'Partial';
                if ($p_amount == 0.00)
                    $status = 'Due';
                $pamnt = $p_amount;
                $c_amt = 0;
            } else {
                $status = 'Paid';
                $pamnt = $total;
                $roundoff = $this->custom->api_config(4);
                if ($roundoff['other'])
                    $pamnt = round($total, $roundoff['active'], constant($roundoff['other']));
            }
            $i = 0;
            if ($discountFormat == '0') {
                $discstatus = 0;
            } else {
                $discstatus = 1;
            }
            if ($customer_id == 0) {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
                exit;
            } else {
                $this->db->select('*');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $result_cus = $query->row_array();
            }
            $this->db->trans_start();
            //products
            $transok = true;
            $this->load->library("Common");
            //Invoice Data
            $bill_date = datefordatabase($invoicedate);
            $bill_due_date = datefordatabase($invocieduedate);
            $promo_flag = false;
            if ($coupon) {
                $this->db->select('*');
                $this->db->from('jsoft_promo');
                $this->db->where('code', $coupon);
                $query = $this->db->get();
                $result_c = $query->row_array();
                if ($result_c['active'] == 0 && $result_c['available'] > 0) {
                    $promo_flag = true;
                    $amount = $result_c['amount'];
                    $notes .= '-' . $this->input->post('i_coupon');
                    $total_discount += $amount;
                }
            }
            $cur = currency($this->aauth->get_user()->loc);

            if ($cur == 'S/') {
                $mon = 'PEN';
            } else {
                $mon = 'USD';
            }
            $data = array(
                'idserie' => $idserie,
                'tid' => $invocieno,
                'tipocomprobante' => $idtipocomprobante,
                'iddoc' => $iddoc,
                'invoicedate' => $bill_date,
                'invoiceduedate' => $bill_due_date,
                'subtotal' => $subtotal,
                'shipping' => $shipping,
                'ship_tax' => $shipping_tax,
                'ship_tax_type' => $ship_taxtype,
                'discount_rate' => $disc_val,
                'total' => $total,
                'pmethod' => $pmethod,
                'notes' => $notes,
                'status' => $status,
                'idtipooperacion' => $idtipop,
                'csd' => $customer_id,
                'eid' => $emp,
                'pamnt' => 0,
                'taxstatus' => $tax,
                'discstatus' => $discstatus,
                'format_discount' => $discountFormat,
                'refer' => $refer,
                'term' => $pterms,
                'multi' => $currency,
                'i_class' => 1,
                'loc' => $this->aauth->get_user()->loc,
                'icbper' => $icbper,
                'efectivo' => $p_amount,
                'vuelto' => $c_amt,
                'moneda' => $mon,
                'guia' => $guia
            );

            if ($this->db->insert('jsoft_invoices', $data)) {

                $invocieno_n = $invocieno;
                $invocieno2 = $invocieno;
                $invocieno = $this->db->insert_id();

                $pid = $this->input->post('pid');
                $productlist = array();
                $prodindex = 0;
                $itc = 0;
                $product_id = $this->input->post('pid');
                $product_name1 = $this->input->post('product_name', true);
                $product_qty = $this->input->post('product_qty');
                $product_price = $this->input->post('product_price');

                $tipo_precio = $this->input->post('tipo_precio');

                $tipo_afectacion = $this->input->post('tipo_afectacion');

                $product_tax = $this->input->post('product_tax');
                $product_discount = $this->input->post('product_discount');
                $product_subtotal = $this->input->post('product_subtotal');
                $ptotal_tax = $this->input->post('taxa');
                $ptotal_disc = $this->input->post('disca');
                $product_des = $this->input->post('product_description', true);
                $product_unit = $this->input->post('unit');
                $product_hsn = $this->input->post('hsn', true);
                $product_alert = $this->input->post('alert');
                $product_serial = $this->input->post('serial');
                $product_icbper = $this->input->post('product_icbper');
                $product_codsunat = $this->input->post('codsunat');
                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('*');
                        $this->db->from('jsoft_products');
                        $this->db->where('pid', $product_id[$key]);
                        $queryp = $this->db->get();
                        $result_p = $queryp->row_array();

                        $total_discount += numberClean(@$ptotal_disc[$key]);
                        $total_tax += numberClean($ptotal_tax[$key]);

                        $data = array(
                            'idserie' => $idserie,
                            'tid' => $invocieno,
                            'tipocomprobante' => $idtipocomprobante,
                            'idtipoprecio' => $tipo_precio[$key],
                            'idtipoafectacion' => $tipo_afectacion[$key],
                            'pid' => $product_id[$key],
                            'product' => rtrim($product_name1[$key]),
                            'code' => $product_hsn[$key],
                            'qty' => numberClean($product_qty[$key]),
                            'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                            'tax' => numberClean($product_tax[$key]),
                            'discount' => numberClean($product_discount[$key]),
                            'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                            'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                            'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                            'product_des' => $product_des[$key],
                            'i_class' => 1,
                            'unit' => $product_unit[$key],
                            'serial' => $product_serial[$key],
                            'icbper' => $product_icbper[$key],
                            'codsunat' => $product_codsunat[$key],
                        );
                        $flag = true;
                        $productlist[$prodindex] = $data;
                        $i++;
                        $prodindex++;

                        $amt = numberClean($product_qty[$key]);

                            if ($product_id[$key] > 0 and $this->common->zero_stock()) {

                                if ((numberClean($product_alert[$key]) - $amt) < 0 and $st_c == 0) {
                                    echo json_encode(array('status' => 'Error', 'message' => 'Producto - <strong>' . $product_name1[$key] . "</strong> - Cantidad baja. El stock disponible es  " . $product_alert[$key]));
                                    $transok = false;
                                    $st_c = 1;
                                    return;
                                } else {
                                    $this->db->set('qty', "qty-$amt", FALSE);
                                    $this->db->where('pid', $product_id[$key]);
                                    $this->db->update('jsoft_products');
                                }
                            }
                            
                        
                        $itc += $amt;
                    }
                }
                if ($prodindex > 0) {
                    $this->db->insert_batch('jsoft_invoice_items', $productlist);
                    $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                    $this->db->where('id', $invocieno);
                    $this->db->update('jsoft_invoices');

                    if (count($product_serial) > 0) {
                        $this->db->set('status', 1);
                        $this->db->where_in('serial', $product_serial);
                        $this->db->update('jsoft_product_serials');
                    }
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    "Elija un producto de la lista. Vaya a la sección Administrador de artículos si no ha agregado los productos."));
                    $transok = false;
                    return;
                }

                if ($guiacheck == 'on') {
                    $data = array(
                        'serie' => $idsguia,
                        'correlativo' => $correlativog,
                        'tipocomprobante' => 'T',
                        'almacen_id' => $almacenid,
                        'cliente_id' => $customer_id,
                        'fecha_emision' => $bill_date,
                        'fecha_entrega' => $bill_due_date,
                        'vehiculo_publico' => $subtotal,
                        'conductor_id' => 1,
                        'tipo_transporte' => 1,
                        'vehiculo_id' => 1,
                        'observacion' => '',
                        'motivo_traslado' => 'Ventas',
                        'user_id' => $emp,
                        'loc' => $this->aauth->get_user()->loc,
                        'tid' => $invocieno
                    );
                    if ($this->db->insert('jsoft_guia_remision', $data)) {
                    
                        $idguia = $this->db->insert_id();
        
                        $productlist = array();
                        $prodindex = 0;
        
                        if (is_array($pid)) {
                            foreach ($pid as $key => $value) {
        
                                $this->db->select('*');
                                $this->db->from('jsoft_products');
                                $this->db->where('pid', $product_id[$key]);
                                $queryp = $this->db->get();
                                $result_p = $queryp->row_array();
        
                                $total_discount += numberClean(@$ptotal_disc[$key]);
                                $total_tax += numberClean($ptotal_tax[$key]);
        
                                $data = array(
                                    'idserie' => $idsguia,
                                    'tid' => $idguia,
                                    'pid' => $product_id[$key],
                                    'product' => rtrim($product_name1[$key]),
                                    'code' => $product_hsn[$key],
                                    'qty' => numberClean($product_qty[$key]),
                                    'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                                    'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                                    'product_des' => $product_des[$key],
                                    'i_class' => 1,
                                    'unit' => $product_unit[$key],
                                );
                               
                                $productlist2[$prodindex] = $data;
                                $i++;
                                $prodindex++;
                               
                            }
                        }
        
                        $this->db->insert_batch('jsoft_guia_items', $productlist2);
                    }
                }

                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                        $this->db->from('jsoft_invoice_items');
                        $this->db->where('idtipoafectacion', 10);
                        $this->db->where('tid', $invocieno);
                        $queryafect = $this->db->get()->result()[0]->subtotal;
                    }
                }

                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                        $this->db->from('jsoft_invoice_items');
                        $this->db->where('idtipoafectacion', 20);
                        $this->db->where('tid', $invocieno);
                        $queryafec = $this->db->get()->result()[0]->subtotal;
                    }
                }

                $this->db->select('*');
                $this->db->from('tipocomprobante');
                $this->db->where('idtipocomprobante', $idtipocomprobante);
                $query = $this->db->get();
                $result_comp = $query->row_array();

                $this->db->select('*');
                $this->db->from('serie');
                $this->db->where('id', $idserie);
                $queryserie = $this->db->get();
                $result_serie = $queryserie->row_array();

                $serie = $result_serie['serie'];

                $loc = location($this->aauth->get_user()->loc);


                $totaletras = num_to_letras($total, $mon);
                $rpta = "";
                $linkxml = "";

                $util = Util::getInstance();
                if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {

                    // Cliente
                    $client = new Client();
                    $client->setTipoDoc($iddoc)
                        ->setNumDoc($result_cus['numdoc'])
                        ->setRznSocial($result_cus['name'])
                        ->setAddress((new Address())
                            ->setDireccion($result_cus['address']))
                        ->setEmail($result_cus['email'])
                        ->setTelephone($result_cus['phone']);
                    // Venta
                    if($disc_val > 0){
                       $desc = [
                            (new Charge())
                                ->setCodTipo('03') // Catalog. 53
                                ->setMontoBase($subtotal)
                                ->setFactor($disc_val/100)
                                ->setMonto($subtotal-$total)
                       ]; 
                    }else{
                        $desc = null;
                    }
                    $invoice = new Invoice();
                    $invoice
                        ->setUblVersion('2.1')
                        ->setTipoOperacion($idtipop)
                        ->setTipoDoc($result_comp['numtipo_comprobante'])
                        ->setSerie($result_serie['serie'])
                        ->setCorrelativo($invocieno_n)
                        ->setFechaEmision(new DateTime($bill_date))
                        ->setFormaPago(new FormaPagoContado())
                        ->setTipoMoneda($mon)
                        ->setCompany((new Company())
                            ->setRuc($loc['ruc'])
                            ->setNombreComercial($loc['ncomercial'])
                            ->setRazonSocial($loc['cname'])
                            ->setAddress((new Address())
                                ->setUbigueo($loc['ubigeo'])
                                ->setDistrito($loc['city'])
                                ->setProvincia($loc['region'])
                                ->setDepartamento($loc['country'])
                                ->setUrbanizacion('NONE')
                                ->setCodLocal($loc['codlocal'])
                                ->setDireccion($loc['address']))
                            ->setEmail($loc['email'])
                            ->setTelephone($loc['phone']))
                        ->setClient($client)
                        
                        ->setDescuentos($desc)
                        //->setMtoOperGravadas($queryafect)
                        ->setMtoOperExoneradas($subtotal)
                        //->setMtoIGV($total_tax)
                        ->setIcbper($icbper)
                        ->setTotalImpuestos($total_tax + $icbper)
                        ->setValorVenta($subtotal)
                        ->setSubTotal($subtotal)
                        ->setMtoImpVenta($total);

                    $detalles = [];
                    foreach ($productlist as $detail) {
                        $items = new SaleDetail();
                        $items->setCodProducto($detail['code'])
                            ->setUnidad($detail['unit'])
                            ->setCantidad($detail['qty'])
                            ->setDescripcion($detail['product'])
                            ->setMtoValorUnitario($detail['price'])
                            ->setMtoPrecioUnitario($detail['price'])
                            ->setCodProdSunat($detail['codsunat'])
                            ->setMtoValorVenta($detail['subtotal'])
                            ->setTipAfeIgv($detail['idtipoafectacion'])
                            ->setMtoBaseIgv($detail['subtotal'])
                            ->setPorcentajeIgv($detail['tax'])
                            ->setIgv($detail['totaltax'])
                            ->setIcbper(($detail['qty']) * ($detail['icbper'])) // (cantidad)*(factor ICBPER)
                            ->setFactorIcbper($loc['icbper'])
                            ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                        $detalles[] = $items;
                    }
                  
                    $leyenda = [];
                    $monto = new Legend();
                    $monto->setCode('1000')->setValue($totaletras);
                    $leyenda[] = $monto;
                    foreach(leyendas() as $value){
                        $leyendas = new Legend();
                        
                        $leyendas->setCode($value['id'])->setValue($value['valor']);                        
                        $leyenda[] = $leyendas; 
                    }
                    
                    $invoice->setDetails($detalles)->setLegends($leyenda);

                    // Envio a SUNAT.
                    $rutacert = '/../resources/' . $loc['certificado'];
                    $ruc = $loc['ruc'];
                    $usuario = $loc['usuariosol'];
                    $sol = $loc['clavesol'];
                    if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                        $modo = SunatEndpoints::FE_PRODUCCION;
                    } else {
                        $modo = SunatEndpoints::FE_BETA;
                        $ruc = '10770468341';

                        $usuario = 'MODDATOS';
                        $sol = 'moddatos';
                    }

                    $offline = $loc['online'];

                    if ($offline == 0) {
                        if ($idtipocomprobante == 'N') {
                            $sunat = 'Generado';
                        } else {
                            $sunat = 'Guardado';
                        }
                        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                        $xml = $see->getXmlSigned($invoice);
                        $util->writeXml($invoice, $xml);
                        $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                        $filename = $invoice->getName();
                        $this->db->set(array('sunat' => $sunat, 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $invocieno);
                        $this->db->update('jsoft_invoices');
                        $rpta = 'SE GENERÓ LA VENTA SATISFACTORIAMENTE';
                        $transok = true;
                    } else {
                        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                        $res = $see->send($invoice);
                        $util->writeXml($invoice, $see->getFactory()->getLastXml());
                        $xml = $see->getXmlSigned($invoice);

                        if ($res->isSuccess()) {
                            /** @var $res \Greenter\Model\Response\BillResult */
                            $cdr = $res->getCdrResponse();
                            $util->writeCdr($invoice, $res->getCdrZip());
                            $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                            $code = (int) $cdr->getCode();
                            if ($code === 0 || $code === 'CDR') {
                                $rpta = $cdr->getDescription();
                                $filename = $invoice->getName();
                                $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                                $this->db->where('id', $invocieno);
                                $this->db->update('jsoft_invoices');
                                $linkxml = base_url('/files/' . $filename . '.xml');
                                $transok = true;
                                //                        if (count($cdr->getNotes()) > 0) {
                                //                            echo 'OBSERVACIONES:' . PHP_EOL;
                                //                            // Corregir estas observaciones en siguientes emisiones.
                                //                            var_dump($cdr->getNotes());
                                //                        }
                            } else if ($code >= 2000 && $code <= 3999) {
                                $rpta = $cdr->getDescription();
                                $filename = $invoice->getName();
                                $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                                $this->db->where('id', $invocieno);
                                $this->db->update('jsoft_invoices');
                                $linkxml = base_url('/files/' . $filename . '.xml');
                                $transok = true;
                            } else {
                                $rpta = $cdr->getDescription();
                                $filename = $invoice->getName();
                                $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                                $this->db->where('id', $invocieno);
                                $this->db->update('jsoft_invoices');
                                $linkxml = base_url('/files/' . $filename . '.xml');
                                $transok = true;
                            }

                            $rutalogo = file_get_contents('userfiles/company/' . $loc['logo']);
                            $vendedor = $this->invocies->employee($emp);
                            $pdf = $util->getPdf($invoice, $hash, $rutalogo, 'Teléf.' . $loc['phone'], $pmethod, $vendedor);
                            $util->writeFile($invoice->getName() . '.pdf', $pdf);
                            $adjunto = file_get_contents('files/' . $invoice->getName() . '.pdf');
                            $nombre_pdf = $invoice->getName() . '.pdf';
                        } else {
                            $rpta = $util->getErrorResponse($res->getError());
                            $transok = false;
                            echo json_encode(array('status' => 'Error', 'message' => $rpta));
                        }
                    }
                }

                $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
                $link = base_url('/billing/view?id=' . $invocieno . '&token=' . $validtoken);
                $linkpdf = base_url('/pos_invoices/thermal_pdf?id=' . $invocieno . '&d=0');
                $linka4 = base_url('/pos_invoices/printinvoice?id=' . $invocieno);
                $linkguia = '';
                if($guiacheck == 'on'){
                    $linkguia = base_url('/guia_remision/printguia?id=' . $idguia);
                }
                
                $linkver = base_url('/pos_invoices/view?id=' . $invocieno);
                $linkcreate = base_url('/pos_invoices/create/');

                if ($transok) {
                    $this->load->library("Printer");
                    $printer = $this->printer->check($this->aauth->get_user()->loc);
                    $p_tid = 'thermal_p';
                    if (@$printer['val2'] == 'server') $p_tid = 'thermal_server';
                    $dataloading = '<i class="spinner-border spinner-border-sm" role="status"></i>';
                    echo json_encode(array('status' => 'Success', 'message' =>
                    "La venta se ha generado con éxito <br><button class='btn btn-blue btn-lg print' data-idin='$invocieno' id='print' type='button' data-loading-text='$dataloading'><span class='fa fa-ticket' role='status' aria-hidden='true'></span> Imprimir Ticket  </button> &nbsp; &nbsp;   <a id='$p_tid' data-ptid='$invocieno' data-url='" . @$printer['val3'] . "'  class='btn btn-info btn-lg white'><span class='fa fa-ticket' aria-hidden='true'></span> " . $this->lang->line('Thermal Printer') . "  </a> &nbsp; &nbsp;<a href='#' class='btn btn-reddit btn-lg print_image' id='print_image' data-inid='$invocieno'><span class='fa fa-window-restore' aria-hidden='true'></span></a> &nbsp; &nbsp; <a target='_blank' href='$linkguia' class='btn btn-blue btn-lg'><span class='fa fa-print' aria-hidden='true'></span> GUIA DE REM.  </a> &nbsp; &nbsp; <a target='_blank' href='$linka4' class='btn btn-blue btn-lg'><span class='fa fa-print' aria-hidden='true'></span> A4  </a> &nbsp; &nbsp; <a href='$linkver' class='btn btn-purple btn-lg'><span class='fa fa-eye' aria-hidden='true'></span> " . $this->lang->line('View') . "  </a> &nbsp; &nbsp; <a href='$link' class='btn btn-blue-grey btn-lg'><span class='fa fa-globe' aria-hidden='true'></span> " . $this->lang->line('Public View') . " </a> &nbsp;<a href='$linkcreate' class='btn btn-flickr btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span> " . $this->lang->line('Create') . "  </a>"));
                }
                $this->load->model('billing_model', 'billing');
                $tnote = '#' . $invocieno_n . '-' . $pmethod;
  
                switch ($pmethod) {
                    case 'Efectivo':
                        $r_amt1 = $pamnt;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Pase de Trajeta (POS)':
                        $r_amt1 = 0;
                        $r_amt2 = $pamnt;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Transferencia Bancaria':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = $pamnt;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'yape':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = $pamnt;
                        $r_amt5 = 0;
                        break;
                    case 'plin':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = $pamnt;
                        break;
                }

                if ($pamnt > 0)
                    $this->billing->paynow($invocieno, $pamnt, $tnote, $pmethod, $this->aauth->get_user()->loc, $bill_date, $account);
                $this->registerlog->update($this->aauth->get_user()->id, $r_amt1, $r_amt2, $r_amt3, $r_amt4, $r_amt5, 0, $c_amt);
                if ($promo_flag) {
                    $cqty = $result_c['available'] - 1;
                    if ($cqty > 0) {
                        $data = array('available' => $cqty);
                    } else {
                        $data = array('active' => 1, 'available' => $cqty);
                    }
                    $amount = $result_c['amount'];
                    $this->db->set($data);
                    $this->db->where('id', $result_c['id']);
                    $this->db->update('jsoft_promo');

                    if ($result_c['reflect'] > 0) {
                        $data = array(
                            'payerid' => 0,
                            'payer' => $this->lang->line('Coupon') . '-' . $result_c['code'],
                            'acid' => $result_c['reflect'],
                            'account' => 'Promo',
                            'date' => date('Y-m-d'),
                            'debit' => 0,
                            'credit' => $amount,
                            'type' => 'Income',
                            'cat' => $this->lang->line('Coupon'),
                            'method' => 'Transfer',
                            'eid' => $this->aauth->get_user()->id,
                            'note' => $this->lang->line('Coupon') . ' ' . $result_c['code'],
                            'loc' => $this->aauth->get_user()->loc
                        );
                        $this->db->set('lastbal', "lastbal+$amount", FALSE);
                        $this->db->where('id', $result_c['reflect']);
                        $this->db->update('jsoft_accounts');
                        $this->db->insert('jsoft_transactions', $data);
                    }
                }
            } else {
                echo json_encode(array('status' => 'Error', 'message' => "¡Entrada invalida!"));
                $transok = false;
            }


            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
        } elseif ($ptype == 2) {
            ///card section
            $discountFormat = $this->input->post('discountFormat');
            $pterms = $this->input->post('pterms');
            $currency = $this->input->post('mcurrency');
            $i = 0;
            if ($discountFormat == '0') {
                $discstatus = 0;
            } else {
                $discstatus = 1;
            }
            if ($customer_id == 0) {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
                exit;
            }
            $this->db->trans_start();
            //products
            $transok = true;
            //Invoice Data
            $bill_date = datefordatabase($invoicedate);
            $bill_due_date = datefordatabase($invocieduedate);

            $promo_flag = false;
            if ($coupon) {
                $this->db->select('*');
                $this->db->from('jsoft_promo');
                $this->db->where('code', $coupon);
                $query = $this->db->get();
                $result_c = $query->row_array();
                if ($result_c['active'] == 0 && $result_c['available'] > 0) {
                    $promo_flag = true;
                    $amount = $result_c['amount'];
                    $notes .= '-' . $this->input->post('i_coupon');
                    $total_discount += $amount;
                }
            }
            $data = array('idserie' => $idserie, 'tid' => $invocieno, 'tipocomprobante' => $idtipocomprobante, 'iddoc' => $iddoc, 'invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'total' => $total, 'notes' => $notes, 'status' => $status, 'idtipooperacion' => $idtipop, 'csd' => $customer_id, 'eid' => $emp, 'pamnt' => 0, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'multi' => $currency, 'i_class' => 1, 'loc' => $this->aauth->get_user()->loc, 'icbper' => $icbper);

            $invoice_true = false;
            if ($this->db->insert('jsoft_invoices', $data)) {
                $invoice_true = true;
                $tid = $invocieno;
                $invocieno2 = $invocieno;
                $invocieno = $this->db->insert_id();
                $pid = $this->input->post('pid');
                $productlist = array();
                $prodindex = 0;
                $itc = 0;
                $product_id = $this->input->post('pid');
                $product_name1 = $this->input->post('product_name', true);
                $product_qty = $this->input->post('product_qty');
                $product_price = $this->input->post('product_price');
                $product_tax = $this->input->post('product_tax');
                $product_discount = $this->input->post('product_discount');
                $product_subtotal = $this->input->post('product_subtotal');
                $ptotal_tax = $this->input->post('taxa');
                $ptotal_disc = $this->input->post('disca');
                $product_des = $this->input->post('product_description', true);
                $product_unit = $this->input->post('unit');
                $product_hsn = $this->input->post('hsn');
                $product_alert = $this->input->post('alert');
                $product_serial = $this->input->post('serial');
                foreach ($pid as $key => $value) {
                    $total_discount += numberClean(@$ptotal_disc[$key]);
                    $total_tax += numberClean($ptotal_tax[$key]);
                    $data = array(
                        'idserie' => $idserie,
                        'tid' => $invocieno,
                        'tipocomprobante' => $idtipocomprobante,
                        'idtipoprecio' => $tipo_precio[$key],
                        'idtipoafectacion' => $tipo_afectacion[$key],
                        'pid' => $product_id[$key],
                        'product' => $product_name1[$key],
                        'code' => $product_hsn[$key],
                        'qty' => numberClean($product_qty[$key]),
                        'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                        'tax' => numberClean($product_tax[$key]),
                        'discount' => numberClean($product_discount[$key]),
                        'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                        'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                        'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                        'product_des' => $product_des[$key],
                        'i_class' => 1,
                        'unit' => $product_unit[$key],
                        'serial' => $product_serial[$key],
                        'icbper' => $product_icbper[$key],
                        'codsunat' => $product_codsunat[$key],
                    );
                    $productlist[$prodindex] = $data;
                    $i++;
                    $prodindex++;
                    $amt = numberClean($product_qty[$key]);
                    if ($product_id[$key] > 0 and $this->common->zero_stock()) {

                        if ((numberClean($product_alert[$key]) - $amt) < 0 and $st_c == 0) {
                            echo json_encode(array('status' => 'Error', 'message' => 'Product - <strong>' . $product_name1[$key] . "</strong> - Low quantity. Available stock is  " . $product_alert[$key]));
                            $transok = false;
                            $st_c = 1;
                        } else {
                            $this->db->set('qty', "qty-$amt", FALSE);
                            $this->db->where('pid', $product_id[$key]);
                            $this->db->update('jsoft_products');
                        }
                    }
                    $itc += $amt;
                }
                if ($prodindex > 0) {
                    $this->db->insert_batch('jsoft_invoice_items', $productlist);
                    if (count($product_serial) > 0) {
                        $this->db->set('status', 1);
                        $this->db->where_in('serial', $product_serial);
                        $this->db->update('jsoft_product_serials');
                    }
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    "Elija un producto de la lista de productos. Vaya a la sección Administrador de artículos si no ha agregado los productos."));
                    $transok = false;
                }
                $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
                $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);
                if ($promo_flag) {
                    $cqty = $result_c['available'] - 1;
                    if ($cqty > 0) {
                        $data = array('available' => $cqty);
                    } else {
                        $data = array('active' => 1, 'available' => $cqty);
                    }

                    $this->db->set($data);
                    $this->db->where('id', $result_c['id']);
                    $this->db->update('jsoft_promo');

                    if ($result_c['reflect'] > 0) {
                        $data = array(
                            'payerid' => 0,
                            'payer' => $this->lang->line('Coupon') . '-' . $result_c['code'],
                            'acid' => $result_c['reflect'],
                            'account' => 'Promo',
                            'date' => date('Y-m-d'),
                            'debit' => 0,
                            'credit' => $amount,
                            'type' => 'Income',
                            'cat' => $this->lang->line('Coupon'),
                            'method' => 'Transfer',
                            'eid' => $this->aauth->get_user()->id,
                            'note' => $this->lang->line('Coupon') . ' ' . $this->lang->line('Delete') . ' ' . $this->lang->line('Qty') . '-' . $result_c['available'],
                            'loc' => $this->aauth->get_user()->loc
                        );
                        $this->db->set('lastbal', "lastbal+$amount", FALSE);
                        $this->db->where('id', $result_c['reflect']);
                        $this->db->update('jsoft_accounts');
                        $this->db->insert('jsoft_transactions', $data);
                    }
                }
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                "Invalid Entry!"));
                $transok = false;
            }
            //card process
            //card process
            if ($invoice_true) {
                $gateway = $this->input->post('gateway', true);
                setcookie("pos_set", base_url('pos_invoices/view?id=' . $invocieno), time() + 30 * 24 * 60 * 60, '/');
                $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
                $quckpay = base_url() . "billing/card?id=$invocieno&itype=inv&token=$validtoken&gid=$gateway";

                if ($transok)
                    echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('Invoice Success') . " <script type='text/javascript' >window.location.replace('$quckpay');</script><a target='_blank' href='$quckpay' class='btn btn-blue btn-lg'><span class='icon-printer' aria-hidden='true'></span> " . $this->lang->line('Pay') . "  </a> &nbsp; &nbsp;    <a target='_blank' href='thermal_pdf?id=$invocieno' class='btn btn-blue btn-lg'><span class='icon-printer' aria-hidden='true'></span> " . $this->lang->line('Print') . "  </a> &nbsp; &nbsp;    &nbsp; &nbsp; <a href='view?id=$invocieno' class='btn btn-purple btn-lg'><span class='icon-file-text2' aria-hidden='true'></span> " . $this->lang->line('View') . "  </a> &nbsp; &nbsp; <a href='$link' class='btn btn-blue-grey btn-lg'><span class='icon-earth' aria-hidden='true'></span> " . $this->lang->line('Public View') . " </a> <a href='create' class='btn btn-amber btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span> " . $this->lang->line('Create') . "  </a>"));
            }

            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
        } else {
            //draft
            $p_amount = 0;
            $pmethod = $this->input->post('p_method', true);

            $c_amt = @$p_amount - $total;
            if ($c_amt == 0.00) {
                $status = 'Paid';
                $pamnt = $total;
            } elseif ($c_amt < 0.00) {
                $status = 'Partial';
                $pamnt = $p_amount;
            } else {
                $status = 'Paid';
                $pamnt = $total;
            }

            $i = 0;
            if ($discountFormat == '0') {
                $discstatus = 0;
            } else {
                $discstatus = 1;
            }

            if ($customer_id == 0) {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
                exit;
            }
            $this->db->trans_start();
            //products
            $transok = true;
            //Invoice Data
            $bill_date = datefordatabase($invoicedate);
            $bill_due_date = datefordatabase($invocieduedate);
            $promo_flag = false;
            $data = array('tid' => $invocieno, 'invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'total' => $total, 'pmethod' => $pmethod, 'notes' => $notes, 'status' => $status, 'csd' => $customer_id, 'eid' => $this->aauth->get_user()->id, 'pamnt' => 0, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'multi' => $currency, 'i_class' => 1, 'loc' => $this->aauth->get_user()->loc);
            if ($this->db->insert('jsoft_draft', $data)) {
                $invocieno2 = $invocieno;
                $invocieno = $this->db->insert_id();
                $pid = $this->input->post('pid');
                $productlist = array();
                $prodindex = 0;
                $itc = 0;

                $product_id = $this->input->post('pid');
                $product_name1 = $this->input->post('product_name', true);
                $product_qty = $this->input->post('product_qty');
                $product_price = $this->input->post('product_price');
                $product_tax = $this->input->post('product_tax');
                $product_discount = $this->input->post('product_discount');
                $product_subtotal = $this->input->post('product_subtotal');
                $ptotal_tax = $this->input->post('taxa');
                $ptotal_disc = $this->input->post('disca');
                $product_des = $this->input->post('product_description', true);
                $product_unit = $this->input->post('unit');
                $product_hsn = $this->input->post('hsn');


                foreach ($pid as $key => $value) {
                    $total_discount += numberClean(@$ptotal_disc[$key]);
                    $total_tax += numberClean($ptotal_tax[$key]);

                    $data = array(
                        'tid' => $invocieno,
                        'pid' => $product_id[$key],
                        'product' => $product_name1[$key],
                        'code' => $product_hsn[$key],
                        'qty' => numberClean($product_qty[$key]),
                        'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                        'tax' => numberClean($product_tax[$key]),
                        'discount' => numberClean($product_discount[$key]),
                        'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                        'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                        'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                        'product_des' => $product_des[$key],
                        'i_class' => 1,
                        'unit' => $product_unit[$key]
                    );

                    $flag = true;
                    $productlist[$prodindex] = $data;
                    $i++;
                    $prodindex++;
                    $amt = numberClean($product_qty[$key]);
                    $itc += $amt;
                }

                if ($prodindex > 0) {
                    $this->db->insert_batch('jsoft_draft_items', $productlist);
                    $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                    $this->db->where('id', $invocieno);
                    $this->db->update('jsoft_draft');
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    "Elija un producto de la lista de productos. Vaya a la sección Administrador de artículos si no ha agregado los productos."));
                    $transok = false;
                }

                $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
                $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);
                if ($transok)
                    echo json_encode(array('status' => 'Success', 'message' =>
                    $this->lang->line('Draft Success') . " <a href='create' class='btn btn-info btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span> " . $this->lang->line('New') . "  </a>"));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                "¡Entrada invalida!"));
                $transok = false;
            }
            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
        }
        if ($transok) {
            $this->db->from('univarsal_api');
            $this->db->where('univarsal_api.id', 56);
            $query = $this->db->get();
            $auto = $query->row_array();
            if ($auto['key1'] == 1) {
                $this->db->select('name,email');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $customer = $query->row_array();

                //GENERAR PDF PARA ENVIAR POR CORREO
                $this->load->helper('convertir');

                $data['id'] = $invocieno;
                $data['round_off'] = $this->custom->api_config(4);
                $data['invoice'] = $this->invocies->invoice_details($invocieno, $this->limited);

                if ($data['invoice']['id'])
                    $data['products'] = $this->invocies->invoice_products($invocieno);
                if ($data['invoice']['id'])
                    $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
                if (CUSTOM)
                    $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1, 1);
                if ($data['invoice']['i_class'] == 1) {
                    $pref = prefix(7);
                } else {
                    $pref = $this->config->item('prefix');
                }
                if ($data['invoice']['tipocomprobante'] == 'B') {
                    $data['tipocomprobante'] = 'BOLETA <br> ELECTŔONICA';
                    $num = '03';
                    //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
                } else {
                    $data['tipocomprobante'] = 'FACTURA <br> ELECTŔONICA';
                    $num = '01';
                    //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
                }


                $data['qr'] = $loc['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';
                $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
                $data['leyenda'] = $leyenda;
                ini_set('memory_limit', '64M');
                if ($data['invoice']['taxstatus'] == 'cgst' || $data['invoice']['taxstatus'] == 'igst') {
                    $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
                } else {
                    $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
                }
                //PDF Rendering
                $this->load->library('pdf');
                if (INVV == 1) {
                    $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
                    $pdf = $this->pdf->load_split(array('margin_top' => 40));
                    $pdf->SetHTMLHeader($header);
                }
                if (INVV == 2) {
                    $pdf = $this->pdf->load_split(array('margin_top' => 5));
                }
                $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
                $pdf->WriteHTML($html);

                $attachment = $pdf->Output('', 'S');

                $this->load->model('communication_model');
                $invoice_mail = $this->send_invoice_auto($invocieno, $serie . '-' . $invocieno2, $bill_date, $total, $currency);
                $attachmenttrue = true;
                //$attachment = $adjunto;
                $nombre = $nombre_pdf;
                $this->communication_model->send_corn_email($customer['email'], $customer['name'], $invoice_mail['subject'], $invoice_mail['message'], $nombre, $attachmenttrue, $attachment);
            }

            if ($auto['key2'] == 1) {
                $this->db->select('name,phone');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $customer = $query->row_array();

                $this->load->model('plugins_model', 'plugins');
                $invoice_sms = $this->send_sms_auto($invocieno, $invocieno2, $bill_date, $total, $currency);

                $mobile = $customer['phone'];
                $text_message = $invoice_sms['message'];
                $this->load->model('sms_model', 'sms');
                $this->sms->send_sms($mobile, $text_message, false);
            }
        }
        //profit calculation
        $t_profit = 0;
        $this->db->select('jsoft_invoice_items.pid, jsoft_invoice_items.price, jsoft_invoice_items.qty, jsoft_products.fproduct_price');
        $this->db->from('jsoft_invoice_items');
        $this->db->join('jsoft_products', 'jsoft_products.pid = jsoft_invoice_items.pid', 'left');
        $this->db->where('jsoft_invoice_items.tid', $invocieno);
        $query = $this->db->get();
        $pids = $query->result_array();
        foreach ($pids as $profit) {
            $t_cost = $profit['fproduct_price'] * $profit['qty'];
            $s_cost = $profit['price'] * $profit['qty'];

            $t_profit += $s_cost - $t_cost;
        }
        $data = array('type' => 9, 'rid' => $invocieno, 'col1' => $t_profit, 'd_date' => $bill_date);

        $this->db->insert('jsoft_metadata', $data);

        if ($print_now) {
            $print = $this->thermal_print($invocieno, false, false);
        }
    }


    public function generar_resumen()
    {
        if ($this->input->post('start_date')) // if datatable send POST for search
        {
            $originalDate = $this->input->post('start_date');
            $newDate = date("Y-m-d", strtotime($originalDate));
        }

        $fecha = $newDate;
        $invoices = $this->invocies->facturas_resumen($fecha);

        $loc = location($this->aauth->get_user()->loc);
        $correlativo = $this->invocies->correlativoresumen();
        $util = Util::getInstance();
        // Summary
        $detalles = [];
        foreach ($invoices as $detalle) {
            $detiail = new SummaryDetail();
            $detiail->setTipoDoc($detalle['numtipo_comprobante'])
                ->setSerieNro($detalle['serie'] . '-' . $detalle['tid'])
                ->setEstado('3')
                ->setClienteTipo($detalle['iddoc'])
                ->setClienteNro($detalle['numdoc'])
                ->setTotal($detalle['total'])
                ->setMtoOperGravadas(0)
                ->setMtoOperInafectas(0)
                ->setMtoOperExoneradas($detalle['subtotal'])
                ->setMtoOperExportacion(0)
                ->setMtoOtrosCargos(0)
                ->setMtoIGV(0);
            $detalles[] = $detiail;
        }

        $sum = new Summary();
        // Fecha Generacion menor que Fecha Resumen
        $sum->setFecGeneracion(new DateTime($fecha))
            ->setFecResumen(new DateTime())
            ->setCorrelativo($correlativo)
            ->setCompany((new Company())
                ->setRuc($loc['ruc'])
                ->setNombreComercial($loc['ncomercial'])
                ->setRazonSocial($loc['cname'])
                ->setAddress((new Address())
                    ->setUbigueo($loc['ubigeo'])
                    ->setDistrito($loc['city'])
                    ->setProvincia($loc['region'])
                    ->setDepartamento($loc['country'])
                    ->setUrbanizacion('NONE')
                    ->setCodLocal($loc['codlocal'])
                    ->setDireccion($loc['address']))
                ->setEmail($loc['email'])
                ->setTelephone($loc['phone']))
            ->setDetails($detalles);

        // Envio a SUNAT.
        $rutacert = '/../resources/' . $loc['certificado'];
        $ruc = $loc['ruc'];
        $usuario = $loc['usuariosol'];
        $sol = $loc['clavesol'];
        if ($loc['modo'] == '1' || $loc['modo'] == 1) {
            $modo = SunatEndpoints::FE_PRODUCCION;
        } else {
            $modo = SunatEndpoints::FE_BETA;
            $ruc = '20123456789';

            $usuario = 'MODDATOS';
            $sol = 'moddatos';
        }

        $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
        $res = $see->send($sum);
        $util->writeXml($sum, $see->getFactory()->getLastXml());

        if (!$res->isSuccess()) {
            $rpta = $util->getErrorResponse($res->getError());
            $transok = false;
            echo json_encode(array('status' => 'Error', 'message' => $rpta));
            return;
        }

        /** @var SummaryResult $res */
        $ticket = $res->getTicket();



        $res2 = $see->getStatus($ticket);

        $filename = $sum->getName();
        if (!$res2->isSuccess()) {
            $rpta = $util->getErrorResponse($res2->getError());
            $transok = true;
            $this->db->set(array('estadosunat' => 'Pendiente', 'respuestasunat' => $rpta, 'ticket' => $ticket, 'nomarchivo' => $filename));
            $this->db->where('id', $correlativo);
            $this->db->update('jsoft_resumen_diario');
            $this->db->trans_complete();
            echo json_encode(array('status' => 'Error', 'message' => $rpta));
            return;
        } else {
            $cdr = $res2->getCdrResponse();

            $util->writeCdr($sum, $res2->getCdrZip());
            $rpta = $cdr->getDescription();
            $transok = true;
            $this->db->set(array('estadosunat' => 'Aceptado', 'respuestasunat' => $rpta, 'ticket' => $ticket, 'nomarchivo' => $filename));
            $this->db->where('id', $correlativo);
            $this->db->update('jsoft_resumen_diario');

            //$this->db->set(array('sunat' => 'Anulado'));
            //$this->db->where('id', $id);
            //$this->db->update('jsoft_invoices');

            //$this->db->select('pid,qty');
            //$this->db->from('jsoft_invoice_items');
            //$this->db->where('tid', $id);
            //$query = $this->db->get();
            //$prevresult = $query->result_array();
            //foreach ($prevresult as $prd) {
            //  $amt = $prd['qty'];
            //$this->db->set('qty', "qty+$amt", FALSE);
            //$this->db->where('pid', $prd['pid']);
            //$this->db->update('jsoft_products');
            //}
        }

        //if (!$res->isSuccess()) {
        //  $rpta = $util->getErrorResponse($res->getError());

        //echo json_encode(array('status' => 'Error', 'message' => $rpta));
        //return;
        //}

        // /** @var SummaryResult $res */
        //$ticket = $res->getTicket();


        //$res = $see->getStatus($ticket);
        //print_r($res);
        //if (!$res->isSuccess()) {
        //    echo $util->getErrorResponse($res->getError());
        //    return;
        //}

        //$cdr = $res->getCdrResponse();
        //$util->writeCdr($sum, $res->getCdrZip());

        //echo $cdr->getDescription();
    }

    //crear contingencia
    public function nueva_contingencia($param = "")
    {

        if (!$this->registerlog->check($this->aauth->get_user()->id)) {
            redirect('register/create');
        }
        $this->load->model('customers_model', 'customers');
        $this->load->model('categories_model');
        $this->load->model('plugins_model', 'plugins');
        $this->load->library("Common");
        $data['custom_fields_c'] = $this->custom->add_fields(1);
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $data['gateway'] = $this->invocies->gateway_list('Yes');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['enable_card'] = $this->plugins->universal_api(54);
        $data['customergrouplist'] = $this->customers->group_list();
        $data['tipodoc'] = $this->invocies->listartipodoc();
        $data['tipop'] = $this->invocies->listartipooperacion();
        $data['draft_list'] = $this->invocies->drafts();
        $data['units'] = $this->products->units();
        $data['tallamedida'] = $this->products->listar_talla_medida();
        $data['custom_fields'] = $this->custom->add_fields(4);
        $data['warehouse'] = $this->invocies->warehouses();
        $data['terms'] = $this->invocies->billingterms();

        $data['tpcomp'] = $param;
        $data['currency'] = $this->invocies->currencies();
        if ($param == 'F') {
            $head['title'] = "Nueva Factura de Contingencia";
        } else {
            $head['title'] = "Nueva Boleta de Contingencia";
        }
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['cat'] = $this->categories_model->category_list();
        $data['taxdetails'] = $this->common->taxdetail();
        $data['acc_list'] = $this->invocies->accountslist();

        $data['emp'] = $this->plugins->universal_api(69);
        if ($data['emp']['key1']) {
            $this->load->model('employee_model', 'employee');
            $data['employee'] = $this->employee->list_employee();
        }

        if ($this->input->get('v2') or POSV == 2) {
            $head['s_mode'] = false;
            $this->load->view('fixed/header-pos', $head);
            $this->load->view('pos/contingencia', $data);
        } else {
            $head['s_mode'] = true;
            $this->load->view('fixed/header-pos', $head);
            $this->load->view('pos/contingencia', $data);
        }
        $this->load->view('fixed/footer-pos');
    }

    //COMUNICAR BAJA
    public function comunicar_baja()
    {
        if ($this->aauth->premission(11)) {
            $id = $this->input->post('deleteid');
            $motivo = $this->input->post('motivo');


            $this->db->select('*');
            $this->db->from('jsoft_comunicacion_baja');
            $this->db->where('idinvoice', $id);
            $q = $this->db->get();
            $r = $q->row_array();

            if (isset($r['idinvoice'])) {
                if ($r['idinvoice'] === $id) {
                    $transok = false;
                    echo json_encode(array('status' => 'Error', 'message' => '¡Este comprobante ya se comunicó de baja anteriormente!'));
                    return;
                }
            }



            $this->db->select('*');
            $this->db->from('jsoft_invoices i');
            $this->db->join('serie s', 'i.idserie = s.id');
            $this->db->where('i.id', $id);
            $query = $this->db->get();
            $result_comp = $query->row_array();

            $fechaemision = date("Y-m-d H:i:s");
            $this->db->trans_start();
            $this->load->library("Common");
            $transok = true;

            $data = array('idinvoice' => $id, 'fechaemision' => $fechaemision, 'motivo' => $motivo);

            if ($this->db->insert('jsoft_comunicacion_baja', $data)) {
                $idcomunicacion = $this->db->insert_id();



                $rpta = "";
                $loc = location($this->aauth->get_user()->loc);

                if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
                    $util = Util::getInstance();

                    $detail = new VoidedDetail();
                    $detail->setTipoDoc('01')
                        ->setSerie($result_comp['serie'])
                        ->setCorrelativo($result_comp['tid'])
                        ->setDesMotivoBaja($motivo);

                    $voided = new Voided();
                    $voided->setCorrelativo($idcomunicacion)
                        ->setFecGeneracion(new \DateTime($result_comp['invoicedate']))
                        ->setFecComunicacion(new \DateTime())
                        ->setCompany((new Company())
                            ->setRuc($loc['ruc'])
                            ->setNombreComercial($loc['ncomercial'])
                            ->setRazonSocial($loc['cname'])
                            ->setAddress((new Address())
                                ->setUbigueo($loc['ubigeo'])
                                ->setDistrito($loc['city'])
                                ->setProvincia($loc['region'])
                                ->setDepartamento($loc['country'])
                                ->setUrbanizacion('NONE')
                                ->setCodLocal($loc['codlocal'])
                                ->setDireccion($loc['address']))
                            ->setEmail($loc['email'])
                            ->setTelephone($loc['phone']))
                        ->setDetails([$detail]);

                    // Envio a SUNAT.
                    $rutacert = '/../resources/' . $loc['certificado'];
                    $ruc = $loc['ruc'];
                    $usuario = $loc['usuariosol'];
                    $sol = $loc['clavesol'];
                    if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                        $modo = SunatEndpoints::FE_PRODUCCION;
                    } else {
                        $modo = SunatEndpoints::FE_BETA;
                        $ruc = '20123456789';

                        $usuario = 'MODDATOS';
                        $sol = 'moddatos';
                    }

                    $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                    $res = $see->send($voided);
                    $util->writeXml($voided, $see->getFactory()->getLastXml());
                    $xml = $see->getXmlSigned($voided);

                    if (!$res->isSuccess()) {
                        $rpta = $util->getErrorResponse($res->getError());
                        $transok = false;
                        echo json_encode(array('status' => 'Error', 'message' => $rpta));
                        return;
                    }

                    /** @var SummaryResult $res */
                    $ticket = $res->getTicket();

                    //print_r($ticket);

                    $res2 = $see->getStatus($ticket);
                    $filename = $voided->getName();
                    if (!$res2->isSuccess()) {
                        $rpta = $util->getErrorResponse($res2->getError());
                        $transok = true;
                        $this->db->set(array('estadosunat' => 'Pendiente', 'respuestasunat' => $rpta, 'ticket' => $ticket, 'nomarchivo' => $filename));
                        $this->db->where('idcom', $idcomunicacion);
                        $this->db->update('jsoft_comunicacion_baja');

                        $this->db->set(array('sunat' => 'Anulado'));
                        $this->db->where('id', $id);
                        $this->db->update('jsoft_invoices');

                        $this->db->select('pid,qty');
                        $this->db->from('jsoft_invoice_items');
                        $this->db->where('tid', $id);
                        $query = $this->db->get();
                        $prevresult = $query->result_array();
                        foreach ($prevresult as $prd) {
                            $amt = $prd['qty'];
                            $this->db->set('qty', "qty+$amt", FALSE);
                            $this->db->where('pid', $prd['pid']);
                            $this->db->update('jsoft_products');
                        }
                        $this->db->trans_complete();
                        echo json_encode(array('status' => 'Error', 'message' => $rpta));
                        return;
                    } else {
                        $cdr = $res2->getCdrResponse();

                        $util->writeCdr($voided, $res2->getCdrZip());
                        $rpta = $cdr->getDescription();
                        $transok = true;
                        $this->db->set(array('estadosunat' => 'Aceptado', 'respuestasunat' => $rpta, 'ticket' => $ticket, 'nomarchivo' => $filename));
                        $this->db->where('idcom', $idcomunicacion);
                        $this->db->update('jsoft_comunicacion_baja');

                        $this->db->set(array('sunat' => 'Anulado'));
                        $this->db->where('id', $id);
                        $this->db->update('jsoft_invoices');

                        $this->db->select('pid,qty');
                        $this->db->from('jsoft_invoice_items');
                        $this->db->where('tid', $id);
                        $query = $this->db->get();
                        $prevresult = $query->result_array();
                        foreach ($prevresult as $prd) {
                            $amt = $prd['qty'];
                            $this->db->set('qty', "qty+$amt", FALSE);
                            $this->db->where('pid', $prd['pid']);
                            $this->db->update('jsoft_products');
                        }

                        $this->db->trans_complete();
                    }





                    if ($transok) {
                        echo json_encode(array('status' => 'Success', 'message' => " <center>$rpta</center> <br><center><span class=''>$ticket</span></center>"));
                    }
                } else {
                    $transok = false;
                    echo json_encode(array('status' => 'Error', 'message' => '¡Ocurrió un error en la transacción!'));
                }
            }
            if ($transok) {
                $this->db->set('status', 'canceled');
                $this->db->where('id', $id);
                $this->db->update('jsoft_invoices');

                $this->db->select('credit,debit,acid');
                $this->db->from('jsoft_transactions');
                $this->db->where('tid', $id);
                $query1 = $this->db->get();
                $revresult = $query1->result_array();
                foreach ($revresult as $trans) {
                    $amt = $trans['credit'] - $trans['debit'];
                    $this->db->set('lastbal', "lastbal-$amt", FALSE);
                    $this->db->where('id', $trans['acid']);
                    $this->db->update('jsoft_accounts');
                }


                $this->db->delete('jsoft_transactions', array('tid' => $id));
                $data = array('type' => 9, 'rid' => $id);
                $this->db->delete('jsoft_metadata', $data);
            }

            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
            //            
        } else {
            echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('ERROR')));
        }
    }

    //CONTINGENCIA
    public function enviar_contingencia()
    {
        $this->load->helper('convertir');

        $ptype = $this->input->post('type');
        $coupon = $this->input->post('coupon');
        $notes = $this->input->post('notes', true);
        $coupon_amount = 0;
        $coupon_n = '';
        $customer_id = $this->input->post('customer_id');
        $iddoc = $this->input->post('idtipodoc');
        $idserie = $this->input->post('serie');

        $idtipocomprobante = $this->input->post('tpcomp');
        $idtipop = $this->input->post('tipop');

        $serie = '';
        $adjunto = '';
        $nombre_pdf = '';

        $invocieno = $this->input->post('invocieno');
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $tax = $this->input->post('tax_handle');
        $icbper = $this->input->post('icbpertotal');

        $total_tax = 0;

        $discountFormat = $this->input->post('discountFormat');
        $pterms = $this->input->post('pterms');
        $currency = $this->input->post('mcurrency');
        $total_discount = rev_amountExchange_s($this->input->post('after_disc'), $currency, $this->aauth->get_user()->loc);
        $disc_val = numberClean($this->input->post('disc_val'));
        $ship_taxtype = $this->input->post('ship_taxtype');
        $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
        $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
        $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
        if ($ship_taxtype == 'incl')
            @$shipping = $shipping - $shipping_tax;
        $refer = $this->input->post('refer', true);
        $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
        $st_c = 0;
        $print_now = $this->input->post('printnow');
        $account = $this->input->post('account');
        $this->load->model('plugins_model', 'plugins');
        $empl_e = $this->plugins->universal_api(69);
        if ($empl_e['key1']) {
            $emp = $this->input->post('employee');
        } else {
            $emp = $this->aauth->get_user()->id;
        }
        if ($ptype == 4) {
            $p_amount = rev_amountExchange_s($this->input->post('p_amount'), $currency, $this->aauth->get_user()->loc);
            $pmethod = $this->input->post('p_method');

            $c_amt = $p_amount - $total;
            if ($c_amt == 0.00) {
                $status = 'Paid';
                $pamnt = $total;
            } elseif ($c_amt < 0.00) {
                $status = 'Partial';
                if ($p_amount == 0.00)
                    $status = 'Due';
                $pamnt = $p_amount;
                $c_amt = 0;
            } else {
                $status = 'Paid';
                $pamnt = $total;
                $roundoff = $this->custom->api_config(4);
                if ($roundoff['other'])
                    $pamnt = round($total, $roundoff['active'], constant($roundoff['other']));
            }
            $i = 0;
            if ($discountFormat == '0') {
                $discstatus = 0;
            } else {
                $discstatus = 1;
            }
            if ($customer_id == 0) {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
                exit;
            } else {
                $this->db->select('*');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $result_cus = $query->row_array();
            }
            $this->db->trans_start();
            //products
            $transok = true;
            $this->load->library("Common");
            //Invoice Data
            $bill_date = date("Y-m-d H:i:s");
            $bill_due_date = datefordatabase($invocieduedate);
            $promo_flag = false;
            if ($coupon) {
                $this->db->select('*');
                $this->db->from('jsoft_promo');
                $this->db->where('code', $coupon);
                $query = $this->db->get();
                $result_c = $query->row_array();
                if ($result_c['active'] == 0 && $result_c['available'] > 0) {
                    $promo_flag = true;
                    $amount = $result_c['amount'];
                    $notes .= '-' . $this->input->post('i_coupon');
                    $total_discount += $amount;
                }
            }
            $data = array('idserie' => $idserie, 'tid' => $invocieno, 'tipocomprobante' => $idtipocomprobante, 'iddoc' => $iddoc, 'invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'discount_rate' => $disc_val, 'total' => $total, 'pmethod' => $pmethod, 'notes' => $notes, 'status' => $status, 'idtipooperacion' => $idtipop, 'csd' => $customer_id, 'eid' => $emp, 'pamnt' => 0, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'multi' => $currency, 'i_class' => 1, 'loc' => $this->aauth->get_user()->loc, 'icbper' => $icbper);

            if ($this->db->insert('jsoft_contingencia', $data)) {

                $invocieno_n = $invocieno;
                $invocieno2 = $invocieno;
                $invocieno = $this->db->insert_id();

                $pid = $this->input->post('pid');
                $productlist = array();
                $prodindex = 0;
                $itc = 0;
                $product_id = $this->input->post('pid');
                $product_name1 = $this->input->post('product_name', true);
                $product_qty = $this->input->post('product_qty');
                $product_price = $this->input->post('product_price');

                $tipo_precio = $this->input->post('tipo_precio');

                $tipo_afectacion = $this->input->post('tipo_afectacion');

                $product_tax = $this->input->post('product_tax');
                $product_discount = $this->input->post('product_discount');
                $product_subtotal = $this->input->post('product_subtotal');
                $ptotal_tax = $this->input->post('taxa');
                $ptotal_disc = $this->input->post('disca');
                $product_des = $this->input->post('product_description', true);
                $product_unit = $this->input->post('unit');
                $product_hsn = $this->input->post('hsn', true);
                $product_alert = $this->input->post('alert');
                $product_serial = $this->input->post('serial');
                $product_icbper = $this->input->post('product_icbper');
                $product_codsunat = $this->input->post('codsunat');

                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('*');
                        $this->db->from('jsoft_products');
                        $this->db->where('pid', $product_id[$key]);
                        $queryp = $this->db->get();
                        $result_p = $queryp->row_array();

                        $total_discount += numberClean(@$ptotal_disc[$key]);
                        $total_tax += numberClean($ptotal_tax[$key]);

                        $data = array(
                            'idserie' => $idserie,
                            'tid' => $invocieno,
                            'tipocomprobante' => $idtipocomprobante,
                            'idtipoprecio' => $tipo_precio[$key],
                            'idtipoafectacion' => $tipo_afectacion[$key],
                            'pid' => $product_id[$key],
                            'product' => $product_name1[$key],
                            'code' => $product_hsn[$key],
                            'qty' => numberClean($product_qty[$key]),
                            'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                            'tax' => numberClean($product_tax[$key]),
                            'discount' => numberClean($product_discount[$key]),
                            'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                            'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                            'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                            'product_des' => $product_des[$key],
                            'i_class' => 1,
                            'unit' => $product_unit[$key],
                            'serial' => $product_serial[$key],
                            'icbper' => $product_icbper[$key],
                            'codsunat' => $product_codsunat[$key],
                        );
                        $flag = true;
                        $productlist[$prodindex] = $data;
                        $i++;
                        $prodindex++;

                        $amt = numberClean($product_qty[$key]);

                        if ($result_p['tipo'] == 'P') {
                            $codley = '2001';
                            $leyenda = 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';

                            if ($product_id[$key] > 0 and $this->common->zero_stock()) {

                                if ((numberClean($product_alert[$key]) - $amt) < 0 and $st_c == 0) {
                                    echo json_encode(array('status' => 'Error', 'message' => 'Producto - <strong>' . $product_name1[$key] . "</strong> - Cantidad baja. El stock disponible es  " . $product_alert[$key]));
                                    $transok = false;
                                    $st_c = 1;
                                } else {
                                    $this->db->set('qty', "qty-$amt", FALSE);
                                    $this->db->where('pid', $product_id[$key]);
                                    $this->db->update('jsoft_products');
                                }
                            }
                        } else {
                            $codley = '2002';
                            $leyenda = 'SERVICIOS PRESTADOS EN LA AMAZONÍA  REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';
                        }
                        $itc += $amt;
                    }
                }
                if ($prodindex > 0) {
                    $this->db->insert_batch('jsoft_contingencia_items', $productlist);
                    $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                    $this->db->where('id', $invocieno);
                    $this->db->update('jsoft_contingencia');

                    if (count($product_serial) > 0) {
                        $this->db->set('status', 1);
                        $this->db->where_in('serial', $product_serial);
                        $this->db->update('jsoft_product_serials');
                    }
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    "Elija un producto de la lista. Vaya a la sección Administrador de artículos si no ha agregado los productos."));
                    $transok = false;
                }

                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                        $this->db->from('jsoft_contingencia_items');
                        $this->db->where('idtipoafectacion', 10);
                        $this->db->where('tid', $invocieno);
                        $queryafect = $this->db->get()->result()[0]->subtotal;
                    }
                }

                if (is_array($pid)) {
                    foreach ($pid as $key => $value) {

                        $this->db->select('pid,COALESCE(SUM(subtotal), 0) as subtotal');
                        $this->db->from('jsoft_contingencia_items');
                        $this->db->where('idtipoafectacion', 20);
                        $this->db->where('tid', $invocieno);
                        $queryafec = $this->db->get()->result()[0]->subtotal;
                    }
                }

                $this->db->select('*');
                $this->db->from('tipocomprobante');
                $this->db->where('idtipocomprobante', $idtipocomprobante);
                $query = $this->db->get();
                $result_comp = $query->row_array();

                $this->db->select('*');
                $this->db->from('serie');
                $this->db->where('id', $idserie);
                $queryserie = $this->db->get();
                $result_serie = $queryserie->row_array();

                $serie = $result_serie['serie'];

                $loc = location($this->aauth->get_user()->loc);

                if ($loc['currency'] == 'S/') {
                    $mon = 'PEN';
                } else {
                    $mon = 'USD';
                }
                $totaletras = num_to_letras($total, $mon);
                $rpta = "";
                $linkxml = "";

                if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
                    $util = Util::getInstance();
                    // Cliente
                    $client = new Client();
                    $client->setTipoDoc($iddoc)
                        ->setNumDoc($result_cus['numdoc'])
                        ->setRznSocial($result_cus['name'])
                        ->setAddress((new Address())
                            ->setDireccion($result_cus['address']))
                        ->setEmail($result_cus['email'])
                        ->setTelephone($result_cus['phone']);
                    // Venta
                    $invoice = new Invoice();
                    $invoice
                        ->setUblVersion('2.1')
                        ->setTipoOperacion($idtipop)
                        ->setTipoDoc($result_comp['numtipo_comprobante'])
                        ->setSerie($idserie)
                        ->setCorrelativo($invocieno_n)
                        ->setFechaEmision(new DateTime($bill_date))
                        ->setTipoMoneda($mon)
                        ->setCompany((new Company())
                            ->setRuc($loc['ruc'])
                            ->setNombreComercial($loc['ncomercial'])
                            ->setRazonSocial($loc['cname'])
                            ->setAddress((new Address())
                                ->setUbigueo($loc['ubigeo'])
                                ->setDistrito($loc['city'])
                                ->setProvincia($loc['region'])
                                ->setDepartamento($loc['country'])
                                ->setUrbanizacion('NONE')
                                ->setCodLocal($loc['codlocal'])
                                ->setDireccion($loc['address']))
                            ->setEmail($loc['email'])
                            ->setTelephone($loc['phone']))
                        ->setClient($client)
                        ->setMtoOperGravadas($queryafect)
                        ->setMtoOperExoneradas($queryafec)
                        ->setMtoIGV($total_tax)
                        ->setIcbper($icbper)
                        ->setTotalImpuestos($total_tax + $icbper)
                        ->setValorVenta($subtotal)
                        ->setSubTotal($subtotal)
                        ->setMtoImpVenta($total);

                    $detalles = [];
                    foreach ($productlist as $detail) {
                        $items = new SaleDetail();
                        $items->setCodProducto($detail['code'])
                            ->setUnidad($detail['unit'])
                            ->setCantidad($detail['qty'])
                            ->setDescripcion($detail['product'])
                            ->setMtoValorUnitario($detail['price'])
                            ->setMtoPrecioUnitario($detail['price'])
                            ->setCodProdSunat($detail['codsunat'])
                            ->setMtoValorVenta($detail['subtotal'])
                            ->setTipAfeIgv($detail['idtipoafectacion'])
                            ->setMtoBaseIgv($detail['subtotal'])
                            ->setPorcentajeIgv($detail['tax'])
                            ->setIgv($detail['totaltax'])
                            ->setIcbper(($detail['qty']) * ($detail['icbper'])) // (cantidad)*(factor ICBPER)
                            ->setFactorIcbper($loc['icbper'])
                            ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                        $detalles[] = $items;
                    }

                    $leyenda = [];
                    $monto = new Legend();
                    $monto->setCode('1000')->setValue($totaletras);
                    $leyenda[] = $monto;
                    foreach(leyendas() as $value){
                        $leyendas = new Legend();
                        
                        $leyendas->setCode($value['id'])->setValue($value['valor']);                        
                        $leyenda[] = $leyendas; 
                    }
                    
                    $invoice->setDetails($detalles)->setLegends($leyenda);

                    // Envio a SUNAT.
                    $rutacert = '/../resources/' . $loc['certificado'];
                    $ruc = $loc['ruc'];
                    $usuario = $loc['usuariosol'];
                    $sol = $loc['clavesol'];
                    if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                        $modo = SunatEndpoints::FE_PRODUCCION;
                    } else {
                        $modo = SunatEndpoints::FE_BETA;
                    }

                    $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                    $res = $see->send($invoice);
                    $util->writeXml($invoice, $see->getFactory()->getLastXml());
                    $xml = $see->getXmlSigned($invoice);

                    if ($res->isSuccess()) {
                        /** @var $res \Greenter\Model\Response\BillResult */
                        $cdr = $res->getCdrResponse();
                        $util->writeCdr($invoice, $res->getCdrZip());
                        $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                        $code = (int) $cdr->getCode();
                        if ($code === 0) {
                            $rpta = $cdr->getDescription();
                            $filename = $invoice->getName();
                            $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $invocieno);
                            $this->db->update('jsoft_contingencia');
                            $linkxml = base_url('/files/' . $filename . '.xml');
                            $transok = true;
                            //                        if (count($cdr->getNotes()) > 0) {
                            //                            echo 'OBSERVACIONES:' . PHP_EOL;
                            //                            // Corregir estas observaciones en siguientes emisiones.
                            //                            var_dump($cdr->getNotes());
                            //                        }
                        } else if ($code >= 2000 && $code <= 3999) {
                            $rpta = $cdr->getDescription();
                            $filename = $invoice->getName();
                            $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $invocieno);
                            $this->db->update('jsoft_contingencia');
                            $linkxml = base_url('/files/' . $filename . '.xml');
                            $transok = true;
                        } else {
                            $rpta = $cdr->getDescription();
                            $filename = $invoice->getName();
                            $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                            $this->db->where('id', $invocieno);
                            $this->db->update('jsoft_contingencia');
                            $linkxml = base_url('/files/' . $filename . '.xml');
                            $transok = true;
                        }

                        

                        $rutalogo = file_get_contents('userfiles/company/' . $loc['logo']);
                        $vendedor = $this->invocies->employee($emp);
                        $pdf = $util->getPdf($invoice, $hash, $rutalogo, 'Teléf.' . $loc['phone'], $pmethod, $vendedor);
                        $util->writeFile($invoice->getName() . '.pdf', $pdf);
                        //$adjunto = file_get_contents('files/' . $invoice->getName().'.pdf');
                        $nombre_pdf = $invoice->getName() . '.pdf';
                    } else {
                        $rpta = $util->getErrorResponse($res->getError());
                        $transok = false;
                        echo json_encode(array('status' => 'Error', 'message' => $rpta));
                    }
                }

                $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
                $link = base_url('/billing/view?id=' . $invocieno . '&token=' . $validtoken);
                $linkpdf = base_url('/pos_invoices/thermal_pdf?id=' . $invocieno);
                $linka4 = base_url('/pos_invoices/printinvoice?id=' . $invocieno);
                $linkver = base_url('/pos_invoices/view?id=' . $invocieno);
                $linkcreate = base_url('/pos_invoices/create/');

                if ($transok) {
                    $this->load->library("Printer");
                    $printer = $this->printer->check($this->aauth->get_user()->loc);
                    $p_tid = 'thermal_p';
                    if ($printer['val2'] == 'server')
                        $p_tid = 'thermal_server';
                    echo json_encode(array('status' => 'Success', 'message' => " <center>$rpta</center> <br><center><a target='_blank' href='$linkpdf' class='btn btn-blue btn-lg'><span class='fa fa-ticket' aria-hidden='true'></span> PDF  </a> &nbsp; &nbsp;   <a id='$p_tid' data-ptid='$invocieno' data-url='" . $printer['val3'] . "'  class='btn btn-info btn-lg white'><span class='fa fa-ticket' aria-hidden='true'></span> " . $this->lang->line('Thermal Printer') . "  </a> &nbsp; &nbsp; <a target='_blank' href='$linka4' class='btn btn-blue btn-lg'><span class='fa fa-print' aria-hidden='true'></span> A4  </a> &nbsp; &nbsp; <a href='$linkver' class='btn btn-purple btn-lg'><span class='fa fa-eye' aria-hidden='true'></span> " . $this->lang->line('View') . "  </a> &nbsp; &nbsp; <a href='$link' class='btn btn-blue-grey btn-lg'><span class='fa fa-globe' aria-hidden='true'></span> " . $this->lang->line('Public View') . " </a> &nbsp;<a href='$linkxml' class='btn btn-flickr btn-lg'><span class='fa fa-file-code-o' aria-hidden='true'></span> XML</a>&nbsp;<a href='$linkcreate' class='btn btn-success btn-lg'><span class='fa fa-plus-circle' aria-hidden='true'></span> Nuevo</a></center>"));
                }
                $this->load->model('billing_model', 'billing');
                $tnote = '#' . $invocieno_n . '-' . $pmethod;
                switch ($pmethod) {
                    case 'Efectivo':
                        $r_amt1 = $pamnt;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Pase de Trajeta (POS)':
                        $r_amt1 = 0;
                        $r_amt2 = $pamnt;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Transferencia Bancaria':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = $pamnt;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'yape':
                            $r_amt1 = 0;
                            $r_amt2 = 0;
                            $r_amt3 = 0;
                            $r_amt4 = $amount;
                            $r_amt5 = 0;
                            break;
                    case 'plin':
                            $r_amt1 = 0;
                            $r_amt2 = 0;
                            $r_amt3 = 0;
                            $r_amt4 = 0;
                            $r_amt5 = $amount;
                            break;
                }
                if ($pamnt > 0)
                    $this->billing->paynowcontingencia($invocieno, $pamnt, $tnote, $pmethod, $this->aauth->get_user()->loc, $bill_date, $account);
                $this->registerlog->update($this->aauth->get_user()->id, $r_amt1, $r_amt2, $r_amt3, $r_amt4, $r_amt5, 0, 0);
                if ($promo_flag) {
                    $cqty = $result_c['available'] - 1;
                    if ($cqty > 0) {
                        $data = array('available' => $cqty);
                    } else {
                        $data = array('active' => 1, 'available' => $cqty);
                    }
                    $amount = $result_c['amount'];
                    $this->db->set($data);
                    $this->db->where('id', $result_c['id']);
                    $this->db->update('jsoft_promo');

                    if ($result_c['reflect'] > 0) {
                        $data = array(
                            'payerid' => 0,
                            'payer' => $this->lang->line('Coupon') . '-' . $result_c['code'],
                            'acid' => $result_c['reflect'],
                            'account' => 'Promo',
                            'date' => date('Y-m-d'),
                            'debit' => 0,
                            'credit' => $amount,
                            'type' => 'Income',
                            'cat' => $this->lang->line('Coupon'),
                            'method' => 'Transfer',
                            'eid' => $this->aauth->get_user()->id,
                            'note' => $this->lang->line('Coupon') . ' ' . $result_c['code'],
                            'loc' => $this->aauth->get_user()->loc
                        );
                        $this->db->set('lastbal', "lastbal+$amount", FALSE);
                        $this->db->where('id', $result_c['reflect']);
                        $this->db->update('jsoft_accounts');
                        $this->db->insert('jsoft_transactions', $data);
                    }
                }
            } else {
                echo json_encode(array('status' => 'Error', 'message' => "¡Entrada invalida!"));
                $transok = false;
            }
            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
        }
        if ($transok) {
            $this->db->from('univarsal_api');
            $this->db->where('univarsal_api.id', 56);
            $query = $this->db->get();
            $auto = $query->row_array();
            if ($auto['key1'] == 1) {
                $this->db->select('name,email');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $customer = $query->row_array();

                //GENERAR PDF PARA ENVIAR POR CORREO
                $this->load->helper('convertir');

                $data['id'] = $invocieno;
                $data['round_off'] = $this->custom->api_config(4);
                $data['invoice'] = $this->invocies->invoice_details($invocieno, $this->limited);

                if ($data['invoice']['id'])
                    $data['products'] = $this->invocies->invoice_products($invocieno);
                if ($data['invoice']['id'])
                    $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
                if (CUSTOM)
                    $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1, 1);
                if ($data['invoice']['i_class'] == 1) {
                    $pref = prefix(7);
                } else {
                    $pref = $this->config->item('prefix');
                }
                if ($data['invoice']['tipocomprobante'] == 'B') {
                    $data['tipocomprobante'] = 'BOLETA <br> ELECTŔONICA';
                    $num = '03';
                    //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
                } else {
                    $data['tipocomprobante'] = 'FACTURA <br> ELECTŔONICA';
                    $num = '01';
                    //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
                }


                $data['qr'] = $loc['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';
                $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
                $data['leyenda'] = $leyenda;
                ini_set('memory_limit', '64M');
                if ($data['invoice']['taxstatus'] == 'cgst' || $data['invoice']['taxstatus'] == 'igst') {
                    $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
                } else {
                    $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
                }
                //PDF Rendering
                $this->load->library('pdf');
                if (INVV == 1) {
                    $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
                    $pdf = $this->pdf->load_split(array('margin_top' => 40));
                    $pdf->SetHTMLHeader($header);
                }
                if (INVV == 2) {
                    $pdf = $this->pdf->load_split(array('margin_top' => 5));
                }
                $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
                $pdf->WriteHTML($html);

                $attachment = $pdf->Output('', 'S');

                $this->load->model('communication_model');
                $invoice_mail = $this->send_invoice_auto($invocieno, $serie . '-' . $invocieno2, $bill_date, $total, $currency);
                $attachmenttrue = true;
                //$attachment = $adjunto;
                $nombre = $nombre_pdf;
                $this->communication_model->send_corn_email($customer['email'], $customer['name'], $invoice_mail['subject'], $invoice_mail['message'], $nombre, $attachmenttrue, $attachment);
            }

            if ($auto['key2'] == 1) {
                $this->db->select('name,phone');
                $this->db->from('jsoft_customers');
                $this->db->where('id', $customer_id);
                $query = $this->db->get();
                $customer = $query->row_array();

                $this->load->model('plugins_model', 'plugins');
                $invoice_sms = $this->send_sms_auto($invocieno, $invocieno2, $bill_date, $total, $currency);

                $mobile = $customer['phone'];
                $text_message = $invoice_sms['message'];
                $this->load->model('sms_model', 'sms');
                $this->sms->send_sms($mobile, $text_message, false);
            }
        }
        //profit calculation
        $t_profit = 0;
        $this->db->select('jsoft_contingencia_items.pid, jsoft_contingencia_items.price, jsoft_contingencia_items.qty, jsoft_products.fproduct_price');
        $this->db->from('jsoft_contingencia_items');
        $this->db->join('jsoft_products', 'jsoft_products.pid = jsoft_contingencia_items.pid', 'left');
        $this->db->where('jsoft_contingencia_items.tid', $invocieno);
        $query = $this->db->get();
        $pids = $query->result_array();
        foreach ($pids as $profit) {
            $t_cost = $profit['fproduct_price'] * $profit['qty'];
            $s_cost = $profit['price'] * $profit['qty'];

            $t_profit += $s_cost - $t_cost;
        }
        $data = array('type' => 9, 'rid' => $invocieno, 'col1' => $t_profit, 'd_date' => $bill_date);

        $this->db->insert('jsoft_metadata', $data);

        if ($print_now) {
            $print = $this->thermal_print($invocieno, false, false);
        }
    }

    public function generar_xml()
    {
        $this->load->helper('convertir');
        $tid = $this->input->get('id');
        $products = $this->invocies->invoice_products($tid);
        $invoices = $this->invocies->invoice_details($tid);
        $loc = location($this->aauth->get_user()->loc);

        $totaletras = num_to_letras($invoices['total'], 'PEN');
        $codley = '2001';
        $leyenda = 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA';
        $this->db->trans_start();
        $transok = true;
        if ($loc['emisor'] == '1' || $loc['emisor'] == 1) {
            $util = Util::getInstance();
            // Cliente
            $client = new Client();
            $client->setTipoDoc($invoices['iddoc'])
                ->setNumDoc($invoices['numdoc'])
                ->setRznSocial($invoices['name'])
                ->setAddress((new Address())
                    ->setDireccion($invoices['address']))
                ->setEmail($invoices['email'])
                ->setTelephone($invoices['phone']);
            // Venta
            $invoice = new Invoice();
            $invoice
                ->setUblVersion('2.1')
                ->setTipoOperacion($invoices['idtipooperacion'])
                ->setTipoDoc($invoices['numtipo_comprobante'])
                ->setSerie($invoices['serie'])
                ->setCorrelativo($invoices['tid'])
                ->setFechaEmision(new DateTime($invoices['invoicedate']))
                ->setFormaPago(new FormaPagoContado())
                ->setTipoMoneda('PEN')
                ->setCompany((new Company())
                    ->setRuc($loc['ruc'])
                    ->setNombreComercial($loc['ncomercial'])
                    ->setRazonSocial($loc['cname'])
                    ->setAddress((new Address())
                        ->setUbigueo($loc['ubigeo'])
                        ->setDistrito($loc['city'])
                        ->setProvincia($loc['region'])
                        ->setDepartamento($loc['country'])
                        ->setUrbanizacion('NONE')
                        ->setCodLocal($loc['codlocal'])
                        ->setDireccion($loc['address']))
                    ->setEmail($loc['email'])
                    ->setTelephone($loc['phone']))
                ->setClient($client)
                ->setMtoOperGravadas(0.00)
                ->setMtoOperExoneradas($invoices['subtotal'])
                ->setMtoIGV($invoices['tax'])
                ->setIcbper($invoices['icbper'])
                ->setTotalImpuestos($invoices['tax'] + $invoices['icbper'])
                ->setValorVenta($invoices['subtotal'])
                ->setSubTotal($invoices['subtotal'])
                ->setMtoImpVenta($invoices['total']);

            $detalles = [];
            foreach ($products as $detail) {
                $items = new SaleDetail();
                $items->setCodProducto($detail['code'])
                    ->setUnidad($detail['unit'])
                    ->setCantidad($detail['qty'])
                    ->setDescripcion($detail['product'])
                    ->setMtoValorUnitario($detail['price'])
                    ->setMtoPrecioUnitario($detail['price'])
                    ->setCodProdSunat($detail['codsunat'])
                    ->setMtoValorVenta($detail['subtotal'])
                    ->setTipAfeIgv($detail['idtipoafectacion'])
                    ->setMtoBaseIgv($detail['subtotal'])
                    ->setPorcentajeIgv($detail['tax'])
                    ->setIgv($detail['totaltax'])
                    ->setIcbper(($detail['qty']) * ($detail['icbper'])) // (cantidad)*(factor ICBPER)
                    ->setFactorIcbper($loc['icbper'])
                    ->setTotalImpuestos(($detail['totaltax']) + ($detail['qty']) * ($detail['icbper']));
                $detalles[] = $items;
            }

            $leyenda = [];
                    $monto = new Legend();
                    $monto->setCode('1000')->setValue($totaletras);
                    $leyenda[] = $monto;
                    foreach(leyendas() as $value){
                        $leyendas = new Legend();
                        
                        $leyendas->setCode($value['id'])->setValue($value['valor']);                        
                        $leyenda[] = $leyendas; 
                    }
                    
                    $invoice->setDetails($detalles)->setLegends($leyenda);

            // Envio a SUNAT.
            $rutacert = '/../resources/' . $loc['certificado'];
            $ruc = $loc['ruc'];
            $usuario = $loc['usuariosol'];
            $sol = $loc['clavesol'];
            if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                $modo = SunatEndpoints::FE_PRODUCCION;
            } else {
                $modo = SunatEndpoints::FE_BETA;
                $ruc = '20123456789';

                $usuario = 'MODDATOS';
                $sol = 'moddatos';
            }

            
                $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);
                $res = $see->send($invoice);
                $util->writeXml($invoice, $see->getFactory()->getLastXml());
                $xml = $see->getXmlSigned($invoice);

                if ($res->isSuccess()) {
                    /** @var $res \Greenter\Model\Response\BillResult */
                    $cdr = $res->getCdrResponse();
                    $util->writeCdr($invoice, $res->getCdrZip());
                    $hash = (new \Greenter\Report\XmlUtils())->getHashSign($xml);
                    $code = (int) $cdr->getCode();
                    if ($code === 0) {
                        $rpta = $cdr->getDescription();
                        $filename = $invoice->getName();
                        $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $tid);
                        $this->db->update('jsoft_invoices');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        $transok = true;
                        //                        if (count($cdr->getNotes()) > 0) {
                        //                            echo 'OBSERVACIONES:' . PHP_EOL;
                        //                            // Corregir estas observaciones en siguientes emisiones.
                        //                            var_dump($cdr->getNotes());
                        //                        }
                    } else if ($code >= 2000 && $code <= 3999) {
                        $rpta = $cdr->getDescription();
                        $filename = $invoice->getName();
                        $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $tid);
                        $this->db->update('jsoft_invoices');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        $transok = true;
                    } else {
                        $rpta = $cdr->getDescription();
                        $filename = $invoice->getName();
                        $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription(), 'hash' => $hash, 'nomarchivo' => $filename));
                        $this->db->where('id', $tid);
                        $this->db->update('jsoft_invoices');
                        $linkxml = base_url('/files/' . $filename . '.xml');
                        $transok = true;
                    }



                    //$rutalogo = file_get_contents('userfiles/company/' . $loc['logo']);
                    //$vendedor = $this->invocies->employee($emp);
                    //$pdf = $util->getPdf($invoice, $hash, $rutalogo, 'Teléf.' . $loc['phone'], $modopago, $vendedor);
                    //$util->writeFile($invoice->getName() . '.pdf', $pdf);
                    //$adjunto = file_get_contents('files/' . $invoice->getName().'.pdf');

                } else {
                    $rpta = $util->getErrorResponse($res->getError());
                    $transok = false;
                    echo json_encode(array('status' => 'Error', 'message' => $rpta));
                }

                echo json_encode(array('status' => 'Success', 'message' => $rpta));
        
        }

        if ($transok) {
            $this->db->trans_complete();
        } else {
            $this->db->trans_rollback();
        }
    }

    public function listar_notasdeventa()
    {
        $list = $this->invocies->get_datatables_nota($this->limited);
        $estilo = "";
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;

            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->serie . '</a>';
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="badge st-' . $invoices->status . '">' . $this->lang->line(ucwords($invoices->status)) . '</span>';
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="btn btn-success btn-sm" title="Ver"><i class="fa fa-eye"></i></a>&nbsp;<a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=0" class="btn btn-danger btn-sm"  title="PDF" download><span class="fa fa-file-pdf-o"></span></a>&nbsp;<a href="#" data-object-id="' . $invoices->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';

            $data[] = $row;
        }
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->invocies->count_all_nota($this->limited),
            "recordsFiltered" => $this->invocies->count_filtered_nota($this->limited),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }

    public function listar_resumenes()
    {
        $list = $this->invocies->get_datatables_resumen($this->limited);
        $estilo = "";
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;

            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->serie . '</a>';
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="badge st-' . $invoices->status . '">' . $this->lang->line(ucwords($invoices->status)) . '</span>';
            if ($invoices->sunat == 'Guardado') {
                $row[] = '<i class="spinner-border text-primary mx-2" role="status" title="Guardado" style="font-size:25;color:blue"></i>';
            } else {
                $row[] = '<span class="badge st-' . $invoices->sunat . '" title="' . $invoices->respuesta . '">' . $invoices->sunat . '</span>';
            }
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="btn btn-success btn-sm" title="Ver"><i class="fa fa-eye"></i></a>&nbsp;<a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=0" class="btn btn-danger btn-sm"  title="PDF" download><span class="fa fa-file-pdf-o"></span></a>&nbsp;<a href="#" data-object-id="' . $invoices->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';

            $data[] = $row;
        }
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->invocies->count_all_res($this->limited),
            "recordsFiltered" => $this->invocies->count_filtered_res($this->limited),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_list()
    {
        $list = $this->invocies->get_datatables($this->limited);

        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->serie . '</a>';
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="badge st-' . $invoices->status . '">' . $this->lang->line(ucwords($invoices->status)) . '</span>';
            if ($invoices->sunat == 'Guardado') {
                $row[] = '<i class="spinner-border text-primary mx-2" role="status" title="Guardado" style="font-size:25;color:blue"></i>';
            } else {
                $row[] = '<span class="badge st-' . $invoices->sunat . '" title="' . $invoices->respuesta . '">' . $invoices->sunat . '</span>';
            }

            if ($invoices->tipocomprobante == 'B' && $invoices->sunat == 'Aceptado') {
                $row[] = '
                <a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="success mr-1" title="Ver"><i class="fa fa-eye"></i></a>
                <a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=0" class="danger mr-1"  title="PDF"><span class="fa fa-file-pdf-o"></span></a>
                <a href="' . base_url("files/$invoices->nomarchivo") . '.xml" class="primary mr-1"  title="XML" download><span class="fa fa-file-code-o"></span></a>
                <a href="' . base_url("files/R-$invoices->nomarchivo") . '.zip" class="info mr-1"  title="ZIP"><span class="fa fa-file-archive-o"></span></a>
                <a href="' . base_url("stockreturn/create_note/C/$invoices->id/?ref=$invoices->serie") . '" class="warning mr-1" title="Nota de Crédito"><span class="fa fa-ban"></span></a>';
            } else if ($invoices->tipocomprobante == 'F' && $invoices->sunat == 'Aceptado') {
                $row[] = '
                <a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="success mr-1" title="Ver"><i class="fa fa-eye"></i></a>
                <a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=0" class="danger mr-1"  title="PDF"><span class="fa fa-file-pdf-o"></span></a>
                <a href="' . base_url("files/$invoices->nomarchivo") . '.xml" class="primary mr-1"  title="XML" download><span class="fa fa-file-code-o"></span></a>
                <a href="' . base_url("files/R-$invoices->nomarchivo") . '.zip" class="info mr-1"  title="ZIP"><span class="fa fa-file-archive-o"></span></a>
                <a href="#" data-object-id="' . $invoices->id . '" class="danger mr-1 delete-object" title="Comunicar de Baja"><span class="fa fa-minus-square "></span></a>';
            } else {
                $row[] = '
                <a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="success mr-1" title="Ver"><i class="fa fa-eye"></i></a>
                <a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=0" class="danger mr-1"  title="PDF"><span class="fa fa-file-pdf-o"></span></a>
                <a href="' . base_url("files/$invoices->nomarchivo") . '.xml" class="primary mr-1"  title="XML" download><span class="fa fa-file-code-o"></span></a>
                <a href="' . base_url("files/R-$invoices->nomarchivo") . '.zip" class="info mr-1"  title="ZIP"><span class="fa fa-file-archive-o"></span></a>';
            }

            $data[] = $row;
        }
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->invocies->count_all($this->limited),
            "recordsFiltered" => $this->invocies->count_filtered($this->limited),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }

    //Listar Contingencias
    public function ajax_list_conting()
    {

        $list = $this->invocies->get_datatables_conting($this->limited);

        $data = array();

        $no = $this->input->post('start');

        foreach ($list as $contingencias) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$contingencias->id") . '">&nbsp; ' . $contingencias->serie . '</a>';
            $row[] = $contingencias->name;
            $row[] = dateformat($contingencias->invoicedate);
            $row[] = amountExchange($contingencias->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="st-' . $contingencias->status . '">' . $this->lang->line(ucwords($contingencias->status)) . '</span>';
            $row[] = '<span class="badge st-' . $contingencias->sunat . '">' . ucwords($contingencias->sunat) . '</span>';
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$contingencias->id") . '" class="btn btn-success btn-sm" title="Ver"><i class="fa fa-eye"></i></a>&nbsp;<a href="' . base_url("pos_invoices/thermal_pdf?id=$contingencias->id") . '&d=1" class="btn btn-info btn-sm"  title="Descargar"><span class="fa fa-download"></span></a>&nbsp;<a href="' . base_url("stockreturn/create_note/C/$contingencias->id/?ref=$contingencias->serie") . '" class="btn btn-warning btn-sm"><span class="fa fa-ban"></span></a>&nbsp;<a href="#" data-object-id="' . $contingencias->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';

            $data[] = $row;
        }


        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->invocies->count_all_cont($this->limited),
            "recordsFiltered" => $this->invocies->count_filtered_cont($this->limited),
            "data" => $data,
        );

        //salida a formato json
        echo json_encode($output);
    }

    public function extended_ajax_list()
    {
        if (!$this->aauth->premission(10)) {

            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }

        $list = $this->extended_invoice->get_datatables($this->limited);

        $data = array();

        $no = $this->input->post('start');

        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->serie . '</a>';
            $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->tid . '</a>';
            $row[] = $invoices->numdoc;
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = $invoices->product;
            $row[] = amountFormat_general($invoices->qty);
            $row[] = amountExchange($invoices->subtotal, 0, $this->aauth->get_user()->loc);
            $row[] = amountExchange($invoices->discount, 0, $this->aauth->get_user()->loc);
            $row[] = amountExchange($invoices->icbper, 0, $this->aauth->get_user()->loc);
            $row[] = amountExchange($invoices->tax, 0, $this->aauth->get_user()->loc);
            $row[] = $invoices->sunat;

            //   $row[] = '<a href="' . base_url("pos_invoices/view?id=$invoices->id") . '" class="btn btn-success btn-sm" title="Ver"><i class="fa fa-eye"></i></a>&nbsp;<a href="' . base_url("pos_invoices/thermal_pdf?id=$invoices->id") . '&d=1" class="btn btn-info btn-sm"  title="Download"><span class="fa fa-download"></span></a>&nbsp;<a href="#" data-object-id="' . $invoices->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';

            $data[] = $row;
        }


        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->extended_invoice->count_all($this->limited),
            "recordsFiltered" => $this->extended_invoice->count_filtered($this->limited),
            "data" => $data,
        );

        //output to json format
        echo json_encode($output);
    }

    public function view()
    {
        $this->load->model('accounts_model');
        $data['acclist'] = $this->accounts_model->accountslist((int) $this->aauth->get_user()->loc);
        $tid = $this->input->get('id');
        $xml = $this->input->get('xml');

        if (!empty($xml)) {
            $loc = location($this->aauth->get_user()->loc);

            $util = Util::getInstance();

            $rutacert = '/../resources/' . $loc['certificado'];
            $ruc = $loc['ruc'];
            $usuario = $loc['usuariosol'];
            $sol = $loc['clavesol'];
            if ($loc['modo'] == '1' || $loc['modo'] == 1) {
                $modo = SunatEndpoints::FE_PRODUCCION;
            } else {
                $modo = SunatEndpoints::FE_BETA;
                $ruc = '20123456789';

                $usuario = 'MODDATOS';
                $sol = 'moddatos';
            }

            $see = $util->getSee($modo, $ruc, $usuario, $sol, $rutacert);

            /* Si solo desea enviar un XML ya generado utilice esta función */
            //$res = $see->sendXmlFile(get_class($invoice), $invoice->getName(), file_get_contents($ruta_XML));

            $res = $see->sendXmlFile(file_get_contents('./files/' . $xml . '.xml'));

            if ($res->isSuccess()) {
                $cdr = $res->getCdrResponse();
                $code = (int) $cdr->getCode();

                if ($code === 0 || $code === 'CDR') {
                    $rpta = $cdr->getDescription();

                    $this->db->set(array('sunat' => 'Aceptado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_invoices');
                    $estado = 'Success';
                } else if ($code >= 2000 || $code <= 3999) {
                    $rpta = $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Rechazado', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_invoices');
                    $estado = 'Error';
                } else {
                    $rpta = $cdr->getDescription();
                    $this->db->set(array('sunat' => 'Excepción', 'respuesta' => $cdr->getDescription()));
                    $this->db->where('id', $tid);
                    $this->db->update('jsoft_invoices');
                    $estado = 'Error';
                }
            } else {
                $rpta = $util->getErrorResponse($res->getError());
                $estado = 'Error';

                //                echo json_encode(array('status' => 'Error', 'message' => $rpta));
            }
            echo json_encode(array('status' => $estado, 'message' => $rpta));
        } else {
            $data['id'] = $tid;

            $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);

            $head['title'] = "Comprobante " . $data['invoice']['tid'];

            $data['attach'] = $this->invocies->attach($tid);

            if ($data['invoice']['id']) {

                $data['products'] = $this->invocies->invoice_products($tid);
            };
            if ($data['invoice']['id'])
                $data['activity'] = $this->invocies->invoice_transactions($tid);
            $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1);

            $this->load->library("Printer");
            $data['printer'] = $this->printer->check($data['invoice']['loc']);

            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
            
            if ($data['invoice']['tipocomprobante'] == 'B') {
                $data['tipocomprobante'] = $data['invoice']['nombre_docu'];
                //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
            } else if ($data['invoice']['tipocomprobante'] == 'F') {
                $data['tipocomprobante'] = $data['invoice']['nombre_docu'];
                //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
            } else {
                $data['tipocomprobante'] = $data['invoice']['nombre_docu'];
            }
            //$data['serie'] = $data['invoice']['serie'];

            $head['usernm'] = $this->aauth->get_user()->username;
            $this->load->view('fixed/header', $head);
            if ($data['invoice']['id'])
                $this->load->view('pos/view', $data);
            $this->load->view('fixed/footer');
        }
    }

    public function printinvoice()
    {
        $this->load->helper('convertir');
        $tid = $this->input->get('id');
        $data['id'] = $tid;
        $data['round_off'] = $this->custom->api_config(4);
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id'])
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
        if (CUSTOM)
            $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1, 1);
        if ($data['invoice']['i_class'] == 1) {
            $pref = prefix(7);
        } else {
            $pref = $this->config->item('prefix');
        }
        
            $data['tipocomprobante'] = $data['invoice']['nombre_docu'];            
        
        $loc = location($data['invoice']['loc']);
        $data['leyenda'] = '';
        $data['qr'] = $loc['ruc'] . '|' . $data['invoice']['numtipo_comprobante'] . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';
        $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
        ini_set('memory_limit', '64M');
        if ($data['invoice']['taxstatus'] == 'cgst' || $data['invoice']['taxstatus'] == 'igst') {
            $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
        } else {
            $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
        }
        //Representación de PDF
        $this->load->library('pdf');
        if (INVV == 1) {
            $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
            $pdf = $this->pdf->load_split(array('margin_top' => 40));
            $pdf->SetHTMLHeader($header);
        }
        if (INVV == 2) {
            $pdf = $this->pdf->load_split(array('margin_top' => 5));
        }
        $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
        $pdf->WriteHTML($html);
        if ($this->input->get('d')) {
            $pdf->Output($data['invoice']['nomarchivo'] . '.pdf', 'D');
        } else {
            $pdf->Output($data['invoice']['nomarchivo'] . '.pdf', 'I');
        }
    }

    public function printguia()
    {
        $this->load->helper('convertir');
        $tid = $this->input->get('id');
        $data['id'] = $tid;
        $data['round_off'] = $this->custom->api_config(4);
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id'])
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
        if (CUSTOM)
            $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1, 1);
        if ($data['invoice']['i_class'] == 1) {
            $pref = prefix(7);
        } else {
            $pref = $this->config->item('prefix');
        }
        
            $data['tipocomprobante'] = 'GUIA REMISION ELECTRONICA - REMITENTE';
            $num = '09';
           
        $loc = location($data['invoice']['loc']);
        $data['leyenda'] = '';
        $data['qr'] = $loc['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';
        $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
        ini_set('memory_limit', '64M');
        
        $html = $this->load->view('print_files/guia-a4_v' . INVV, $data, true);
        
        //Representación de PDF
        $this->load->library('pdf');
        if (INVV == 1) {
            $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
            $pdf = $this->pdf->load_split(array('margin_top' => 40));
            $pdf->SetHTMLHeader($header);
        }
        if (INVV == 2) {
            $pdf = $this->pdf->load_split(array('margin_top' => 5));
        }
        $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
        $pdf->WriteHTML($html);
        if ($this->input->get('d')) {
            $pdf->Output($data['invoice']['nomarchivo'] . '.pdf', 'D');
        } else {
            $pdf->Output($data['invoice']['nomarchivo'] . '.pdf', 'I');
        }
    }

    public function delete_i()
    {
        $id = $this->input->post('deleteid');
        if ($this->aauth->premission(11)) {
            if ($this->invocies->invoice_delete($id, $this->limited)) {
                echo json_encode(array('status' => 'Success', 'message' =>
                $this->lang->line('DELETED')));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
            $this->lang->line('ERROR')));
        }
    }

    public function editaction()
    {
        $ptype = $this->input->post('type');
        $coupon = $this->input->post('coupon');
        $notes = $this->input->post('notes', true);
        $coupon_amount = 0;
        $coupon_n = '';
        $account = $this->input->post('account', true);
        $customer_id = $this->input->post('customer_id');
        $invocieno_n = $this->input->post('invoiceno');
        $invocieno = $this->input->post('iid');
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $currency = $this->input->post('mcurrency');
        if ($ptype == 4) {
            $p_amount = rev_amountExchange_s($this->input->post('p_amount'), $currency, $this->aauth->get_user()->loc);
            $pmethod = $this->input->post('p_method');
            $notes = $this->input->post('notes');
            $tax = $this->input->post('tax_handle');
            $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
            $ship_taxtype = $this->input->post('ship_taxtype');
            $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
            $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
            if ($ship_taxtype == 'incl')
                $shipping = $shipping - $shipping_tax;
            $refer = $this->input->post('refer');
            $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
            $old_total = rev_amountExchange_s($this->input->post('old_total'), $currency, $this->aauth->get_user()->loc);
            $total_tax = 0;
            $total_discount = 0;
            $discountFormat = $this->input->post('discountFormat');
            $pterms = $this->input->post('pterms');
            //edit
            $diff = $total - $old_total;
            $c_amt = $p_amount - $diff;
            if ($c_amt < 0) {
                $c_amt = 0;
            }
            $i = 0;
            if ($this->limited) {
                $employee = $this->invocies->invoice_details($invocieno, $this->limited);
                if ($this->aauth->get_user()->id != $employee['eid'])
                    exit();
            }
            if ($discountFormat == '0') {
                $discstatus = 0;
            } else {
                $discstatus = 1;
            }
            if ($customer_id == 0) {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
                exit;
            }
            $this->db->trans_start();
            $transok = true;
            $bill_date = datefordatabase($invoicedate);
            $bill_due_date = datefordatabase($invocieduedate);
            $promo_flag = false;
            if ($coupon) {
                $this->db->select('*');
                $this->db->from('jsoft_promo');
                $this->db->where('code', $coupon);
                $query = $this->db->get();
                $result_c = $query->row_array();
                if ($result_c['active'] == 0 && $result_c['available'] > 0) {
                    $promo_flag = true;
                    $amount = $result_c['amount'];
                    $notes .= '-' . $this->input->post('i_coupon');
                    $total_discount += $amount;
                }
            }
            $data = array('invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'total' => $total, 'notes' => $notes, 'csd' => $customer_id, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'multi' => $currency);
            $this->db->set($data);
            $this->db->where('id', $invocieno);
            if ($this->db->update('jsoft_invoices', $data)) {
                //Product Data
                $pid = $this->input->post('pid');
                $productlist = array();
                $prodindex = 0;
                $itc = 0;
                $this->db->delete('jsoft_invoice_items', array('tid' => $invocieno));
                $product_id = $this->input->post('pid');
                $product_name1 = $this->input->post('product_name', true);
                $product_qty = $this->input->post('product_qty');
                $old_product_qty = $this->input->post('old_product_qty');
                $product_price = $this->input->post('product_price');
                $product_tax = $this->input->post('product_tax');
                $product_discount = $this->input->post('product_discount');
                $product_subtotal = $this->input->post('product_subtotal');
                $ptotal_tax = $this->input->post('taxa');
                $ptotal_disc = $this->input->post('disca');
                $product_des = $this->input->post('product_description', true);
                $product_unit = $this->input->post('unit');
                $product_hsn = $this->input->post('hsn');
                $product_serial = $this->input->post('serial');
                foreach ($pid as $key => $value) {

                    $total_discount += numberClean(@$ptotal_disc[$key]);
                    $total_tax += numberClean($ptotal_tax[$key]);
                    $data = array(
                        'tid' => $invocieno,
                        'pid' => $product_id[$key],
                        'product' => $product_name1[$key],
                        'code' => $product_hsn[$key],
                        'qty' => numberClean($product_qty[$key]),
                        'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                        'tax' => numberClean($product_tax[$key]),
                        'discount' => numberClean($product_discount[$key]),
                        'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                        'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                        'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                        'product_des' => $product_des[$key],
                        'i_class' => 1,
                        'unit' => $product_unit[$key],
                        'serial' => $product_serial[$key]
                    );

                    $productlist[$prodindex] = $data;
                    $i++;
                    $prodindex++;
                    $amt = numberClean($product_qty[$key]) - @numberClean($old_product_qty[$key]);

                    if ($product_id[$key] > 0) {
                        $this->db->set('qty', "qty-$amt", FALSE);
                        $this->db->where('pid', $product_id[$key]);
                        $this->db->update('jsoft_products');
                    }
                    $itc += $amt;
                }
                if ($prodindex > 0) {
                    $this->db->insert_batch('jsoft_invoice_items', $productlist);
                    $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                    $this->db->where('id', $invocieno);
                    $this->db->update('jsoft_invoices');
                    if (count($product_serial) > 0) {
                        $this->db->set('status', 1);
                        $this->db->where_in('serial', $product_serial);
                        $this->db->update('jsoft_product_serials');
                    }
                } else {
                    echo json_encode(array('status' => 'Error', 'message' =>
                    "Please add at least one product in invoice"));
                    $transok = false;
                }
                echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('Invoice has  been updated') . " <a href='view?id=$invocieno' class='btn btn-info btn-lg'><span class='icon-file-text2' aria-hidden='true'></span> " . $this->lang->line('View') . " </a> "));

                $this->load->model('billing_model', 'billing');
                $tnote = '#' . $invocieno_n . '-' . $pmethod;
                switch ($pmethod) {
                    case 'Efectivo':
                        $r_amt1 = $diff;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Pase de Trajeta (POS)':
                        $r_amt1 = 0;
                        $r_amt2 = $diff;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'Transferencia Bancaria':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = $diff;
                        $r_amt4 = 0;
                        $r_amt5 = 0;
                        break;
                    case 'yape':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = $amount;
                        $r_amt5 = 0;
                        break;
                    case 'plin':
                        $r_amt1 = 0;
                        $r_amt2 = 0;
                        $r_amt3 = 0;
                        $r_amt4 = 0;
                        $r_amt5 = $amount;
                        break;
                }
                $this->billing->paynow($invocieno, $diff, $tnote, $pmethod, $this->aauth->get_user()->loc, 0, $account);
                $this->registerlog->update($this->aauth->get_user()->id, $r_amt1, $r_amt2, $r_amt3, $r_amt4, $r_amt5, 0, $c_amt);
                if ($promo_flag) {
                    $cqty = $result_c['available'] - 1;
                    if ($cqty > 0) {
                        $data = array('available' => $cqty);
                    } else {
                        $data = array('active' => 1, 'available' => $cqty);
                    }
                    $amount = $result_c['amount'];
                    $this->db->set($data);
                    $this->db->where('id', $result_c['id']);
                    $this->db->update('jsoft_promo');

                    if ($result_c['reflect'] > 0) {
                        $data = array(
                            'payerid' => 0,
                            'payer' => $this->lang->line('Coupon') . '-' . $result_c['code'],
                            'acid' => $result_c['reflect'],
                            'account' => 'Promo',
                            'date' => date('Y-m-d'),
                            'debit' => 0,
                            'credit' => $amount,
                            'type' => 'Income',
                            'cat' => $this->lang->line('Coupon'),
                            'method' => 'Transfer',
                            'eid' => $this->aauth->get_user()->id,
                            'note' => $this->lang->line('Coupon') . ' ' . $this->lang->line('Delete') . ' ' . $this->lang->line('Qty') . '-' . $result_c['available'],
                            'loc' => $this->aauth->get_user()->loc
                        );
                        $this->db->set('lastbal', "lastbal+$amount", FALSE);
                        $this->db->where('id', $result_c['reflect']);
                        $this->db->update('jsoft_accounts');
                        $this->db->insert('jsoft_transactions', $data);
                    }
                }
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
                $transok = false;
            }

            if ($this->input->post('restock')) {
                foreach ($this->input->post('restock') as $key => $value) {

                    $myArray = explode('-', $value);
                    $prid = $myArray[0];
                    $dqty = numberClean($myArray[1]);
                    if ($prid > 0) {
                        $this->db->set('qty', "qty+$dqty", FALSE);
                        $this->db->where('pid', $prid);
                        $this->db->update('jsoft_products');
                    }
                }
            }


            if ($transok) {
                $this->db->trans_complete();
            } else {
                $this->db->trans_rollback();
            }
        }

        //profit calculation
        $t_profit = 0;
        $this->db->select('jsoft_invoice_items.pid, jsoft_invoice_items.price, jsoft_invoice_items.qty, jsoft_products.fproduct_price');
        $this->db->from('jsoft_invoice_items');
        $this->db->join('jsoft_products', 'jsoft_products.pid = jsoft_invoice_items.pid', 'left');
        $this->db->where('jsoft_invoice_items.tid', $invocieno);
        $query = $this->db->get();
        $pids = $query->result_array();
        foreach ($pids as $profit) {
            $t_cost = $profit['fproduct_price'] * $profit['qty'];
            $s_cost = $profit['price'] * $profit['qty'];

            $t_profit += $s_cost - $t_cost;
        }
        $this->db->set('col1', $t_profit);
        $this->db->where('type', 9);
        $this->db->where('rid', $invocieno);
        $this->db->update('jsoft_metadata');
    }

    public function update_status()
    {
        $tid = $this->input->post('tid');
        $status = $this->input->post('status');
        $this->db->set('status', $status);
        $this->db->where('id', $tid);
        $this->db->update('jsoft_invoices');
        echo json_encode(array('status' => 'Success', 'message' =>
        $this->lang->line('UPDATED'), 'pstatus' => $status));
    }

    public function addcustomer()
    {
        $name = $this->input->post('name', true);
        $company = $this->input->post('company', true);
        $phone = $this->input->post('phone', true);
        $email = $this->input->post('email', true);
        $address = $this->input->post('address', true);
        $city = $this->input->post('city', true);
        $region = $this->input->post('region', true);
        $country = $this->input->post('country', true);
        $postbox = $this->input->post('postbox', true);
        $taxid = $this->input->post('taxid', true);
        $customergroup = $this->input->post('customergroup', true);
        $name_s = $this->input->post('name_s', true);
        $phone_s = $this->input->post('phone_s', true);
        $email_s = $this->input->post('email_s', true);
        $address_s = $this->input->post('address_s', true);
        $city_s = $this->input->post('city_s', true);
        $region_s = $this->input->post('region_s', true);
        $country_s = $this->input->post('country_s', true);
        $postbox_s = $this->input->post('postbox_s', true);
        $custom = $this->input->post('c_field', true);
        $this->load->model('customers_model', 'customers');
        $this->customers->add($name, $company, $phone, $email, $address, $city, $region, $country, $postbox, $customergroup, $taxid, $name_s, $phone_s, $email_s, $address_s, $city_s, $region_s, $country_s, $postbox_s, '', '', '', '', $custom);
    }

    public function file_handling()
    {
        if ($this->input->get('op')) {
            $name = $this->input->get('name');
            $invoice = $this->input->get('invoice');
            if ($this->invocies->meta_delete($invoice, 1, $name)) {
                echo json_encode(array('status' => 'Success'));
            }
        } else {
            $id = $this->input->get('id');
            $this->load->library("Uploadhandler_generic", array(
                'accept_file_types' => '/\.(gif|jpe?g|png|docx|docs|txt|pdf|xls)$/i', 'upload_dir' => FCPATH . 'userfiles/attach/', 'upload_url' => base_url() . 'userfiles/attach/'
            ));
            $files = (string) $this->uploadhandler_generic->filenaam();
            if ($files != '') {

                $this->invocies->meta_insert($id, 1, $files);
            }
        }
    }

    function thermal_print($id = 0, $mode = true, $d = true)
    {
        //dual mode -basic for standard users and advanced mode

        $basic_mode = false;

        $tid = $this->input->get('id');
        if (!$tid > 0)
            $tid = $id;
        $data['id'] = $tid;
        $data['title'] = "Comprobante $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id'])
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        $this->load->library("Printer");
        $printer_data = $this->printer->check($data['invoice']['loc']);

        if ($printer_data) {

            if ($printer_data['val2'] != 'server') {
                if ($d)
                    echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('your thermal printer')));

                //based on  https://github.com/mike42/escpos-php
                switch ($printer_data['val2']) {
                    case 'file':
                        $connector = new FilePrintConnector($printer_data['val3']);
                        break;
                    case 'network':
                        $address = parse_url($printer_data['val3']);
                        $connector = new NetworkPrintConnector($address['host'], $address['port']);
                        break;
                    case 'windows':
                        $connector = new WindowsPrintConnector($printer_data['val3']);
                        break;

                    case 'test':
                        $connector = new DummyPrintConnector();
                        break;
                }

                $items = array();
                $sub_t = 0;
                foreach ($data['products'] as $row) {
                    $items[] = $this->toString($row['product'], $row['subtotal']);
                    $sub_t += $row['price'] * $row['qty'];
                }
                $subtotal = $this->toString($this->lang->line('Subtotal'), $sub_t);
                $tax = $this->toString($this->lang->line('Tax'), $data['invoice']['tax']);
                $total = $this->toString($this->lang->line('Total'), $data['invoice']['total'], true);
                $round_off = $this->custom->api_config(4);
                if ($round_off['other']) {
                    $final_amount = round($data['invoice']['total'], $round_off['active'], constant($round_off['other']));
                    $total_round = $this->toString($this->lang->line('Round Off'), $final_amount, true);
                }

                //Date is kept the same for testing
                // $date = date('l jS \of F Y h:i:s A');
                $date = dateformat($data['invoice']['invoicedate']) . ' ' . date('h:i:s A');
                //simple and fast printing
                if (!$printer_data['other']) {

                    // Start the printer
                    //$logo = EscposImage::load(FCPATH . "userfiles/company/logo.png", false);
                    $printer = new Printer($connector);

                    // Print top logo
                    $printer->setJustification(Printer::JUSTIFY_CENTER);
                    //$printer->graphics($logo);
                    //Name of shop
                    $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
                    $printer->text($this->config->item('ctitle') . "\n");
                    $printer->selectPrintMode();
                    $printer->text($this->config->item('address') . "\n");
                    $printer->feed();

                    //Title of receipt
                    $printer->setEmphasis(true);
                    $printer->text($this->lang->line('Invoice') . ' ' . $data['invoice']['tid'] . "\n");
                    $printer->setEmphasis(false);

                    //Items
                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                    $printer->setEmphasis(true);
                    $printer->text($this->toString('', $this->config->item('currency')));
                    $printer->setEmphasis(false);
                    foreach ($items as $item) {
                        $printer->text($item);
                    }
                    $printer->setEmphasis(true);
                    $printer->text($subtotal);
                    $printer->setEmphasis(false);
                    $printer->feed();

                    // Tax and total
                    $printer->text($tax);
                    $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
                    $printer->text($total);
                    if ($round_off['other']) {
                        $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
                        $printer->text($total_round);
                    }
                    $printer->selectPrintMode();

                    // Footer
                    $printer->feed(2);
                    $printer->setJustification(Printer::JUSTIFY_CENTER);
                    $printer->text($this->lang->line('Thank you') . "\n");
                    $printer->text("\n");
                    $printer->feed(2);
                    $printer->text($date . "\n");

                    // Cut the receipt and open the cash drawer
                    $printer->cut();
                    //   $printer->pulse();
                    if ($printer_data['val2'] == 'test') {
                        $data = $connector->getData();

                        header('Content-type: application/octet-stream');
                        header('Content-Length: ' . strlen($data));

                        $file = FCPATH . "pos_test_receipt_" . date('Y-m-d_H_i_s') . ".bin";
                        file_put_contents($file, $data);
                    }


                    $printer->close();
                } else {
                    //thermal pdf printing
                    $printer = new Printer($connector);
                    $this->pheight = 0;
                    $data['id'] = $tid;
                    $data['title'] = "Invoice $tid";
                    $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
                    if ($data['invoice'])
                        $data['products'] = $this->invocies->invoice_products($tid);
                    if ($data['invoice'])
                        $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

                    $this->load->model('billing_model', 'billing');
                    $online_pay = $this->billing->online_pay_settings();
                    if ($online_pay['enable'] == 1) {
                        $token = hash_hmac('ripemd160', $tid, $this->config->item('encryption_key'));
                        $data['qrc'] = 'pos_' . date('Y_m_d_H_i_s') . '_.png';
                        $static_q = $data['qrc'];

                        $qrCode = new QrCode(base_url('billing/card?id=' . $tid . '&itype=inv&token=' . $token));

                        //header('Content-Type: '.$qrCode->getContentType());
                        //echo $qrCode->writeString();
                        $qrCode->writeFile(FCPATH . 'userfiles/pos_temp/' . $data['qrc']);
                    }

                    // boost the memory limit if it's low ;)
                    ini_set('memory_limit', '64M');
                    // load library
                    $this->load->library('pdf');
                    $pdf = $this->pdf->load_thermal();
                    // retrieve data from model or just static date
                    $data['title'] = "items";
                    $pdf->allow_charset_conversion = true;  // Set by default to TRUE
                    $pdf->charset_in = 'UTF-8';
                    //   $pdf->SetDirectionality('rtl'); // Set lang direction for rtl lang
                    $pdf->autoLangToFont = true;
                    $html = $this->load->view('pos/pdfposthermal', $data, true);
                    // render the view into HTML

                    $h = 160 + $this->pheight;
                    $pdf->_setPageSize(array(70, $h), $pdf->DefOrientation);
                    $pdf->WriteHTML($html);
                    $file_name = preg_replace('/[^A-Za-z0-9]+/', '-', 'PosInvoice_' . $data['invoice']['name'] . '_' . $data['invoice']['tid']);

                    $pdf->Output('userfiles/pos_temp/' . $file_name . '.pdf', 'F');

                    if (!extension_loaded('imagick')) {
                        echo 'imagick not installed';
                    }
                    $im = new Imagick();

                    $im->setResolution(300, 300);
                    $im->readimage(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_name . '.pdf');
                    $im->setImageType(imagick::IMGTYPE_TRUECOLOR);
                    $im->setImageFormat('png');
                    //$im->transparentPaintImage(      'white', 0, 100, false    );
                    $im->writeImage(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_name . '.png');
                    $im->clear();
                    $im->destroy();
                    $printer->graphics(EscposImage::load(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_name . '.png'));
                    $printer->cut();
                    if ($printer_data['val2'] == 'test') {
                        $data = $connector->getData();

                        header('Content-type: application/octet-stream');
                        header('Content-Length: ' . strlen($data));

                        $file = FCPATH . "advanced_pos_test_receipt_" . date('Y-m-d_H_i_s') . ".bin";
                        file_put_contents($file, $data);
                    }
                    $printer->close();
                    unlink(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $static_q);
                    unlink(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_name . '.pdf');
                    unlink(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_name . '.png');
                }
            } elseif ($printer_data['val2'] == 'server') {

                $this->db->select('key');
                $this->db->from('jsoft_restkeys');
                $this->db->limit(1);
                $query_r = $this->db->get();
                if ($query_r->num_rows() > 0) {
                    $rest = $query_r['key'];
                    $ch = curl_init();
                    // Set cURL options
                    curl_setopt($ch, CURLOPT_URL, $printer_data['val3'] . "pos_printer/index.php?app_url=" . htmlentities(base_url() . '&id=' . $tid . '&rest_key=' . $rest . '&printer_connection=server'));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.66 Safari/537.36");
                    // Decode returned JSON
                    $output = json_decode(curl_exec($ch), true);
                    // Close Channel
                    curl_close($ch);
                } else {
                    if ($mode)
                        echo json_encode(array('status' => 'Error', 'message' => 'Please create  a rest key.'));
                }
            } else {
                if ($mode)
                    echo json_encode(array('status' => 'Error', 'message' => 'Please setup a thermal printer in printer section.'));
            }
        }
    }

    public function toString($name = '', $price = '', $dollarSign = false)
    {
        $rightCols = 10;
        $leftCols = 38;
        if ($dollarSign) {
            $leftCols = $leftCols / 2 - $rightCols / 2;
        }
        $left = str_pad($name, $leftCols);

        $sign = $this->config->item('currency');
        $right = str_pad($sign . $price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$right\n";
    }

    function thermal_pdf()
    {
        $this->load->helper('convertir');
        $this->load->helper('pdf');
        $id = $this->input->get('id');
        $d = $this->input->get('d');
        if (!$id) {
            exit('eer');
        }

        $tid = $id;
        $data['qrc'] = '.png';
        $data['id'] = $tid;
        $data['title'] = "Comprobante $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid);

        if ($data['invoice']) $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']) $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        if ($data['invoice']['tipocomprobante'] == 'B') {

            $num = '03';
            //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        } else if ($data['invoice']['tipocomprobante'] == 'F') {

            $num = '01';
            //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        } else {

            $num = '01';
        }
        $data['loc'] = location($data['invoice']['loc']);
        $data['leyenda'] = '';
        $data['qrc'] = $data['loc']['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';

        $data['logo'] = $data['loc']['logo'];
        $data['moneda'] = $data['loc']['currency'];
        $data['d'] = $d;
        ini_set('memory_limit', '64M');

        $this->load->view('print_files/ticket', $data);
    }

    public function set_coupon()
    {
        $id = $this->input->post('coupon');
        if ($id) {
            $this->db->select('*');
            $this->db->from('jsoft_promo');
            $this->db->where('code', $id);
            $query = $this->db->get();
            $promo = $query->row_array();
            if (($promo['active'] == 0) && ($promo['available'] > 0) && (strtotime($promo['valid']) >= strtotime(date('Y-m-d')))) {
                echo json_encode(array('status' => 'Success', 'message' => $promo['code'] . ' ' . $this->lang->line('Coupon Applied') . ' ' . $this->lang->line('Amount') . ' ' . amountFormat_general($promo['amount']), 'amount' => amountFormat_general($promo['amount'])));
            } elseif (($promo['active'] == 0) && ($promo['available'] > 0) && (strtotime($promo['valid']) < strtotime(date('Y-m-d')))) {
                echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('Coupon Expired'), 'amount' => 0));
            } elseif ($promo['active'] > 0) {
                echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('Usages Exceed'), 'amount' => 0));
            } else {
                echo json_encode(array('status' => 'Error', 'message' => $this->lang->line('Invalid Coupon'), 'amount' => 0));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' => '', 'amount' => 0));
        }
    }

    public function send_invoice_auto($invocieno, $invocieno2, $idate, $total, $multi)
    {
        $this->load->library('parser');
        $this->load->model('templates_model', 'templates');
        $template = $this->templates->template_info(6);

        $data = array(
            'Company' => $this->config->item('ctitle'),
            'BillNumber' => $invocieno2
        );
        $subject = $this->parser->parse_string($template['key1'], $data, TRUE);
        $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
        $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);


        $data = array(
            'Company' => $this->config->item('ctitle'),
            'BillNumber' => $invocieno2,
            'URL' => "<a href='$link'>$link</a>",
            'CompanyDetails' => '<h6><strong>' . $this->config->item('ctitle') . ',</strong></h6>
<address>' . $this->config->item('address') . '<br>' . $this->config->item('address2') . '</address>
             ' . $this->lang->line('Phone') . ' : ' . $this->config->item('phone') . '<br>  ' . $this->lang->line('Email') . ' : ' . $this->config->item('email'),
            'DueDate' => dateformat($idate),
            'Amount' => amountExchange($total, $multi)
        );
        $message = $this->parser->parse_string($template['other'], $data, TRUE);


        return array('subject' => $subject, 'message' => $message);
    }

    public function send_sms_auto($invocieno, $invocieno2, $idate, $total, $multi)
    {
        $this->load->library('parser');
        $this->load->model('templates_model', 'templates');
        $template = $this->templates->template_info(30);
        $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
        $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);
        $this->load->model('plugins_model', 'plugins');
        $sms_service = $this->plugins->universal_api(1);
        if ($sms_service['active']) {
            $this->load->library("Shortenurl");
            $this->shortenurl->setkey($sms_service['key1']);
            $link = $this->shortenurl->shorten($link);
        }
        $data = array(
            'BillNumber' => $invocieno2,
            'URL' => $link,
            'DueDate' => dateformat($idate),
            'Amount' => amountExchange($total, $multi)
        );
        $message = $this->parser->parse_string($template['other'], $data, TRUE);
        return array('message' => $message);
    }

    public function invoicepdf()
    {
        $run = false;
        $id = $this->input->get('id');
        $key = $this->input->get('key');
        $this->db->select('key');
        $this->db->from('jsoft_restkeys');
        $this->db->limit(1);
        $this->db->where('key', $key);
        $query_r = $this->db->get();
        if ($query_r->num_rows() > 0) {
            $run = true;
        }

        if (!$run) {
            exit('eer');
        }

        // Obtener el usuario de la matriz, usando el id como clave para la recuperación.
        // Por lo general, se debe usar un modelo para esto.

        $tid = $id;
        $data['qrc'] = 'pos_' . date('Y_m_d_H_i_s') . '_.png';
        $data['id'] = $tid;
        $data['title'] = "Invoice $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid);
        if ($data['invoice'])
            $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice'])
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);


        $this->load->model('billing_model', 'billing');
        $online_pay = $this->billing->online_pay_settings();
        if ($online_pay['enable'] == 1) {
            $token = hash_hmac('ripemd160', $tid, $this->config->item('encryption_key'));
            $data['qrc'] = 'pos_' . date('Y_m_d_H_i_s') . '_.png';

            $qrCode = new QrCode(base_url('billing/card?id=' . $tid . '&itype=inv&token=' . $token));

            //header('Content-Type: '.$qrCode->getContentType());
            //echo $qrCode->writeString();
            $qrCode->writeFile(FCPATH . 'userfiles/pos_temp/' . $data['qrc']);
        }

        $this->pheight = 0;
        $this->load->library('pdf');
        $pdf = $this->pdf->load_thermal();
        // recuperar datos del modelo o simplemente de la fecha estática
        $data['title'] = "items";
        $pdf->allow_charset_conversion = true;  // Set by default to TRUE
        $pdf->charset_in = 'UTF-8';
        //   $pdf->SetDirectionality('rtl'); // Set lang direction for rtl lang
        $pdf->autoLangToFont = true;
        $data['round_off'] = $this->custom->api_config(4);
        $html = $this->load->view('print_files/pos_pdf_compact', $data, true);
        // render the view into HTML

        $h = 160 + $this->pheight;
        $pdf->_setPageSize(array(70, $h), $pdf->DefOrientation);
        $pdf->WriteHTML($html);
        $file_name = substr($key, 0, 6) . $id;
        $pdf->Output('userfiles/pos_temp/' . $file_name . '.pdf', 'F');
        if (!extension_loaded('imagick')) {
            echo 'imagick not installed';
        }
        $im = new Imagick();
        $im->setResolution(300, 300);
        $im->readimage(FCPATH . 'userfiles/pos_temp/' . $file_name . '.pdf');
        $im->setImageType(imagick::IMGTYPE_TRUECOLOR);
        $im->setImageFormat('png');
        //$im->transparentPaintImage(      'white', 0, 100, false    );
        $im->writeImage(FCPATH . 'userfiles/pos_temp/rest-' . $file_name . '.png');
        $im->clear();
        $im->destroy();
        unlink('userfiles/pos_temp/' . $data['qrc']);
        unlink(FCPATH . 'userfiles/pos_temp/' . $file_name . '.pdf');
    }

    public function invoiceclean()
    {
        $file_name = substr($this->input->get('key'), 0, 6) . $this->input->get('id');
        unlink(FCPATH . 'userfiles/pos_temp/' . $file_name . '.png');
    }

    public function view_payslip()
    {
        $id = $this->input->get('id');
        $inv = $this->input->get('inv');
        $data['invoice'] = $this->invocies->invoice_details($inv, $this->limited);
        if (!$data['invoice']['id'])
            exit('Limited Permissions!');

        $this->load->model('transactions_model', 'transactions');
        $head['title'] = "Ver transacción";
        $head['usernm'] = $this->aauth->get_user()->username;

        $data['trans'] = $this->transactions->view($id);

        if ($data['trans']['payerid'] > 0) {
            $data['cdata'] = $this->transactions->cview($data['trans']['payerid'], $data['trans']['ext']);
        } else {
            $data['cdata'] = array('address' => 'No registrado', 'city' => '', 'phone' => '', 'email' => '');
        }
        ini_set('memory_limit', '64M');

        $html = $this->load->view('transactions/view-print-customer', $data, true);

        //PDF Rendering
        $this->load->library('pdf');

        $pdf = $this->pdf->load_en();

        $pdf->SetHTMLFooter('<table width="100%" style="vertical-align: bottom; font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;"><tr><td width="33%"></td><td width="33%" align="center" style="font-weight: bold; font-style: italic;">{PAGENO}/{nbpg}</td><td width="33%" style="text-align: right; ">#' . $id . '</td></tr></table>');

        $pdf->WriteHTML($html);

        if ($this->input->get('d')) {

            $pdf->Output('Trans_#' . $id . '.pdf', 'D');
        } else {
            $pdf->Output('Trans_#' . $id . '.pdf', 'I');
        }
    }

    public function invoice_legacy()
    {
        $this->load->helper('convertir');
        $this->load->helper('pdf');
        $id = $this->input->post('inv');
        $d = $this->input->post('d');
        
        if (!$id) {
            exit('eer');
        }

        $tid = $id;
        $data['qrc'] = '.png';
        $data['id'] = $tid;
        $data['title'] = "Comprobante $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid);

        if ($data['invoice']) $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']) $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        if ($data['invoice']['tipocomprobante'] == 'B') {

            $num = '03';
            //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        } else if ($data['invoice']['tipocomprobante'] == 'F') {

            $num = '01';
            //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        } else {

            $num = '01';
        }
        $data['loc'] = location($data['invoice']['loc']);
        $data['leyenda'] = '';
        $data['qrc'] = $data['loc']['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';

        $data['logo'] = $data['loc']['logo'];
        $data['moneda'] = $data['loc']['currency'];
        $data['d'] = $d;
        ini_set('memory_limit', '64M');
        $base64 = $this->ticket($data);

        echo  json_encode(array('status' => 'Success', 'base64' => $base64));
    }
    public function invoice_clean()
    {
        $file_id = $this->input->post('file_id', true);
        unlink(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_id . '.png');
        unlink(FCPATH . 'userfiles' . DIRECTORY_SEPARATOR . 'pos_temp' . DIRECTORY_SEPARATOR . $file_id . '.pdf');
    }

public function ticket($data){
        ob_start();
tcpdf();

$estilo = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => '0');
$medidas = array(80, 890);
$obj_pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $medidas, true, 'UTF-8', false);
$obj_pdf->SetCreator(PDF_CREATOR);
$obj_pdf->SetTitle($data['invoice']['nombre_docu']);
$obj_pdf->SetHeaderData($data['logo'], 45, '', '','', '', '');
$obj_pdf->setHeaderFont(Array('dejavusans', '', 10));
$obj_pdf->SetDefaultMonospacedFont('dejavusans');
$obj_pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$obj_pdf->setPrintFooter(false);
$obj_pdf->SetMargins(2, 35, 2);
$obj_pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->setFontSubsetting(false);
$obj_pdf->AddPage();

$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', 'B', 10);
$obj_pdf->SetXY(0, $posicion);
$obj_pdf->MultiCell(80, 0, $data['loc']['cname'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);
$obj_pdf->SetX(0, $posicion + 17);
$obj_pdf->MultiCell(80, 0, "RUC " . $data['loc']['ruc'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', '', 8);

$obj_pdf->MultiCell(75, 0, strtoupper($data['loc']['address'] . ' ' . $data['loc']['country'] . '  ' . $data['loc']['region']. '  ' . $data['loc']['city']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$obj_pdf->SetFont('dejavusans', '', 7);
$obj_pdf->MultiCell(75, 0, strtoupper($data['loc']['descripcion']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$obj_pdf->MultiCell(75, 0, strtoupper($data['loc']['phone']), 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);

$obj_pdf->MultiCell(80, 0, $data['invoice']['nombre_docu'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetFont('dejavusans', 'B', 10);

$obj_pdf->MultiCell(80, 0, $data['invoice']['serie'] . "-" . $data['invoice']['tid'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$posicion = $obj_pdf->GetY();

$obj_pdf->Line(2, $posicion + 3, 78, $posicion + 3, $estilo);
$posicion += 6;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "RUC/DNI:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(20, $posicion);
$obj_pdf->Cell(2, 0, $data['invoice']['numdoc'], 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(40, $posicion);

$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $posicion);
$obj_pdf->Cell(2, 0, "CLIENTE:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $posicion);
$obj_pdf->MultiCell(55, 0, $data['invoice']['name'], 0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$hg = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $hg+1);
$obj_pdf->Cell(2, 0, "DIRECCIÓN:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $hg+1);
$obj_pdf->MultiCell(55, 0, $data['invoice']['address'],0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
$ht = $obj_pdf->GetY();
$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $ht+1);
$obj_pdf->Cell(2, 0, "F. EMISIÓN:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $ht+1);
$obj_pdf->Cell(2, 0, $data['invoice']['invoicedate'], 0, 0, 'L');

$posicion += 5;
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->SetXY(2, $ht+6);
$obj_pdf->Cell(2, 0, "MONEDA:", 0, 0, 'L');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(25, $ht+6);
$obj_pdf->Cell(2, 0, $data['invoice']['moneda'], 0, 0, 'L');

$posicion += 5;
$obj_pdf->Line(2, $ht+11, 78, $ht+11, $estilo);

$posicion += 2;
$obj_pdf->SetXY(2, $ht+14);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, 'ARTICULO                            P/U        IMP.');


$posicion += 5;
$obj_pdf->setY($ht+19);

foreach ($data['products'] as $fila) {
    $obj_pdf->setX(2);
    $obj_pdf->SetFont('dejavusans', '', 8);
    $obj_pdf->setX(18);
    $obj_pdf->Cell(42, 0, number_format($fila["price"], 2, ".", ","), 0, 0, "R");
    $obj_pdf->setX(32);
    $obj_pdf->Cell(44, 0, number_format($fila["subtotal"], 2, ".", ","), 0, 0, "R");
    $obj_pdf->setX(2);
    $obj_pdf->MultiCell(45, 0, strtoupper(substr('['.$fila["qty"].'] '.$fila["product"], 0, 80)), 0, 'L', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
}
$h = $obj_pdf->GetY();
$obj_pdf->Line(2, $h + 2, 78, $h + 2, $estilo);
$obj_pdf->setY($h + 3);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "SUB TOTAL:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $data['moneda'], 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($data['invoice']['subtotal'], 2), 0, 0, 'R');

$obj_pdf->Line(2, $h + 2, 78, $h + 2, $estilo);

//$obj_pdf->setY($h + 7);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. GRAVADAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $data['moneda'] .' '.number_format($gravadas, 2), 0, 0, 'R');

$obj_pdf->setY($h + 7);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "OP. EXONERADAS:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $data['moneda'], 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($data['invoice']['subtotal'], 2), 0, 0, 'R');

//$obj_pdf->setY($h + 15);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. INAFECTAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $data['moneda'].' '. number_format($inafectas, 2), 0, 0, 'R');

//$obj_pdf->setY($h + 19);
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(2, 4, "OP. GRATUITAS:", 0, 0, 'L');
//$obj_pdf->SetFont('dejavusans', '', 9);
//$obj_pdf->Cell(72, 4, $data['moneda'].' '.number_format($gratuitas, 2), 0, 0, 'R');

$obj_pdf->setY($h + 11);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "IGV:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $data['moneda'], 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($data['invoice']['tax'], 2), 0, 0, 'R');

$obj_pdf->setY($h + 15);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "ICBPER:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $data['moneda'], 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($data['invoice']['icbper'], 2), 0, 0, 'R');

$obj_pdf->setY($h + 19);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 4, "DESC. GLOBAL:", 0, 0, 'L');
$obj_pdf->Cell(58, 4, $data['moneda'], 0, 0, 'R');
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(16, 4, number_format($data['invoice']['discount'], 2), 0, 0, 'R');

$obj_pdf->setY($h + 23);
$obj_pdf->SetFont('dejavusans', 'B', 11);

$obj_pdf->MultiCell(76, 4, 'TOTAL: '. $data['moneda'] .' '. number_format($data['invoice']['total'], 2), 0, 'R', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->SetX(1);

$obj_pdf->setXY(2,$h + 27);
$obj_pdf->SetFont('dejavusans', '', 8);
$obj_pdf->SetX(2);
$obj_pdf->Cell(2, 6, 'SON: ' . num_to_letras($data['invoice']['total'], $data['invoice']['moneda']), 0, 0, 'L');
$obj_pdf->setXY(2,$h + 33);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "COND. DE PAGO:", 0, 0, 'L');
$obj_pdf->setXY(33,$h + 33);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $data['invoice']['title'], 0, 0, 'L');

$obj_pdf->setXY(2,$h + 37);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "PAGÓ CON:", 0, 0, 'L');
$obj_pdf->setXY(25,$h + 37);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $data['moneda'].' '.$data['invoice']['efectivo'], 0, 0, 'L');

$obj_pdf->setXY(2,$h + 41);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "VUELTO:", 0, 0, 'L');
$obj_pdf->setXY(20,$h + 41);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $data['moneda'].' '. number_format($data['invoice']['vuelto'], 2), 0, 0, 'L');

$obj_pdf->setXY(2,$h + 45);
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->Cell(2, 0, "USUARIO: ", 0, 0, 'L');
$obj_pdf->setXY(20,$h + 45);
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->Cell(2, 0, $data['employee']['name'], 0, 0, 'L');
if($data['invoice']['idtipocomprobante'] == 'N'){
    $heigth = $obj_pdf->GetY();
}else{


$heigth = $obj_pdf->GetY();
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // width of a single module in points
    'module_height' => 1 // height of a single module in points
);
$obj_pdf->write2DBarcode($data['qrc'], 'QRCODE,Q', 27, $heigth+5, 30, 30, $style, 'N');
$heigth = $obj_pdf->GetY();
$obj_pdf->SetFont('dejavusans', '', 9);
$obj_pdf->SetXY(0, $heigth);
$obj_pdf->MultiCell(80, 0, $data['invoice']['hash'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
}
if($data['invoice']['idtipocomprobante'] == 'N'){
   $espacio = 5;
}else{
    $obj_pdf->setXY(2, $heigth + 5);
    $obj_pdf->SetFont('dejavusans', '', 8);
    $obj_pdf->MultiCell(76, 0, 'REPRESENTACIÓN IMPRESA DE LA ' . $data['invoice']['nombre_docu']. '. PARA CONSULTAR EL COMPROBANTE VISITA '. $data['loc']['web'], 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
    
    $obj_pdf->setXY(0, $heigth + 22);
    $obj_pdf->SetFont('dejavusans', 'B', 8);
    $obj_pdf->MultiCell(76, 0, 'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
    $espacio = 34;
}
$obj_pdf->setXY(2,$heigth + $espacio);
$obj_pdf->SetFont('dejavusans', 'B', 8);
if ($data['loc']['ruc'] === '10011249006') {
    $n = '24';
} else {
    $n = '72';
}
$obj_pdf->MultiCell(75, 0, "NOTA: Estimado cliente, le recordamos que, pasadas las ". $n ." horas de recibida las existencias, no hay lugar "
        . "a reclamo.", 0, 'C',0,1,'','',true,0,false,true,0,'T',false);
$obj_pdf->setXY(0, $heigth + ($espacio + 13));
$obj_pdf->SetFont('dejavusans', 'B', 9);
$obj_pdf->MultiCell(80, 0, '¡GRACIAS POR SU PREFERENCIA!', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

$obj_pdf->setXY(0, $heigth + ($espacio + 21));
$obj_pdf->SetFont('dejavusans', '', 7);
$obj_pdf->MultiCell(80, 0, '-- POWERED BY STARTFACT.COM.PE --', 0, 'C', 0, 1, '', '', true, 0, false, true, 0, 'T', false);

ob_end_clean();

if ($data['d'] == 0){
    $obj_pdf->Output(FCPATH . 'userfiles/pos_temp/' .$data['invoice']['serie'] . "-" . $data['invoice']['tid'].'.pdf','I');
    
} else {
   return base64_encode($obj_pdf->Output($data['invoice']['serie'] . "-" . $data['invoice']['tid'].'.pdf','S'));
    
}
    }
}