<?php

defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        $this->load->library("Aauth");
        $this->load->model('export_model', 'export');
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
            exit;
        }

        if ($this->aauth->get_user()->roleid < 5) {

            exit('Not Allowed!');
        }
        $this->date = 'backup_' . date('Y_m_d_H_i_s');
        $this->load->library("Registerlog");


    }


    function products()
    {
        $this->load->helper(array('form'));
        $this->load->model('categories_model');
        $head['title'] = "Importar Productos";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['cat'] = $this->categories_model->category_list();
        $data['warehouse'] = $this->categories_model->warehouse_list();
        $this->load->view('fixed/header', $head);
        $this->load->view('import/products', $data);
        $this->load->view('fixed/footer');

    }

    public function products_upload()
    {

        $this->load->helper(array('form'));
        $data['response'] = 3;
        $head['usernm'] = $this->aauth->get_user()->username;
        $head['title'] = 'Importar Productos';

        $this->load->view('fixed/header', $head);

        if ($this->input->post('product_cat', true)) {
            $data['pc'] = $this->input->post('product_cat', true);
            $data['wid'] = $this->input->post('product_warehouse', true);
            $config['upload_path'] = './userfiles';
            $config['allowed_types'] = 'csv';
            $config['max_size'] = 6000;
            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('userfile')) {
                $data['response'] = 0;
                $data['responsetext'] = 'File Upload Error';

            } else {
                $data['response'] = 1;
                $data['responsetext'] = 'Document Uploaded Successfully.';
                $data['filename'] = $this->upload->data()['file_name'];

            }

            $this->load->view('import/wizard', $data);
        } else {


            echo ' error';


        }
        $this->load->view('fixed/footer');


    }


    public function start_process()
    {
        require APPPATH . 'third_party/vendor/autoload.php';

        $name = $this->input->post('name');
        $pcat = $this->input->post('pc');
        $warehouse = $this->input->post('wid');
        $inputFileName = FCPATH . 'userfiles/' . $name;

        $spreadsheet = IOFactory::load($inputFileName);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, false);
//print_r($sheetData);

        $products = array();

        foreach ($sheetData as $row) {
            
            $barcode = rand(100, 999) . '-' . rand(0, 9) . '-' . rand(1000000, 9999999) . '-' . rand(0, 9);

            $products[] = array(
                'pid' => null,
                'pcat' => $pcat,
                'warehouse' => $warehouse,
                'product_name' => $row[0],
                'product_code' => $row[1],
                'product_price' => $row[2],
                'precio_min' => $row[3],
                'fproduct_price' => $row[4],
                'taxrate' => 0,
                'disrate' => $row[5],
                'qty' => $row[6],
                'product_des' => $row[7],
                'alert' => $row[8],
                'unit' => $row[9],
                'barcode' => $barcode,                
                'talla' => $row[10],
                'tipo' => $row[11],
                'codigosunat' => $row[12],
                'idtipoexistencia' => $row[13],
                'color' => $row[14],
                'marca' => $row[15],
                'top' => 0,
                'destacado' => 0
            );


        }
        unlink(FCPATH . 'userfiles/' . $name);
        if (count($sheetData[0]) == 16) {
            $out = $this->db->insert_batch('jsoft_products', $products);
            if ($out) {
                echo json_encode(array('status' => 'Success', 'message' =>
                    "¡Los datos del producto se importaron correctamente!"));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    "¡Error de importación de la base de datos! Utilice la codificación adecuada del archivo y su contenido."));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                "Corrija el formato del archivo CSV, debe ser según la plantilla."));
        }


    }


    //customer


    function customers()
    {
        $this->load->helper(array('form'));
        $this->load->model('categories_model');
        $head['title'] = "Importar Cientes";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['cat'] = $this->categories_model->category_list();
        $data['warehouse'] = $this->categories_model->warehouse_list();
        $this->load->view('fixed/header', $head);
        $this->load->view('import/customers', $data);
        $this->load->view('fixed/footer');

    }

    public function customers_upload()
    {

        $this->load->helper(array('form'));
        $data['response'] = 3;
        $head['usernm'] = $this->aauth->get_user()->username;
        $head['title'] = 'Importar Clientes';

        $this->load->view('fixed/header', $head);


        $config['upload_path'] = FCPATH . '/userfiles';
        $config['allowed_types'] = 'csv';
        $config['max_size'] = 6000;
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('userfile')) {
            $data['response'] = 0;
            $data['responsetext'] = 'File Upload Error';

        } else {
            $data['response'] = 1;
            $data['responsetext'] = 'Se cargó el documento con éxito.';
            $data['filename'] = $this->upload->data()['file_name'];
            $data['password_s'] = $this->input->post('c_password');
            $data['password_v'] = $this->input->post('c_password_static');

        }

        $this->load->view('import/wizard2', $data);

        $this->load->view('fixed/footer');

    }


    public function customers_start_process()
    {
        require APPPATH . 'third_party/vendor/autoload.php';
set_time_limit(300);
        $name = $this->input->post('name');
        $c_pass = $this->input->post('c_pass');
        $c_pass_v = $this->input->post('c_pass_v');

        $inputFileName = FCPATH . 'userfiles/' . $name;

        $spreadsheet = IOFactory::load($inputFileName);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, false);
//print_r($sheetData);

        $data = array();
        $data2 = array();

        $this->db->select('id');
        $this->db->from('jsoft_customers');
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $l_id = +$query->row()->id + 1;
        } else {
            $l_id = 1;
        }

        foreach ($sheetData as $row) {


            $data[] = array(
                'id' => $l_id,
                'name' => $row[0],
                'phone' => $row[1],
                'numdoc' => $row[2],
                'iddoc' => $row[3],
                'address' => $row[4],
                'city' => $row[5],
                'region' => $row[6],
                'country' => $row[7],
                'postbox' => $row[8],
                'email' => $row[9],
                'gid' => $row[10],
                'taxid' => $row[11],
                'company' => $row[12],
                'name_s' => $row[13],
                'phone_s' => $row[14],
                'email_s' => $row[15],
                'address_s' => $row[16],
                'city_s' => $row[17],
                'region_s' => $row[18],
                'country_s' => $row[19],
                'postbox_s' => $row[20]
            );

            if ($c_pass == 'random') {
                $temp_password = rand(200000, 999999);
                $pass = password_hash($temp_password, PASSWORD_DEFAULT);
            } else {
                $pass = password_hash($c_pass_v, PASSWORD_DEFAULT);
            }

            $data2[] = array(
                'users_id' => null,
                'user_id' => 1,
                'status' => 'active',
                'is_deleted' => 0,
                'name' => $row[0],
                'password' => $pass,
                'email' => $row[9],
                'profile_pic' => null,
                'user_type' => 'Member',
                'cid' => $l_id
            );
            $l_id++;


        }
        // unlink(FCPATH . 'userfiles/' . $name);
        if (count($sheetData[0]) == 21) {
            $out = $this->db->insert_batch('jsoft_customers', $data);
            $out = $this->db->insert_batch('users', $data2);
            if ($out) {
                echo json_encode(array('status' => 'Success', 'message' =>
                    "¡Los datos del cliente se importaron correctamente!"));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    "¡Error de importación de la base de datos! Utilice la codificación adecuada del archivo y su contenido."));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                "Corrija el formato del archivo CSV, debe ser según la plantilla."));
        }


    }


}