<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Guia_remision extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('pos_invoices_model', 'invocies');
        $this->load->model('guia_model', 'guia');
        $this->load->model('products_model', 'products');
        $this->load->model('customers_model', 'clientes');
        $this->load->model('extended_invoices_model', 'extended_invoice');
        $this->load->library("Aauth");
        $this->load->library("Registerlog");
        $this->load->library("Common");

        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(1)) {
            exit('<h3>¡Lo sentimos! No tiene permisos suficientes para acceder a esta sección.</h3>');
        }
        if ($this->aauth->get_user()->roleid == 2) {
            $this->limited = $this->aauth->get_user()->id;
        } else {
            $this->limited = '';
        }
        $this->load->library("Custom");
        $this->li_a = 'sales';
    }

public function printguia()
    {
        $this->load->helper('convertir');
        $tid = $this->input->get('id');
        $data['id'] = $tid;
        $data['round_off'] = $this->custom->api_config(4);
        $data['guia'] = $this->guia->guia_details($tid, $this->limited);
        $data['employee'] = $this->invocies->employee($data['guia']['user_id']);

        if ($data['guia']['id'])
            $data['products'] = $this->guia->guia_products($tid);
        if ($data['guia']['id'])
            $data['employee'] = $this->invocies->employee($data['guia']['user_id']);
        
        
        
            $data['tipocomprobante'] = $data['guia']['nombre_docu'];
            $num = $data['guia']['numtipo_comprobante'];
           
        $loc = location($data['guia']['loc']);
        $data['leyenda'] = '';
        $data['qr'] = $loc['ruc'] . '|' . $num . '|' . $data['guia']['serie'] . '|' . $data['guia']['correlativo'] . '|' . ' ' . '|' . $data['guia']['total'] . '|' . $data['guia']['fecha_emision'] . '|' . $data['guia']['doccliente'] . '|' . $data['guia']['numdoc'] . '|' . $data['guia']['hash'] . '|';
        $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
        ini_set('memory_limit', '64M');
        
        $html = $this->load->view('print_files/guia-a4_v' . INVV, $data, true);
        
        //Representación de PDF
        $this->load->library('pdf');
        if (INVV == 1) {
            $header = $this->load->view('print_files/guia-header_v' . INVV, $data, true);
            $pdf = $this->pdf->load_split(array('margin_top' => 40));
            $pdf->SetHTMLHeader($header);
        }
        if (INVV == 2) {
            $pdf = $this->pdf->load_split(array('margin_top' => 5));
        }
        $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
        $pdf->WriteHTML($html);
        if ($this->input->get('d')) {
            $pdf->Output($data['guia']['nomarchivo'] . '.pdf', 'D');
        } else {
            $pdf->Output($data['guia']['nomarchivo'] . '.pdf', 'I');
        }
    }

}