<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Communication extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('communication_model');
        $this->load->library("Aauth");        
        $this->load->model('pos_invoices_model', 'invocies');
        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if ($this->aauth->get_user()->roleid == 2) {
            $this->limited = $this->aauth->get_user()->id;
        } else {
            $this->limited = '';
        }
        $this->load->library("Custom");
        $this->load->library("Registerlog");
    }

    public function send_invoice()
    {
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }
        $mailtoc = $this->input->post('mailtoc');
        $mailtotilte = $this->input->post('customername');
        $subject = $this->input->post('subject');

        $message = $this->input->post('message');
        $att = true;
        $attachmenttrue = false;
        $attachment = '';
        if ($att) {
            $tid = $this->input->post('tid');
            $attachmenttrue = true;
            
            $attachment = $this->mail_attach($tid);
        }
        
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        
        
        $nombre = $data['invoice']['nomarchivo'].'.pdf';

        $this->communication_model->send_email($mailtoc, $mailtotilte, $subject, $message, $nombre, $attachmenttrue, $attachment);
//        if ($att) {
//            unlink(FCPATH . DIRECTORY_SEPARATOR . 'userfiles' . DIRECTORY_SEPARATOR . 'temp' . DIRECTORY_SEPARATOR . 'Invoice_' . $tid . '.pdf');
//        }
    }

    public function send_general()
    {
        $mailtoc = $this->input->post('mailtoc');
        $mailtotilte = $this->input->post('customername');
        $subject = $this->input->post('subject');
        $message = $this->input->post('text');
        $attachmenttrue = false;
        $attachment = '';
        $this->communication_model->send_email($mailtoc, $mailtotilte, $subject, $message, $attachmenttrue, $attachment);
    }


    private function mail_attach($tid)
    {
        
        $this->load->helper('convertir');
        
        $data['id'] = $tid;
        $data['round_off'] = $this->custom->api_config(4);
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);

        if ($data['invoice']['id'])
            $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id'])
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
        if (CUSTOM)
            $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1, 1);
        if ($data['invoice']['i_class'] == 1) {
            $pref = prefix(7);
        } else {
            $pref = $this->config->item('prefix');
        }
        if ($data['invoice']['tipocomprobante'] == 'B') {
            $data['tipocomprobante'] = 'BOLETA <br> ELECTŔONICA';
            $num = '03';
            //$head['title'] = "BOLETA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        } else {
            $data['tipocomprobante'] = 'FACTURA <br> ELECTŔONICA';
            $num = '01';
            //$head['title'] = "FACTURA ELECTŔONICA " . $data['invoice']['serie']. '-' .$data['invoice']['tid'];
        }
        $loc = location($data['invoice']['loc']);
        $data['leyenda'] = '';
        $data['qr'] = $loc['ruc'] . '|' . $num . '|' . $data['invoice']['serie'] . '|' . $data['invoice']['tid'] . '|' . $data['invoice']['tax'] . '|' . $data['invoice']['total'] . '|' . $data['invoice']['invoicedate'] . '|' . $data['invoice']['doccliente'] . '|' . $data['invoice']['numdoc'] . '|' . $data['invoice']['hash'] . '|';
        $data['general'] = array('title' => $data['tipocomprobante'], 'person' => $this->lang->line('Customer'), 'prefix' => $pref, 't_type' => 0);
        ini_set('memory_limit', '64M');
        if ($data['invoice']['taxstatus'] == 'cgst' || $data['invoice']['taxstatus'] == 'igst') {
            $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
        } else {
            $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
        }
        //PDF Rendering
        $this->load->library('pdf');
        if (INVV == 1) {
            $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
            $pdf = $this->pdf->load_split(array('margin_top' => 40));
            $pdf->SetHTMLHeader($header);
        }
        if (INVV == 2) {
            $pdf = $this->pdf->load_split(array('margin_top' => 5));
        }
        $pdf->SetHTMLFooter('<div style="text-align: center;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">Powered by <strong>JSoft</strong></div><div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg}</div>');
        $pdf->WriteHTML($html);
        
        return $pdf->Output('', 'S');
        //   return $pdf->Output('Invoice_' . $data['invoice']['tid'] . '.pdf', 'S');


    }


}